/*
 * Decompiled with CFR 0.152.
 */
package suning.service.controller;

import com.suning.api.entity.govbus.ApplyRejectedAddRequest;
import com.suning.api.entity.govbus.ConfirmOrderAddRequest;
import com.suning.api.entity.govbus.OrderAddRequest;
import com.suning.api.entity.govbus.OrderDetailGetRequest;
import com.suning.api.entity.govbus.OrderStatusGetRequest;
import com.suning.api.entity.govbus.RejectOrderDeleteRequest;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import suning.service.service.SnOrderService;
import utils.log.Log;
import utils.log.Logs;

@Controller
@RequestMapping(value={"order"})
public class SnOrderController {
    private static final Log log = Logs.getLog((String)SnOrderController.class.getName());
    @Value(value="${suning.api.initPassword}")
    private String password;
    @Autowired
    SnOrderService snOrderService;

    @RequestMapping(value={"addOrder"}, method={RequestMethod.GET})
    @ResponseBody
    public Map addOrder(String password) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (!StringUtils.equals((CharSequence)this.password, (CharSequence)password)) {
            returnMap.put("message", "error password");
            return returnMap;
        }
        OrderAddRequest request = new OrderAddRequest();
        return this.snOrderService.addOrder(request);
    }

    @RequestMapping(value={"addApplyRejected"}, method={RequestMethod.GET})
    @ResponseBody
    public Map addApplyRejected(String password, String orderId) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (!StringUtils.equals((CharSequence)this.password, (CharSequence)password)) {
            returnMap.put("message", "error password");
            return returnMap;
        }
        ApplyRejectedAddRequest request = new ApplyRejectedAddRequest();
        request.setOrderId(orderId);
        return this.snOrderService.addApplyRejected(request);
    }

    @RequestMapping(value={"addConfirmOrder"}, method={RequestMethod.GET})
    @ResponseBody
    public Map addConfirmOrder(String password, String orderId) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (!StringUtils.equals((CharSequence)this.password, (CharSequence)password)) {
            returnMap.put("message", "error password");
            return returnMap;
        }
        ConfirmOrderAddRequest request = new ConfirmOrderAddRequest();
        request.setOrderId(orderId);
        return this.snOrderService.addConfirmOrder(request);
    }

    @RequestMapping(value={"batchConfirmOrder"}, method={RequestMethod.GET})
    @ResponseBody
    public Map batchConfirmOrder(String password, String[] orderids) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (!StringUtils.equals((CharSequence)this.password, (CharSequence)password)) {
            returnMap.put("message", "error password");
            return returnMap;
        }
        ConfirmOrderAddRequest request = new ConfirmOrderAddRequest();
        for (int i = 0; i < orderids.length; ++i) {
            String orderId = orderids[i];
            request.setOrderId(orderId);
            returnMap.put(orderId, this.snOrderService.addConfirmOrder(request));
        }
        return returnMap;
    }

    @RequestMapping(value={"deleteRejectOrder"}, method={RequestMethod.GET})
    @ResponseBody
    public Map deleteRejectOrder(String password, String orderId) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (!StringUtils.equals((CharSequence)this.password, (CharSequence)password)) {
            returnMap.put("message", "error password");
            return returnMap;
        }
        RejectOrderDeleteRequest request = new RejectOrderDeleteRequest();
        request.setOrderId(orderId);
        return this.snOrderService.deleteRejectOrder(request);
    }

    @RequestMapping(value={"getOrderDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public Map getOrderDetail(String password, String orderId) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (!StringUtils.equals((CharSequence)this.password, (CharSequence)password)) {
            returnMap.put("message", "error password");
            return returnMap;
        }
        OrderDetailGetRequest request = new OrderDetailGetRequest();
        request.setOrderId(orderId);
        return this.snOrderService.getOrderDetail(request);
    }

    @RequestMapping(value={"getOrderStatus"}, method={RequestMethod.GET})
    @ResponseBody
    public Map getOrderStatus(String password, String orderId) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (!StringUtils.equals((CharSequence)this.password, (CharSequence)password)) {
            returnMap.put("message", "error password");
            return returnMap;
        }
        OrderStatusGetRequest request = new OrderStatusGetRequest();
        request.setOrderId(orderId);
        returnMap.put("result", (String)this.snOrderService.getOrderStatus(request));
        return returnMap;
    }

    @RequestMapping(value={"/cancelOrder"})
    @ResponseBody
    public Map cancelOrder(@RequestParam(name="snOrderIds[]", required=true) String[] snOrderIds) {
        HashMap<String, Map> returnMap = new HashMap<String, Map>();
        for (int i = 0; i < snOrderIds.length; ++i) {
            RejectOrderDeleteRequest request = new RejectOrderDeleteRequest();
            request.setOrderId(snOrderIds[i]);
            returnMap.put(snOrderIds[i], this.snOrderService.deleteRejectOrder(request));
        }
        return returnMap;
    }
}

