/*
 * Decompiled with CFR 0.152.
 */
package suning.service.controller;

import com.suning.api.entity.govbus.PriceQueryRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import suning.service.service.SnPriceService;
import utils.Lang;
import utils.log.Log;
import utils.log.Logs;

@Controller
@RequestMapping(value={"price"})
public class SnPriceController {
    private static final Log log = Logs.getLog((String)SnPriceController.class.getName());
    @Value(value="${suning.api.initPassword}")
    private String password;
    @Autowired
    SnPriceService snPriceService;

    @RequestMapping(value={"queryPrice"}, method={RequestMethod.GET})
    @ResponseBody
    public Map queryPrice(@RequestParam(name="skus[]", required=true) String[] skus, String password, String cityId) {
        HashMap<String, Map> returnMap = new HashMap<String, Map>();
        if (Lang.isEmpty((Object)cityId)) {
            cityId = "010";
        }
        for (int i = 0; i < skus.length; ++i) {
            PriceQueryRequest request = new PriceQueryRequest();
            request.setCityId(cityId);
            ArrayList<PriceQueryRequest.Skus> skuses = new ArrayList<PriceQueryRequest.Skus>();
            PriceQueryRequest.Skus skuIds = new PriceQueryRequest.Skus();
            skuIds.setSkuId(skus[i]);
            skuses.add(skuIds);
            request.setSkus(skuses);
            returnMap.put(skus[i], this.snPriceService.queryPrice(request));
        }
        return returnMap;
    }
}

