/*
 * Decompiled with CFR 0.152.
 */
package suning.service.controller;

import com.suning.api.entity.govbus.FacProductConfirmRequest;
import com.suning.api.entity.govbus.OrderStatusGetRequest;
import com.suning.api.entity.govbus.OrderStatusGetResponse;
import com.suning.api.entity.govbus.OrderlogistnewGetRequest;
import com.suning.api.entity.govbus.ShipCarriageGetRequest;
import com.suning.api.entity.govbus.ShipTimeGetRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import suning.service.service.SnOrderService;
import suning.service.service.SnShippingService;
import utils.Lang;
import utils.log.Log;
import utils.log.Logs;

@Controller
@RequestMapping(value={"shipping"})
public class SnShippingController {
    private static final Log log = Logs.getLog((String)SnShippingController.class.getName());
    @Value(value="${suning.api.initPassword}")
    private String password;
    @Autowired
    SnShippingService snShippingService;
    @Autowired
    SnOrderService snOrderService;

    @RequestMapping(value={"getOrderLogist"}, method={RequestMethod.GET})
    @ResponseBody
    public Map getOrderLogist(String password, String orderId) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (!StringUtils.equals((CharSequence)this.password, (CharSequence)password)) {
            returnMap.put("message", "error password");
            return returnMap;
        }
        OrderlogistnewGetRequest request = new OrderlogistnewGetRequest();
        OrderStatusGetRequest orderStatusGetRequest = new OrderStatusGetRequest();
        orderStatusGetRequest.setOrderId(orderId);
        OrderStatusGetResponse orderStatusGetResponse = this.snOrderService.getOrderStatus(orderStatusGetRequest);
        ArrayList<OrderlogistnewGetRequest.OrderItemIds> orderItemListList = new ArrayList<OrderlogistnewGetRequest.OrderItemIds>();
        if (orderStatusGetResponse != null && Lang.isEmpty((Object)orderStatusGetResponse.getSnerror().getErrorCode())) {
            request.setOrderId(orderId);
            for (OrderStatusGetResponse.OrderItemInfoList oil : orderStatusGetResponse.getSnbody().getGetOrderStatus().getOrderItemInfoList()) {
                OrderlogistnewGetRequest.OrderItemIds oiids = new OrderlogistnewGetRequest.OrderItemIds();
                oiids.setOrderItemId(oil.getOrderItemId());
                oiids.setSkuId(oil.getSkuId());
                orderItemListList.add(oiids);
            }
            request.setOrderItemIds(orderItemListList);
            return this.snShippingService.getOrderLogistNew(request);
        }
        returnMap.put("result", (String)orderStatusGetResponse);
        return returnMap;
    }

    @RequestMapping(value={"getShipTime"}, method={RequestMethod.GET})
    @ResponseBody
    public Map getShipTime(String password) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (!StringUtils.equals((CharSequence)this.password, (CharSequence)password)) {
            returnMap.put("message", "error password");
            return returnMap;
        }
        ShipTimeGetRequest request = new ShipTimeGetRequest();
        return this.snShippingService.getShipTime(request);
    }

    @RequestMapping(value={"getShipCarriage"}, method={RequestMethod.GET})
    @ResponseBody
    public Map getShipCarriage(String password) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (!StringUtils.equals((CharSequence)this.password, (CharSequence)password)) {
            returnMap.put("message", "error password");
            return returnMap;
        }
        ShipCarriageGetRequest request = new ShipCarriageGetRequest();
        return this.snShippingService.getShipCarriage(request);
    }

    @RequestMapping(value={"confirmFacProduct"}, method={RequestMethod.GET})
    @ResponseBody
    public Map confirmFacProduct(String password) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (!StringUtils.equals((CharSequence)this.password, (CharSequence)password)) {
            returnMap.put("message", "error password");
            return returnMap;
        }
        FacProductConfirmRequest request = new FacProductConfirmRequest();
        return this.snShippingService.confirmFacProduct(request);
    }
}

