/*
 * Decompiled with CFR 0.152.
 */
package suning.service.controller;

import com.suning.api.entity.govbus.InventoryGetRequest;
import com.suning.api.entity.govbus.MpStockQueryRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import suning.service.service.SnStockService;
import utils.Lang;
import utils.log.Log;
import utils.log.Logs;

@Controller
@RequestMapping(value={"stock"})
public class SnStockController {
    private static final Log log = Logs.getLog((String)SnStockController.class.getName());
    @Value(value="${suning.api.initPassword}")
    private String password;
    @Autowired
    SnStockService snStockService;

    @RequestMapping(value={"getInventory"}, method={RequestMethod.GET})
    @ResponseBody
    public Map getInventory(String password) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (!StringUtils.equals((CharSequence)this.password, (CharSequence)password)) {
            returnMap.put("message", "error password");
            return returnMap;
        }
        HashMap map = new HashMap();
        return map;
    }

    @RequestMapping(value={"queryInvoice"}, method={RequestMethod.GET})
    @ResponseBody
    public Map queryInvoice(@RequestParam(value="skuid") String skuid, String password) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (!StringUtils.equals((CharSequence)this.password, (CharSequence)password)) {
            returnMap.put("message", "error password");
            return returnMap;
        }
        InventoryGetRequest request = new InventoryGetRequest();
        ArrayList<InventoryGetRequest.SkuIds> skuIdses = new ArrayList<InventoryGetRequest.SkuIds>();
        InventoryGetRequest.SkuIds skuIds = new InventoryGetRequest.SkuIds();
        skuIds.setSkuId(skuid);
        skuIdses.add(skuIds);
        request.setSkuIds(Arrays.asList(skuIds));
        request.setCityId("010");
        request.setCountyId("10");
        request.setCheckParam(true);
        return this.snStockService.getInventory(request);
    }

    @RequestMapping(value={"queryMprodStock"}, method={RequestMethod.GET})
    @ResponseBody
    public Map queryMprodStock(@RequestParam(value="skuid") String skuid, String password) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (!StringUtils.equals((CharSequence)this.password, (CharSequence)password)) {
            returnMap.put("message", "error password");
            return returnMap;
        }
        MpStockQueryRequest request = new MpStockQueryRequest();
        ArrayList<MpStockQueryRequest.SkuIds> skuIdses = new ArrayList<MpStockQueryRequest.SkuIds>();
        MpStockQueryRequest.SkuIds skuIds = new MpStockQueryRequest.SkuIds();
        skuIds.setSkuId(skuid);
        skuIdses.add(skuIds);
        request.setSkuIds(skuIdses);
        request.setCityId("010");
        request.setCheckParam(true);
        return this.snStockService.queryMprodStock(request);
    }

    @RequestMapping(value={"queryGoodsMprodStock"}, method={RequestMethod.GET})
    @ResponseBody
    public Map queryGoodsMprodStock(String password, String cityId, @RequestParam(name="skus[]", required=true) String[] skus) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (!StringUtils.equals((CharSequence)this.password, (CharSequence)password)) {
            returnMap.put("message", "error password");
            return returnMap;
        }
        if (Lang.isEmpty((Object)cityId)) {
            cityId = "010";
        }
        ArrayList params = new ArrayList();
        for (int i = 0; i < skus.length; ++i) {
            HashMap<String, String> addParams = new HashMap<String, String>();
            addParams.put("skuId", skus[i]);
            params.add(addParams);
        }
        returnMap.put("result", this.snStockService.queryGoodsMprodStock(params, cityId));
        return returnMap;
    }

    @RequestMapping(value={"queryGoodsInvoice"}, method={RequestMethod.GET})
    @ResponseBody
    public Map queryGoodsInvoice(String password) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (!StringUtils.equals((CharSequence)this.password, (CharSequence)password)) {
            returnMap.put("message", "error password");
            return returnMap;
        }
        ArrayList params = new ArrayList();
        returnMap.put("result", this.snStockService.getGoodsInventory(params, "010", "10"));
        return returnMap;
    }
}

