/*
 * Decompiled with CFR 0.152.
 */
package suning.service.dev;

import goods.model.ProductCategory;
import goods.model.repository.ProductCategoryRepos;
import java.io.File;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.Example;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import suning.model.TestMatchCategoryData;
import suning.model.repository.TMCDRepo;
import utils.Lang;
import utils.excel.ReadExcelUtil;
import utils.log.Log;
import utils.log.Logs;

@Component
@Profile(value={"dbInit"})
public class DbInit {
    private static final Log log = Logs.getLog((String)DbInit.class.getName());
    @Autowired
    ProductCategoryRepos productCategoryRepos;
    @Autowired
    TMCDRepo tMCDRepo;
    @Value(value="${suning.store.code}")
    private String sn_code;
    @Value(value="${suning.store.id}")
    private String sn_id;

    @PostConstruct
    @Transactional
    public void initData() {
        this.initMatchData();
    }

    public void initProductCategory() {
        log.info((Object)"\u521d\u59cb\u5316\u82cf\u5b81\u5206\u7c7b\u6570\u636e\u5f00\u59cb ========================= ");
        File file = new File("c:\\temp/\u82cf\u5b81\u5206\u7c7b.xlsx");
        try {
            List excel = ReadExcelUtil.readExcel((File)file);
            excel.remove(excel.get(0));
            int dataCount = 0;
            int querySuccessCount = 0;
            for (int i = 1; i < excel.size(); ++i) {
                List resultList = (List)excel.get(i);
                String categoryName = (String)resultList.get(4);
                ProductCategory queryProdCat = new ProductCategory();
                queryProdCat.setName(categoryName);
                queryProdCat.setLayerIndex(Integer.valueOf(3));
                List productCategorys = this.productCategoryRepos.findAll(Example.of((Object)queryProdCat));
                ProductCategory productCategory = null;
                if (!Lang.isEmpty((Object)productCategorys) && productCategorys.size() >= 0) {
                    ++querySuccessCount;
                    productCategory = (ProductCategory)productCategorys.get(0);
                    log.info((Object)("productCategoryName" + productCategory.getName()));
                } else {
                    productCategory = new ProductCategory();
                    productCategory.setLayerIndex(Integer.valueOf(1));
                    productCategory.setSourceCode(this.sn_code);
                    productCategory.setName(categoryName);
                    log.info((Object)("productCategoryName" + productCategory.getName()));
                    log.info((Object)("\u67e5\u8be2\u4e0d\u5230\uff0c\u5c06\u6570\u636e\u65b0\u589e\uff0c\u7136\u540e\u5c06\u5206\u7c7b\u4fe1\u606f\u8bb0\u5f55\u4e0b\u6765\uff0c\u4eba\u5de5\u7ef4\u62a4;\u5206\u7c7b\u540d\u79f0\uff1a" + categoryName));
                }
                ++dataCount;
            }
            log.info((Object)("querySuccessCount:" + querySuccessCount));
            log.info((Object)("dataCount:" + dataCount));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info((Object)"\u521d\u59cb\u5316\u82cf\u5b81\u5206\u7c7b\u6570\u636e\u5b8c\u6210 ========================= ");
    }

    public void initMatchData() {
        log.info((Object)"\u521d\u59cb\u5316\u82cf\u5b81\u5206\u7c7b\u6570\u636e\u5f00\u59cb ========================= ");
        File file = new File("c:\\temp/\u82cf\u5b81\u4eac\u4e1c\u5206\u7c7b\u5173\u8054.xlsx");
        try {
            List excel = ReadExcelUtil.readExcel((File)file);
            excel.remove(excel.get(0));
            excel.remove(excel.get(1));
            int dataCount = 0;
            int querySuccessCount = 0;
            for (int i = 0; i < excel.size(); ++i) {
                List resultList = (List)excel.get(i);
                String categorySnOneName = (String)resultList.get(0);
                String categorySnTwoName = (String)resultList.get(1);
                String categorySnThreeName = (String)resultList.get(2);
                String categoryJdOneName = (String)resultList.get(3);
                String categoryJdTwoName = (String)resultList.get(4);
                String categoryJdThreeName = (String)resultList.get(5);
                TestMatchCategoryData testMatchCategoryData = new TestMatchCategoryData(categorySnOneName, categorySnTwoName, categorySnThreeName, categoryJdOneName, categoryJdTwoName, categoryJdThreeName);
                this.tMCDRepo.save((Object)testMatchCategoryData);
                ++dataCount;
            }
            log.info((Object)("querySuccessCount:" + querySuccessCount));
            log.info((Object)("dataCount:" + dataCount));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info((Object)"\u521d\u59cb\u5316\u82cf\u5b81\u5206\u7c7b\u6570\u636e\u5b8c\u6210 ========================= ");
    }
}

