/*
 * Decompiled with CFR 0.152.
 */
package suning.service.service;

import com.suning.api.entity.govbus.FullAddressGetRequest;
import com.suning.api.entity.govbus.FullAddressGetResponse;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.persistence.EntityManagerFactory;
import member.api.AddressCommonApi;
import member.model.common.Address;
import member.model.repository.common.AddressRepos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import suning.api.address.SnAddressApi;
import suning.model.SnAddressRelation;
import suning.model.SnNationalAddress;
import suning.model.repository.SnAddressRelationRepos;
import suning.model.repository.SnNationalAddressRepos;
import suning.service.service.SnAddressService;
import utils.Lang;

@Component
public class SnAddressService {
    @Autowired
    SnAddressApi snAddressApi;
    @Autowired
    SnNationalAddressRepos snNationalAddressRepos;
    @MotanReferer
    AddressCommonApi addressCommonApi;
    public static final Logger logger = LoggerFactory.getLogger(SnAddressService.class);
    @Autowired
    AddressRepos addressRepos;
    @Autowired
    SnAddressRelationRepos snAddressRelationRepos;
    @Autowired
    EntityManagerFactory entityManagerFactory;

    public List<SnNationalAddress> getChildAddressList(SnNationalAddress snNationalAddress) {
        Assert.notNull((Object)snNationalAddress.getSnLevel(), (String)"SnNationalAddress.snLevel should not be null");
        Assert.notNull((Object)snNationalAddress.getParentId(), (String)"SnNationalAddress.parentId should not be null");
        return this.snNationalAddressRepos.findBySnLevelAndParentId(Integer.valueOf(snNationalAddress.getSnLevel()) + 1 + "", snNationalAddress.getSnId());
    }

    public SnNationalAddress findParentAddress(SnNationalAddress snNationalAddress) {
        Assert.notNull((Object)snNationalAddress.getSnLevel(), (String)"SnNationalAddress.snLevel should not be null");
        Assert.notNull((Object)snNationalAddress.getSnId(), (String)"SnNationalAddress.parentId should not be null");
        return this.snNationalAddressRepos.findBySnLevelAndSnId(Integer.valueOf(snNationalAddress.getSnLevel()) - 1 + "", snNationalAddress.getParentId());
    }

    public Map getFullAddress() {
        HashMap<String, FullAddressGetResponse> returnMap = new HashMap<String, FullAddressGetResponse>();
        FullAddressGetRequest request = new FullAddressGetRequest();
        request.setCheckParam(true);
        returnMap.put("result", this.snAddressApi.getFullAddress(request));
        return returnMap;
    }

    private void addAddress(FullAddressGetResponse.ResultInfo addr) {
        ArrayList<SnNationalAddress> saveAddrList = new ArrayList<SnNationalAddress>();
        SnNationalAddress snNationalAddress = new SnNationalAddress();
        snNationalAddress.setId(addr.getId());
        snNationalAddress.setpId(addr.getpId());
        snNationalAddress.setName(addr.getName());
        snNationalAddress.setSnId(addr.getSnId());
        if ("0".equals(addr.getLevel())) {
            List addresses = this.addressRepos.findByShortNameAndLevelType(addr.getName(), "0");
            if (!Lang.isEmpty((Object)addresses) && addresses.size() >= 0) {
                snNationalAddress.setLinkId(((Address)addresses.get(0)).getId());
            }
        } else if ("1".equals(addr.getLevel())) {
            List addresses = this.addressRepos.findByShortNameAndLevelType(addr.getName(), "1");
            if (!Lang.isEmpty((Object)addresses) && addresses.size() >= 0) {
                snNationalAddress.setLinkId(((Address)addresses.get(0)).getId());
            }
        } else if ("2".equals(addr.getLevel())) {
            List addresses = this.addressRepos.findByNameAndLevelType(addr.getName(), "2");
            if (!Lang.isEmpty((Object)addresses) && addresses.size() >= 0) {
                snNationalAddress.setLinkId(((Address)addresses.get(0)).getId());
            }
        } else if ("3".equals(addr.getLevel())) {
            List addresses = this.addressRepos.findByNameAndLevelType("%" + addr.getName() + "%", "3");
            if (!Lang.isEmpty((Object)addresses) && addresses.size() >= 0) {
                snNationalAddress.setLinkId(((Address)addresses.get(0)).getId());
            }
        } else if ("4".equals(addr.getLevel())) {
            List addresses = this.addressRepos.findByNameAndLevelType(addr.getName(), "4");
            if (!Lang.isEmpty((Object)addresses) && addresses.size() >= 0) {
                snNationalAddress.setLinkId(((Address)addresses.get(0)).getId());
            }
            snNationalAddress.setSecondPid(addr.getSecondPid());
        }
        snNationalAddress.setSnLevel(addr.getLevel());
        saveAddrList.add(snNationalAddress);
        this.snNationalAddressRepos.save(saveAddrList);
    }

    public void addParentId() {
        List snNationalAddresses = this.snNationalAddressRepos.findAll();
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        for (SnNationalAddress snNationalAddress : snNationalAddresses) {
            executorService.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (!executorService.isShutdown()) {
            executorService.shutdown();
        }
    }

    public void addSingleParentId(String id) {
        SnNationalAddress snNationalAddress = (SnNationalAddress)this.snNationalAddressRepos.findOne((Serializable)((Object)id));
        try {
            SnNationalAddress snAddr = null;
            if (Lang.equals((Object)snNationalAddress.getSnLevel(), (Object)"2") || Lang.equals((Object)snNationalAddress.getSnLevel(), (Object)"3")) {
                Integer i = Integer.valueOf(snNationalAddress.getSnLevel()) - 1;
                snAddr = this.snNationalAddressRepos.findByIdAndSnLevel(snNationalAddress.getpId(), i.toString());
                snNationalAddress.setParentId(snAddr.getSnId());
                this.snNationalAddressRepos.save((Object)snNationalAddress);
            } else if (Lang.equals((Object)snNationalAddress.getSnLevel(), (Object)"4")) {
                snAddr = this.snNationalAddressRepos.findByPIdAndId(snNationalAddress.getSecondPid(), snNationalAddress.getpId());
                snNationalAddress.setParentId(snAddr.getSnId());
                this.snNationalAddressRepos.save((Object)snNationalAddress);
            }
        }
        catch (Exception e) {
            System.out.println("snid========" + snNationalAddress.getSnId());
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void addLinkIdJob() {
        ExecutorService pool = Executors.newFixedThreadPool(10);
    }

    public void addLinkId() {
    }

    public void linkLevelThreeAddress() {
        ExecutorService pool = Executors.newFixedThreadPool(10);
        List snNationalAddresses = this.snNationalAddressRepos.findBySnLevel("3");
        for (SnNationalAddress snNationalAddress : snNationalAddresses) {
            pool.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (!pool.isShutdown()) {
            pool.shutdown();
        }
    }

    public void linkLevelFourAddress() {
        System.out.println("\u5f00\u59cb\u540c\u6b65~");
        List snNationalAddresses = this.snNationalAddressRepos.findBySnLevel("3");
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        for (SnNationalAddress snNationalAddress : snNationalAddresses) {
            if (Lang.isEmpty((Object)snNationalAddress.getLinkId())) continue;
            executorService.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (!executorService.isShutdown()) {
            executorService.shutdown();
        }
    }

    public void linkSingleLevelFourAddress(SnNationalAddress snNationalAddress) {
        Address address = (Address)this.addressRepos.findOne((Serializable)((Object)snNationalAddress.getLinkId()));
        List snChildAddresses = this.getChildAddressList(snNationalAddress);
        ArrayList<SnAddressRelation> snAddressRelations = new ArrayList<SnAddressRelation>();
        block0: for (Address childAddress : address.getChild()) {
            boolean match = false;
            for (SnNationalAddress snChildAddress : snChildAddresses) {
                if (!snChildAddress.getName().contains(childAddress.getShortName())) continue;
                snAddressRelations.add(new SnAddressRelation(childAddress.getId(), snChildAddress.getSnAddressId()));
                match = true;
                break;
            }
            if (match) continue;
            for (SnNationalAddress snChildAddress : snChildAddresses) {
                if (!"\u5168\u533a".equals(snChildAddress.getName()) && !"\u5168\u5883".equals(snChildAddress.getName())) continue;
                snAddressRelations.add(new SnAddressRelation(childAddress.getId(), snChildAddress.getSnAddressId()));
                continue block0;
            }
        }
        this.snAddressRelationRepos.save(snAddressRelations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map syncFullAddress() {
        FullAddressGetRequest request = new FullAddressGetRequest();
        request.setCheckParam(true);
        FullAddressGetResponse response = this.snAddressApi.getFullAddress(request);
        List addrList = response.getSnbody().getGetFullAddress().getResultInfo();
        ExecutorService pool = Executors.newFixedThreadPool(10);
        for (int i = 0; i < addrList.size(); ++i) {
            try {
                AddressThread thread = new AddressThread(this, (FullAddressGetResponse.ResultInfo)addrList.get(i));
                pool.execute((Runnable)thread);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            finally {
                if (!pool.isShutdown()) {
                    pool.shutdown();
                }
            }
        }
        System.out.println("=========\u5730\u5740\u540c\u6b65\u5b8c\u6210=========");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("msg", "\u5730\u5740\u540c\u6b65\u5b8c\u6210");
        return map;
    }

    public Map deleteFullAddress() {
        this.snNationalAddressRepos.deleteAll();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("msg", "\u5730\u5740\u5220\u9664\u5b8c\u6210");
        return map;
    }

    static /* synthetic */ void access$000(SnAddressService x0, FullAddressGetResponse.ResultInfo x1) {
        x0.addAddress(x1);
    }
}

