/*
 * Decompiled with CFR 0.152.
 */
package suning.service.service;

import com.suning.api.entity.govbus.PriceQueryRequest;
import com.suning.api.entity.govbus.PriceQueryResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import suning.api.price.SnPriceApi;
import utils.Lang;
import utils.log.Log;
import utils.log.Logs;

@Component
public class SnPriceService {
    private static final Log log = Logs.getLog((String)SnPriceService.class.getName());
    @Autowired
    SnPriceApi snPriceApi;

    public Map queryPrice(PriceQueryRequest request) {
        HashMap<String, PriceQueryResponse> returnMap = new HashMap<String, PriceQueryResponse>();
        returnMap.put("result", this.snPriceApi.queryPrice(request));
        return returnMap;
    }

    public List<Map<String, String>> queryGoodsPrice(List<Map<String, String>> params, String cityId) {
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        PriceQueryRequest request = new PriceQueryRequest();
        ArrayList<PriceQueryRequest.Skus> skuses = new ArrayList<PriceQueryRequest.Skus>();
        request.setCityId(cityId);
        int arraySize = params.size();
        for (int i = 0; i < arraySize; ++i) {
            PriceQueryRequest.Skus skus = new PriceQueryRequest.Skus();
            skus.setSkuId(params.get(i).get("skuId"));
            skuses.add(skus);
            if ((i == 0 || i % 49 != 0) && arraySize - 1 != i) continue;
            request.setSkus(skuses);
            log.info((Object)"\u5f00\u59cb\u8c03\u7528\u4ef7\u683c\u67e5\u8be2\u63a5\u53e3...");
            long queryPriceTime = System.currentTimeMillis();
            PriceQueryResponse response = this.snPriceApi.queryPrice(request);
            log.info((Object)"\u8c03\u7528\u4ef7\u683c\u67e5\u8be2\u63a5\u53e3\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - queryPriceTime});
            if (Lang.isEmpty((Object)response) || response.getSnerror() != null) {
                return null;
            }
            List resultInfos = response.getSnbody().getQueryPrice().getSkus();
            for (PriceQueryResponse.Skus resultInfo : resultInfos) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("skuId", resultInfo.getSkuId());
                map.put("discountRate", resultInfo.getDiscountRate());
                map.put("price", resultInfo.getPrice());
                map.put("snPrice", resultInfo.getSnPrice());
                resultList.add(map);
            }
            skuses.clear();
        }
        return resultList;
    }
}

