/*
 * Decompiled with CFR 0.152.
 */
package suning.service.service;

import com.suning.api.entity.govbus.BatchProdSaleStatusGetRequest;
import com.suning.api.entity.govbus.BatchProdSaleStatusGetResponse;
import com.suning.api.entity.govbus.CategoryGetRequest;
import com.suning.api.entity.govbus.CategoryGetResponse;
import com.suning.api.entity.govbus.JudgefacproductGetRequest;
import com.suning.api.entity.govbus.JudgefacproductGetResponse;
import com.suning.api.entity.govbus.PriceQueryRequest;
import com.suning.api.entity.govbus.PriceQueryResponse;
import com.suning.api.entity.govbus.ProdDetailGetRequest;
import com.suning.api.entity.govbus.ProdDetailGetResponse;
import com.suning.api.entity.govbus.ProdImageQueryRequest;
import com.suning.api.entity.govbus.ProdImageQueryResponse;
import com.suning.api.entity.govbus.ProdPoolQueryRequest;
import com.suning.api.entity.govbus.ProdPoolQueryResponse;
import com.suning.api.entity.govbus.ProdReviewQueryRequest;
import com.suning.api.entity.govbus.ProdReviewQueryResponse;
import com.suning.api.entity.govbus.ProdextendGetRequest;
import com.suning.api.entity.govbus.ProdextendGetResponse;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.GoodsConfigApi;
import goods.model.Goods;
import goods.model.GoodsAttr;
import goods.model.GoodsParams;
import goods.model.GoodsPicture;
import goods.model.Product;
import goods.model.ProductBrand;
import goods.model.ProductCategory;
import goods.model.ProductFashion;
import goods.model.ProductFashionPicture;
import goods.model.repository.GoodsRepos;
import goods.model.repository.ProductBrandRepos;
import goods.model.repository.ProductCategoryExtTaxRateRepos;
import goods.model.repository.ProductCategoryRepos;
import goods.model.repository.ProductRepos;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Example;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import suning.api.good.SnCategoryApi;
import suning.api.good.SnProductApi;
import suning.api.price.SnPriceApi;
import suning.model.TestMatchCategoryData;
import suning.model.repository.TMCDRepo;
import suning.service.service.SnProdService;
import utils.Lang;
import utils.log.Log;
import utils.log.Logs;
import utils.web.ResponseMapUtils;

@Component
@Transactional
public class SnProdService {
    private static final Log log = Logs.getLog((String)SnProdService.class.getName());
    @Value(value="${suning.store.code}")
    private String sn_code;
    @Value(value="${suning.store.id}")
    private String sn_id;
    @Autowired
    SnCategoryApi snCategoryApi;
    @Autowired
    SnProductApi snProductApi;
    @Autowired
    SnPriceApi snPriceApi;
    @Autowired
    ProductRepos productRepos;
    @Autowired
    GoodsRepos goodsRepos;
    @Autowired
    ProductCategoryRepos productCategoryRepos;
    @Autowired
    ProductCategoryExtTaxRateRepos productCategoryExtTaxRateRepos;
    @Autowired
    TMCDRepo tMCDRepo;
    @MotanReferer
    GoodsConfigApi goodsConfigApi;
    private static final String countSql = "SELECT count(*) FROM product_category_brand  where brand_id = ?  and category_id =? ";
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    ProductBrandRepos productBrandRepos;

    public Map getCategory() {
        HashMap<String, CategoryGetResponse> returnMap = new HashMap<String, CategoryGetResponse>();
        CategoryGetRequest request = new CategoryGetRequest();
        request.setCheckParam(true);
        returnMap.put("result", this.snCategoryApi.getCategory(request));
        return returnMap;
    }

    public Map getProdPool(String categoryId) {
        HashMap<String, ProdPoolQueryResponse> returnMap = new HashMap<String, ProdPoolQueryResponse>();
        ProdPoolQueryRequest request = new ProdPoolQueryRequest();
        request.setCategoryId(categoryId);
        request.setCheckParam(true);
        returnMap.put("result", this.snProductApi.queryProdPool(request));
        return returnMap;
    }

    public Map getProdDetail(String skuid) {
        HashMap<String, ProdDetailGetResponse> returnMap = new HashMap<String, ProdDetailGetResponse>();
        ProdDetailGetRequest request = new ProdDetailGetRequest();
        request.setSkuId(skuid);
        request.setCheckParam(true);
        returnMap.put("result", this.snProductApi.getProdDetail(request));
        return returnMap;
    }

    public Map getProdImage(String skuid) {
        HashMap<String, ProdImageQueryResponse> returnMap = new HashMap<String, ProdImageQueryResponse>();
        ProdImageQueryRequest request = new ProdImageQueryRequest();
        ArrayList<ProdImageQueryRequest.SkuIds> list = new ArrayList<ProdImageQueryRequest.SkuIds>();
        ProdImageQueryRequest.SkuIds skuIds = new ProdImageQueryRequest.SkuIds();
        skuIds.setSkuId(skuid);
        list.add(skuIds);
        request.setSkuIds(list);
        request.setCheckParam(true);
        returnMap.put("result", this.snProductApi.queryProdImage(request));
        return returnMap;
    }

    public Map getProdReview(String skuid) {
        HashMap<String, ProdReviewQueryResponse> returnMap = new HashMap<String, ProdReviewQueryResponse>();
        ProdReviewQueryRequest request = new ProdReviewQueryRequest();
        ArrayList<ProdReviewQueryRequest.SkuIds> skuIdses = new ArrayList<ProdReviewQueryRequest.SkuIds>();
        ProdReviewQueryRequest.SkuIds skuIds = new ProdReviewQueryRequest.SkuIds();
        skuIds.setSkuId(skuid);
        skuIdses.add(skuIds);
        request.setSkuIds(skuIdses);
        this.snProductApi.queryProdReview(request);
        returnMap.put("result", this.snProductApi.queryProdReview(request));
        return returnMap;
    }

    public List<Map<String, String>> getBatchProdSaleStatus(List<Map<String, String>> params) {
        BatchProdSaleStatusGetRequest request = new BatchProdSaleStatusGetRequest();
        ArrayList<BatchProdSaleStatusGetRequest.SkuIds> skuIdsList = new ArrayList<BatchProdSaleStatusGetRequest.SkuIds>();
        int paramsSize = params.size();
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        for (int i = 0; i < paramsSize; ++i) {
            BatchProdSaleStatusGetRequest.SkuIds skuIds = new BatchProdSaleStatusGetRequest.SkuIds();
            skuIds.setSkuId(params.get(i).get("skuId"));
            skuIdsList.add(skuIds);
            if ((i == 0 || i % 49 != 0) && paramsSize - 1 != i) continue;
            request.setSkuIds(skuIdsList);
            BatchProdSaleStatusGetResponse response = this.snProductApi.getBatchProdSaleStatus(request);
            if (response.getSnerror() != null) {
                return null;
            }
            List onShelvesLists = response.getSnbody().getGetBatchProdSaleStatus().getOnShelvesList();
            for (BatchProdSaleStatusGetResponse.OnShelvesList onShelvesList : onShelvesLists) {
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("skuId", onShelvesList.getSkuId());
                resultMap.put("state", onShelvesList.getState());
                resultList.add(resultMap);
            }
            skuIdsList.clear();
        }
        return resultList;
    }

    public Map addProdBySkus(Map resMap, String skuids, String categoryId, String categoryName, String cmmdtyType) {
        resMap = ResponseMapUtils.success(null);
        HashMap rsData = new HashMap();
        ArrayList<1> errorDetail = new ArrayList<1>();
        if (!Lang.isEmpty((Object)skuids)) {
            ArrayList<String> skuList = new ArrayList<String>();
            if (skuids.contains(",")) {
                String[] skuArr;
                for (String s : skuArr = skuids.split(",")) {
                    if (Lang.isEmpty((Object)s)) continue;
                    skuList.add(s.trim());
                }
            } else {
                skuList.add(skuids.trim());
            }
            int sucCount = 0;
            int errorCount = 0;
            int totalCount = skuList.size();
            String goodsId = null;
            ArrayList<String> goodsIds = new ArrayList<String>();
            for (String sku : skuList) {
                goodsId = null;
                CategoryGetResponse.ResultInfo categoryResult = null;
                if (!Lang.isEmpty((Object)categoryId)) {
                    categoryResult = new CategoryGetResponse.ResultInfo();
                    categoryResult.setCategoryId(categoryId);
                    categoryResult.setCategoryName(categoryName);
                }
                ProdPoolQueryResponse.ResultInfo pool = new ProdPoolQueryResponse.ResultInfo();
                pool.setCmmdtyType(Lang.isEmpty((Object)cmmdtyType) ? "1" : cmmdtyType);
                pool.setSkuId(sku);
                try {
                    goodsId = this.addGoods(categoryResult, pool);
                    if (!Lang.isEmpty((Object)goodsId)) {
                        goodsIds.add(goodsId);
                    }
                    ++sucCount;
                }
                catch (Exception e) {
                    ++errorCount;
                    errorDetail.add(new /* Unavailable Anonymous Inner Class!! */);
                    e.printStackTrace();
                }
            }
            String storeCode = "suning";
            throw new RuntimeException("\u8be5\u65b9\u6cd5\u9700\u8981\u8c03\u6574");
        }
        resMap = ResponseMapUtils.error((String)"skuids\u5fc5\u4f20\uff0c\u591a\u4e2asku\u7528','\u9694\u5f00", (String)"2");
        return resMap;
    }

    public void initProd() {
        CategoryGetRequest categoryReq = new CategoryGetRequest();
        CategoryGetResponse categoryRes = this.snCategoryApi.getCategory(categoryReq);
        if (categoryRes.getSnerror() == null) {
            List categoryResult = categoryRes.getSnbody().getGetCategory().getResultInfo();
            ExecutorService pool = Executors.newFixedThreadPool(10);
            for (int i = 0; i < categoryResult.size(); ++i) {
                try {
                    ProdPoolThread prodPoolThread = new ProdPoolThread(this, (CategoryGetResponse.ResultInfo)categoryResult.get(i));
                    pool.execute((Runnable)prodPoolThread);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!pool.isShutdown()) {
                pool.shutdown();
            }
        } else {
            throw new RuntimeException("\u540c\u6b65\u5546\u54c1\u76ee\u5f55\u51fa\u9519\u3002");
        }
    }

    public void queryProdPool(CategoryGetResponse.ResultInfo categoryResult) {
        ProdPoolQueryRequest poolReq = new ProdPoolQueryRequest();
        poolReq.setCategoryId(categoryResult.getCategoryId());
        poolReq.setCheckParam(true);
        ProdPoolQueryResponse poolRes = this.snProductApi.queryProdPool(poolReq);
        if (poolRes.getSnerror() == null) {
            List poolList = poolRes.getSnbody().getQueryProdPool().getResultInfo();
            List totalList = this.splitList(poolList);
            ExecutorService pool = Executors.newFixedThreadPool(20);
            int totalListSize = totalList.size();
            for (int i = 0; i < totalListSize; ++i) {
                List resultList = (List)totalList.get(i);
                int resultListSize = resultList.size();
                for (int j = 0; j < resultListSize; ++j) {
                    try {
                        GoodsThread goodsThread = new GoodsThread(this, categoryResult, (ProdPoolQueryResponse.ResultInfo)resultList.get(j));
                        pool.execute((Runnable)goodsThread);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (!pool.isShutdown()) {
                pool.shutdown();
            }
        } else {
            throw new RuntimeException("\u540c\u6b65\u5546\u54c1\u6c60\u51fa\u9519\uff0c\u5546\u54c1\u6c60\u7f16\u53f7:" + poolReq.getCategoryId());
        }
    }

    public List<List<ProdPoolQueryResponse.ResultInfo>> splitList(List<ProdPoolQueryResponse.ResultInfo> prodPool) {
        ArrayList<List<ProdPoolQueryResponse.ResultInfo>> totalProdPool = new ArrayList<List<ProdPoolQueryResponse.ResultInfo>>();
        int totalListSize = prodPool.size();
        int sumListSize = totalListSize / 2000;
        if (totalListSize % 2000 != 0) {
            ++sumListSize;
        }
        for (int i = 0; i < sumListSize; ++i) {
            if (i == sumListSize - 1) {
                totalProdPool.add(prodPool.subList(i * 2000, totalListSize));
                break;
            }
            totalProdPool.add(prodPool.subList(i * 2000, (i + 1) * 2000));
        }
        return totalProdPool;
    }

    public String addGoods(CategoryGetResponse.ResultInfo categoryResult, ProdPoolQueryResponse.ResultInfo pool) {
        String goodsId = null;
        ProdDetailGetRequest detailReq = new ProdDetailGetRequest();
        detailReq.setSkuId(pool.getSkuId());
        ProdDetailGetResponse detailRes = this.snProductApi.getProdDetail(detailReq);
        if (detailRes.getSnerror() == null) {
            ProdDetailGetResponse.GetProdDetail prodDetail = detailRes.getSnbody().getGetProdDetail();
            ProdImageQueryRequest imageReq = new ProdImageQueryRequest();
            ArrayList<ProdImageQueryRequest.SkuIds> imageSkuIdses = new ArrayList<ProdImageQueryRequest.SkuIds>();
            ProdImageQueryRequest.SkuIds skuIds = new ProdImageQueryRequest.SkuIds();
            skuIds.setSkuId(prodDetail.getSkuId());
            imageSkuIdses.add(skuIds);
            imageReq.setSkuIds(imageSkuIdses);
            ProdImageQueryResponse imageRes = this.snProductApi.queryProdImage(imageReq);
            if (imageRes.getSnerror() != null) {
                throw new RuntimeException("\u540c\u6b65\u5546\u54c1\u56fe\u7247\u51fa\u9519\uff0c\u5546\u54c1\u7f16\u53f7:" + pool.getSkuId());
            }
            ProdImageQueryResponse.ResultInfo imageResult = (ProdImageQueryResponse.ResultInfo)imageRes.getSnbody().getQueryProdImage().getResultInfo().get(0);
            BatchProdSaleStatusGetRequest batchProdSaleStatusGetRequest = new BatchProdSaleStatusGetRequest();
            ArrayList<BatchProdSaleStatusGetRequest.SkuIds> batchSkuidses = new ArrayList<BatchProdSaleStatusGetRequest.SkuIds>();
            BatchProdSaleStatusGetRequest.SkuIds batchSkuids = new BatchProdSaleStatusGetRequest.SkuIds();
            batchSkuids.setSkuId(prodDetail.getSkuId());
            batchSkuidses.add(batchSkuids);
            batchProdSaleStatusGetRequest.setSkuIds(batchSkuidses);
            BatchProdSaleStatusGetResponse batchRes = this.snProductApi.getBatchProdSaleStatus(batchProdSaleStatusGetRequest);
            if (imageRes.getSnerror() != null) {
                throw new RuntimeException("\u540c\u6b65\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u51fa\u9519\uff0c\u5546\u54c1\u7f16\u53f7:" + pool.getSkuId());
            }
            BatchProdSaleStatusGetResponse.OnShelvesList onShelvesList = (BatchProdSaleStatusGetResponse.OnShelvesList)batchRes.getSnbody().getGetBatchProdSaleStatus().getOnShelvesList().get(0);
            PriceQueryRequest priceReq = new PriceQueryRequest();
            PriceQueryRequest.Skus priceSkus = new PriceQueryRequest.Skus();
            priceSkus.setSkuId(pool.getSkuId());
            priceReq.setSkus(Arrays.asList(priceSkus));
            String cityId = "010";
            priceReq.setCityId(cityId);
            PriceQueryResponse priceRes = this.snPriceApi.queryPrice(priceReq);
            if (priceRes.getSnerror() != null) {
                cityId = "021";
                priceReq.setCityId(cityId);
                priceRes = this.snPriceApi.queryPrice(priceReq);
                if (priceRes.getSnerror() != null) {
                    System.out.println(priceRes.getSnerror().getErrorMsg());
                    throw new RuntimeException("\u540c\u6b65\u5546\u54c1\u4ef7\u683c\u51fa\u9519\uff0c\u5546\u54c1\u7f16\u53f7:" + pool.getSkuId());
                }
            }
            PriceQueryResponse.Skus priceResSkus = (PriceQueryResponse.Skus)priceRes.getSnbody().getQueryPrice().getSkus().get(0);
            Boolean isDelete = false;
            ProdextendGetRequest request = new ProdextendGetRequest();
            ProdextendGetRequest.Skus prodExtSkus = new ProdextendGetRequest.Skus();
            prodExtSkus.setSkuId(pool.getSkuId());
            request.setSkus(Arrays.asList(prodExtSkus));
            ProdextendGetResponse prodextendGetResponse = this.snProductApi.getProdextend(request);
            if (!Lang.isEmpty((Object)prodextendGetResponse) && !Lang.isEmpty((Object)prodextendGetResponse.getSnbody()) && !Lang.isEmpty((Object)prodextendGetResponse.getSnbody().getGetProdextend()) && prodextendGetResponse.getSnbody().getGetProdextend().getIsSuccess().equals("Y") && ((ProdextendGetResponse.ResultInfo)prodextendGetResponse.getSnbody().getGetProdextend().getResultInfo().get(0)).getIncreaseTicket().equals("02")) {
                isDelete = true;
            }
            boolean isJudgefac = this.isJudgefacProduct(pool.getSkuId(), cityId);
            Goods goods = null;
            boolean isExitGoods = this.isExistGoods(pool.getSkuId(), Boolean.valueOf(isJudgefac), priceResSkus);
            if (!isExitGoods) {
                goods = new Goods();
                if (!isJudgefac) {
                    goods.setJudgefac(Boolean.valueOf(isJudgefac));
                }
                this.setGoodsProperties(goods, prodDetail, imageResult.getUrls(), onShelvesList, pool, priceResSkus, isDelete);
                if (categoryResult == null) {
                    String catId = detailRes.getSnbody().getGetProdDetail().getCategory();
                    CategoryGetResponse cgr = this.snCategoryApi.getCategory(new CategoryGetRequest());
                    categoryResult = new CategoryGetResponse.ResultInfo();
                    if (cgr.getSnerror() == null) {
                        List snCatList = cgr.getSnbody().getGetCategory().getResultInfo();
                        for (CategoryGetResponse.ResultInfo snCat : snCatList) {
                            if (!snCat.getCategoryId().equals(catId)) continue;
                            categoryResult = snCat;
                            break;
                        }
                    }
                }
                this.setProduct(goods, prodDetail, categoryResult, isDelete);
                goods = (Goods)this.goodsRepos.save((Object)goods);
                goodsId = goods.getId();
            }
        } else {
            throw new RuntimeException("\u540c\u6b65\u5546\u54c1\u8be6\u60c5\u51fa\u9519\u3010" + detailRes.getSnerror().getErrorMsg() + "\u3011\uff0c\u5546\u54c1\u7f16\u53f7:" + pool.getSkuId());
        }
        return goodsId;
    }

    private boolean isExistGoods(String skuId, Boolean isJudgefac, PriceQueryResponse.Skus priceResSkus) {
        Boolean isExistGoods = false;
        List goodsList = this.goodsRepos.findAll((Specification)new /* Unavailable Anonymous Inner Class!! */);
        if (!Lang.isEmpty((Object)goodsList) && goodsList.size() > 0) {
            isExistGoods = true;
            for (Goods goods : goodsList) {
                goods.setJudgefac(isJudgefac);
                if (!Lang.isEmpty((Object)priceResSkus)) {
                    if (Lang.isEmpty((Object)priceResSkus.getPrice()) || Lang.isEmpty((Object)priceResSkus.getSnPrice())) {
                        goods.setMarketPrice(new BigDecimal(0));
                        goods.setSalePrice(new BigDecimal(0));
                        goods.setCostPrice(new BigDecimal(0));
                        goods.setDiscountRate(new BigDecimal(0));
                    } else {
                        String discountRate;
                        String price = Lang.isEmpty((Object)priceResSkus.getPrice()) ? "0" : priceResSkus.getPrice();
                        String snPrice = Lang.isEmpty((Object)priceResSkus.getSnPrice()) ? "0" : priceResSkus.getSnPrice();
                        String string = discountRate = Lang.isEmpty((Object)priceResSkus.getDiscountRate()) ? "0" : priceResSkus.getDiscountRate();
                        if (Lang.isEmpty((Object)snPrice) && !Lang.isEmpty((Object)price)) {
                            snPrice = price;
                        }
                        goods.setMarketPrice(new BigDecimal(snPrice));
                        goods.setSalePrice(new BigDecimal(price).multiply(new BigDecimal(discountRate)));
                        goods.setCostPrice(new BigDecimal(price));
                        goods.setDiscountRate(new BigDecimal(discountRate));
                    }
                } else {
                    goods.setMarketPrice(new BigDecimal(0));
                    goods.setSalePrice(new BigDecimal(0));
                    goods.setCostPrice(new BigDecimal(0));
                    goods.setDiscountRate(new BigDecimal(0));
                }
                this.goodsRepos.save((Object)goods);
            }
        }
        return isExistGoods;
    }

    private boolean isJudgefacProduct(String skuId, String cityId) {
        Boolean isJudgefac = true;
        JudgefacproductGetRequest request = new JudgefacproductGetRequest();
        request.setCityId(cityId);
        JudgefacproductGetRequest.SkuIds skuIds = new JudgefacproductGetRequest.SkuIds();
        skuIds.setSkuId(skuId);
        request.setSkuIds(Arrays.asList(skuIds));
        JudgefacproductGetResponse getJudgefacProduct = this.snProductApi.getJudgefacProduct(request);
        if (!Lang.isEmpty((Object)getJudgefacProduct) && !Lang.isEmpty((Object)getJudgefacProduct.getSnbody()) && !Lang.isEmpty((Object)getJudgefacProduct.getSnbody().getGetJudgefacproduct()) && !Lang.isEmpty((Object)getJudgefacProduct.getSnbody().getGetJudgefacproduct().getIsSuccess()) && getJudgefacProduct.getSnbody().getGetJudgefacproduct().getIsSuccess().equals("Y") && ((JudgefacproductGetResponse.Results)getJudgefacProduct.getSnbody().getGetJudgefacproduct().getResults().get(0)).getIsFactorySend().equals("02")) {
            isJudgefac = false;
        }
        return isJudgefac;
    }

    private Goods setGoodsProperties(Goods goods, ProdDetailGetResponse.GetProdDetail productDetail, List<ProdImageQueryResponse.Urls> imageResult, BatchProdSaleStatusGetResponse.OnShelvesList onShelvesList, ProdPoolQueryResponse.ResultInfo pool, PriceQueryResponse.Skus priceResSkus, Boolean isDelete) {
        goods.setName(productDetail.getName());
        goods.setStoreId(this.sn_id);
        if (!Lang.isEmpty((Object)priceResSkus)) {
            if (Lang.isEmpty((Object)priceResSkus.getPrice()) || Lang.isEmpty((Object)priceResSkus.getSnPrice())) {
                isDelete = true;
                goods.setMarketPrice(new BigDecimal(0));
                goods.setSalePrice(new BigDecimal(0));
                goods.setCostPrice(new BigDecimal(0));
                goods.setDiscountRate(new BigDecimal(0));
            } else {
                String discountRate;
                String price = Lang.isEmpty((Object)priceResSkus.getPrice()) ? "0" : priceResSkus.getPrice();
                String snPrice = Lang.isEmpty((Object)priceResSkus.getSnPrice()) ? "0" : priceResSkus.getSnPrice();
                String string = discountRate = Lang.isEmpty((Object)priceResSkus.getDiscountRate()) ? "0" : priceResSkus.getDiscountRate();
                if (Lang.isEmpty((Object)snPrice) && !Lang.isEmpty((Object)price)) {
                    snPrice = price;
                }
                goods.setMarketPrice(new BigDecimal(snPrice));
                goods.setSalePrice(new BigDecimal(price).multiply(new BigDecimal(discountRate)));
                goods.setCostPrice(new BigDecimal(price));
                goods.setDiscountRate(new BigDecimal(discountRate));
            }
        } else {
            goods.setMarketPrice(new BigDecimal(0));
            goods.setSalePrice(new BigDecimal(0));
            goods.setCostPrice(new BigDecimal(0));
            goods.setDiscountRate(new BigDecimal(0));
        }
        goods.setBrandName(productDetail.getBrand());
        goods.setIntroduction(productDetail.getIntroduction());
        goods.setProductArea(productDetail.getProductArea());
        goods.setSaleUnit(productDetail.getSaleUnit());
        goods.setSku(productDetail.getSkuId() + "");
        goods.setCode(productDetail.getSkuId() + "");
        goods.setState(Integer.valueOf(productDetail.getState()));
        goods.setUpc(productDetail.getUpc());
        goods.setWeight(productDetail.getWeight());
        goods.setPushUpDate(new Date());
        ArrayList<GoodsAttr> goodsAttrs = new ArrayList<GoodsAttr>();
        GoodsAttr goodsTyep = new GoodsAttr();
        goodsTyep.setGoods(goods);
        goodsTyep.setAttrName("\u5546\u54c1\u7c7b\u578b");
        goodsTyep.setAttrValue(pool.getCmmdtyType());
        goodsAttrs.add(goodsTyep);
        if (!Lang.isEmpty((Object)pool.getGeneralSku())) {
            GoodsAttr generalSku = new GoodsAttr();
            generalSku.setGoods(goods);
            goodsTyep.setAttrName("\u901a\u7801");
            goodsTyep.setAttrValue(pool.getGeneralSku());
            goodsAttrs.add(generalSku);
        }
        goods.setGoodsAttrs(goodsAttrs);
        ArrayList<GoodsParams> goodsParamses = new ArrayList<GoodsParams>();
        if (!Lang.isEmpty((Object)productDetail.getProdParams())) {
            for (ProdDetailGetResponse.ProdParams prodParams : productDetail.getProdParams()) {
                for (ProdDetailGetResponse.Param param : prodParams.getParam()) {
                    GoodsParams goodsParams = new GoodsParams();
                    goodsParams.setParamDesc(prodParams.getDesc());
                    goodsParams.setCoreFlag(param.getCoreFlag());
                    goodsParams.setCategory(productDetail.getCategory());
                    goodsParams.setGoods(goods);
                    goodsParams.setSnparameterVal(param.getSnparameterVal());
                    goodsParams.setSnparameterCode(param.getSnparameterCode());
                    goodsParams.setSnsequence(param.getSnsequence());
                    goodsParams.setSnparameterdesc(param.getSnparameterdesc());
                    goodsParams.setSnparametersCode(param.getSnparametersCode());
                    goodsParams.setSnparametersDesc(param.getSnparametersDesc());
                    goodsParams.setSnparameterSequence(param.getSnparameterSequence());
                    goodsParamses.add(goodsParams);
                }
            }
            goods.setGoodsParams(goodsParamses);
        }
        ArrayList<GoodsPicture> goodsPictures = new ArrayList<GoodsPicture>();
        int i = 0;
        for (ProdImageQueryResponse.Urls urls : imageResult) {
            GoodsPicture goodsPicture = new GoodsPicture();
            goodsPicture.setPicturePath(urls.getPath());
            goodsPicture.setBigPicturePath(urls.getPath());
            if ("1".equals(urls.getPrimary())) {
                goodsPicture.setShowIndex(Integer.valueOf(0));
            } else {
                goodsPicture.setShowIndex(Integer.valueOf(++i));
            }
            if (isDelete.booleanValue()) {
                goodsPicture.setIsDelete(isDelete);
            }
            goodsPicture.setGoods(goods);
            goodsPictures.add(goodsPicture);
        }
        if (isDelete.booleanValue()) {
            goods.setIsDelete(isDelete);
        }
        goods.setGoodsPictures(goodsPictures);
        return goods;
    }

    public Goods setProduct(Goods goods, ProdDetailGetResponse.GetProdDetail productDetail, CategoryGetResponse.ResultInfo categoryResult, Boolean isDelete) {
        Integer count;
        Product product = new Product();
        product.setGoodses(Arrays.asList(goods));
        String productName = goods.getName();
        product.setCostPrice(goods.getCostPrice());
        product.setMarketPrice(goods.getMarketPrice());
        product.setSalePrice(goods.getSalePrice());
        product.setProductName(productName);
        product.setTitle(productName);
        product.setCode(goods.getSku());
        product.setStoreId(this.sn_id);
        ProductFashion productFashion = new ProductFashion();
        productFashion.setCostPrice(goods.getCostPrice());
        product.setMarketPrice(goods.getMarketPrice());
        product.setSalePrice(goods.getSalePrice());
        productFashion.setProductCode(goods.getSku());
        productFashion.setStockCount(Integer.valueOf(goods.getStockCount().intValue()));
        productFashion.setLackRemind(Integer.valueOf(0));
        productFashion.setOnSale(Boolean.valueOf(true));
        if (!Lang.isEmpty((Object)goods.getGoodsPictures())) {
            productFashion.setFashionPic(((GoodsPicture)goods.getGoodsPictures().get(0)).getPicturePath());
        }
        productFashion.setFashionTitle(productName);
        productFashion.setFieldName("\u578b\u53f7");
        productFashion.setFieldType("1");
        productFashion.setValue(productDetail.getModel());
        productFashion.setValueName(productDetail.getModel());
        if (isDelete.booleanValue()) {
            productFashion.setIsDelete(isDelete);
        }
        productFashion.setProduct(product);
        product.setProductFashions(Arrays.asList(productFashion));
        ProductFashionPicture fashionPic = null;
        ArrayList<ProductFashionPicture> productFashionPictures = new ArrayList<ProductFashionPicture>();
        boolean hasDefault = false;
        for (GoodsPicture gp : goods.getGoodsPictures()) {
            fashionPic = new ProductFashionPicture();
            fashionPic.setProductFashion(productFashion);
            fashionPic.setAppPicturePath(gp.getAppPicturePath());
            fashionPic.setBigPicturePath(gp.getBigPicturePath());
            fashionPic.setPicturePath(gp.getPicturePath());
            fashionPic.setShowIndex(gp.getShowIndex());
            if (!(hasDefault || gp.getShowIndex() != 0 && goods.getGoodsPictures().size() != 1)) {
                fashionPic.setDefaultFlag(Boolean.valueOf(true));
                hasDefault = true;
            }
            productFashionPictures.add(fashionPic);
        }
        productFashion.setProductFashionPictures(productFashionPictures);
        ProductBrand productBrand = this.setBrand(productDetail.getBrand());
        ProductCategory productCategory = null;
        String categoryName = "";
        if (!Lang.isEmpty((Object)categoryResult)) {
            categoryName = categoryResult.getCategoryName();
            TestMatchCategoryData testMatchCategoryData = this.tMCDRepo.findBySnThreeCat(categoryName);
            String dateStr = "2017-04-11 9:38:51";
            productCategory = this.gennerProductCategory(testMatchCategoryData, testMatchCategoryData.getJdThreeCat(), Integer.valueOf(3), dateStr);
        }
        if (Lang.isEmpty(productCategory)) {
            productCategory = new ProductCategory();
            productCategory.setLayerIndex(Integer.valueOf(1));
            productCategory.setSourceCode(this.sn_code);
            productCategory.setName(categoryName);
            log.info((Object)("\u67e5\u8be2\u4e0d\u5230\uff0c\u5c06\u6570\u636e\u65b0\u589e\uff0c\u7136\u540e\u5c06\u5206\u7c7b\u4fe1\u606f\u8bb0\u5f55\u4e0b\u6765\uff0c\u4eba\u5de5\u7ef4\u62a4;\u5206\u7c7b\u540d\u79f0\uff1a" + categoryName));
        }
        if (!(Lang.isEmpty((Object)productBrand) || Lang.isEmpty((Object)productCategory) || !Lang.isEmpty((Object)(count = (Integer)this.jdbcTemplate.queryForObject(countSql, new Object[]{productBrand.getId(), productCategory.getId()}, Integer.class))) && count != 0)) {
            ArrayList<ProductBrand> productBrands = new ArrayList<ProductBrand>();
            productBrands.add(productBrand);
            productCategory.setProductBrands(productBrands);
            this.productCategoryRepos.save((Object)productCategory);
        }
        product.setProductCategory(productCategory);
        if (isDelete.booleanValue()) {
            product.setIsDelete(isDelete);
        }
        if (!Lang.isEmpty((Object)productCategory)) {
            goods.setProduct(product);
        }
        this.productRepos.save((Object)product);
        return goods;
    }

    public ProductCategory gennerProductCategory(TestMatchCategoryData testMatchCategoryData, String name, Integer layerIndex, String dateStr) {
        ProductCategory returnProductCategory = null;
        List productCategorys = this.productCategoryRepos.findAll((Specification)new /* Unavailable Anonymous Inner Class!! */);
        for (ProductCategory productCategory : productCategorys) {
            if (Lang.isEmpty((Object)productCategory.getParent()) || Lang.isEmpty((Object)productCategory.getParent().getParent()) || !productCategory.getParent().getName().equals(testMatchCategoryData.getJdTwoCat()) || !productCategory.getParent().getParent().getName().equals(testMatchCategoryData.getJdOneCat())) continue;
            returnProductCategory = productCategory;
        }
        return returnProductCategory;
    }

    private ProductBrand setBrand(String brandName) {
        if (Lang.isEmpty((Object)brandName)) {
            brandName = "\u6ca1\u6709\u54c1\u724c\u7684\u5546\u54c1" + this.sn_code;
        }
        List productBrands = this.productBrandRepos.findByNameAndIsDelete(brandName, false);
        ProductBrand productBrand = null;
        if (Lang.isEmpty((Object)productBrands) && productBrands.size() <= 0) {
            productBrand = new ProductBrand();
            String websitesUrl = "www.suning.com";
            String BRAND_NAME = brandName;
            productBrand.setShowIndex(Integer.valueOf(1));
            productBrand.setDescription(BRAND_NAME);
            productBrand.setName(BRAND_NAME);
            productBrand.setSimpleName(BRAND_NAME);
            productBrand.setWebsitesUrl(websitesUrl);
            productBrand.setSourceCode(this.sn_code);
            this.productBrandRepos.save((Object)productBrand);
        } else {
            productBrand = (ProductBrand)productBrands.get(0);
        }
        return productBrand;
    }

    public void deleteAllSnGoods() {
        Goods goods = new Goods();
        goods.setStoreId(this.sn_id);
        List goodsList = this.goodsRepos.findAll(Example.of((Object)goods));
        ProductCategory productCategory = new ProductCategory();
        productCategory.setTplChannel(this.sn_id);
        List productCategoryList = this.productCategoryRepos.findAll(Example.of((Object)productCategory));
        this.goodsRepos.delete((Iterable)goodsList);
        this.goodsRepos.flush();
        this.productCategoryRepos.delete((Iterable)productCategoryList);
        this.productCategoryRepos.flush();
    }

    static /* synthetic */ String access$000(SnProdService x0) {
        return x0.sn_id;
    }
}

