/*
 * Decompiled with CFR 0.152.
 */
package suning.service.service;

import com.suning.api.entity.govbus.InventoryGetRequest;
import com.suning.api.entity.govbus.InventoryGetResponse;
import com.suning.api.entity.govbus.MpStockQueryRequest;
import com.suning.api.entity.govbus.MpStockQueryResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import suning.api.stock.SnStockApi;
import utils.log.Log;
import utils.log.Logs;

@Component
public class SnStockService {
    private static final Log log = Logs.getLog((String)SnStockService.class.getName());
    @Autowired
    SnStockApi snStockApi;

    public Map getInventory(InventoryGetRequest request) {
        HashMap<String, InventoryGetResponse> returnMap = new HashMap<String, InventoryGetResponse>();
        returnMap.put("result", this.snStockApi.getInventory(request));
        return returnMap;
    }

    public Map queryMprodStock(MpStockQueryRequest request) {
        HashMap<String, MpStockQueryResponse> returnMap = new HashMap<String, MpStockQueryResponse>();
        returnMap.put("result", this.snStockApi.queryMprodStock(request));
        return returnMap;
    }

    public List<Map<String, String>> queryGoodsMprodStock(List<Map<String, String>> params, String cityId) {
        HashMap resultMap = new HashMap();
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        MpStockQueryRequest request = new MpStockQueryRequest();
        ArrayList<MpStockQueryRequest.SkuIds> skuIdses = new ArrayList<MpStockQueryRequest.SkuIds>();
        request.setCityId(cityId);
        int arraySize = params.size();
        for (int i = 0; i < arraySize; ++i) {
            MpStockQueryRequest.SkuIds skuIds = new MpStockQueryRequest.SkuIds();
            skuIds.setSkuId(params.get(i).get("skuId"));
            skuIdses.add(skuIds);
            if ((i == 0 || i % 49 != 0) && arraySize - 1 != i) continue;
            request.setSkuIds(skuIdses);
            MpStockQueryResponse response = this.snStockApi.queryMprodStock(request);
            if (response.getSnerror() != null) {
                return null;
            }
            List resultInfos = response.getSnbody().getQueryMpStock().getResultInfo();
            for (MpStockQueryResponse.ResultInfo resultInfo : resultInfos) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("skuId", resultInfo.getSkuId());
                map.put("state", resultInfo.getState());
                resultList.add(map);
            }
            skuIdses.clear();
        }
        return resultList;
    }

    public List<Map<String, String>> getGoodsInventory(List<Map<String, String>> params, String cityId, String countyId) {
        HashMap map = new HashMap();
        InventoryGetRequest request = new InventoryGetRequest();
        ArrayList<InventoryGetRequest.SkuIds> skuIdses = new ArrayList<InventoryGetRequest.SkuIds>();
        request.setCityId(cityId);
        request.setCountyId(countyId);
        int arraySize = params.size();
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        for (int i = 0; i < arraySize; ++i) {
            InventoryGetRequest.SkuIds skuIds = new InventoryGetRequest.SkuIds();
            skuIds.setSkuId(params.get(i).get("skuId"));
            skuIds.setNum(params.get(i).get("num"));
            skuIdses.add(skuIds);
            if ((i == 0 || i % 19 != 0) && arraySize - 1 != i) continue;
            request.setSkuIds(skuIdses);
            InventoryGetResponse response = this.snStockApi.getInventory(request);
            if (response.getSnerror() != null) {
                return null;
            }
            List resultInfos = response.getSnbody().getGetInventory().getResultInfo();
            for (InventoryGetResponse.ResultInfo resultInfo : resultInfos) {
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("skuId", resultInfo.getSkuId());
                resultMap.put("state", resultInfo.getState());
                resultList.add(resultMap);
            }
            skuIdses.clear();
        }
        return resultList;
    }
}

