package jd.service.decode;

import jd.service.jdapi.token.UserEntity;
import jd.service.retrofit.config.RetrofitConfigVo;
import jdek.service.retrofit.config.RetrofitConfigVoJdek;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import utils.Lang;
import utils.security.AesUtil;

import javax.annotation.PostConstruct;
import java.io.IOException;
import java.util.*;

/**
 * Created by oracle on 2017-08-24.
 */

/**
 * 太平要求对外围系统账号使用aes对称加密，并且在启动服务时输入账号密码
 */
@Component
@Order(-1000)
public class DecodeOutSideAccountService {
    Logger logger = LoggerFactory.getLogger(getClass());
    @Autowired
    RetrofitConfigVo retrofitConfigVo;
    @Autowired
    RetrofitConfigVoJdek retrofitConfigVoJdek;

    @Value("${spring.profiles.active}")
    private String activeEnv;
    @PostConstruct
    public void importSecretKey() {
        try {
            Map<String, Object> keysMap = new HashMap<>();
            String key = null;
            UserEntity userEntity = retrofitConfigVo.getUserEntity();
            Scanner scanner = null;

            Boolean readPassword=false;
            /** 非生产环境不调用接口 */
            if (!Lang.isEmpty(this.activeEnv)) {
                String[] envArr = this.activeEnv.split(",");
                for (String env : envArr) {
                    if ("readPassword".equals(env.trim()) ) {
                        readPassword=true;
                    }
                }
            }

            if(!readPassword) {
                scanner = new Scanner(System.in);

            }
            /**
             * 京东密钥
             */
            System.out.println("请输入retrofit.userEntity.client_id密钥:");
            if(!readPassword) {
                key = getAndcheckRepeatKey(keysMap, scanner);
            }else{
                key="aaaaaaaaaaaaaaaa";
            }
            userEntity.setClient_id(AesUtil.Decrypt(userEntity.getClient_id(), key));
            System.out.println("请输入retrofit.userEntity.client_secret密钥:");
            if(!readPassword) {
                key = getAndcheckRepeatKey(keysMap, scanner);
            }else{
                key="bbbbbbbbbbbbbbbb";
            }

            userEntity.setClient_secret(AesUtil.Decrypt(userEntity.getClient_secret(), key));
            System.out.println("请输入retrofit.userEntity.usernamet密钥:");
            if(!readPassword) {
                key = getAndcheckRepeatKey(keysMap, scanner);
            }else{
                key="cccccccccccccccc";
            }
            userEntity.setUsername(AesUtil.Decrypt(userEntity.getUsername(), key));
            System.out.println("请输入retrofit.userEntity.password密钥:");
            if(!readPassword) {
                key = getAndcheckRepeatKey(keysMap, scanner);
            }else{
                key="dddddddddddddddd";
            }
            userEntity.setPassword(AesUtil.Decrypt(userEntity.getPassword(), key));


            /**
             * 京东e卡密钥
             */
            jdek.service.jdekapi.token.UserEntity jdekUserEntity = retrofitConfigVoJdek.getUserEntity();
            System.out.println("请输入retrofitJdek.userEntity.client_id密钥:");
            if(!readPassword) {
                key = getAndcheckRepeatKey(keysMap, scanner);
            }else{
                key="eeeeeeeeeeeeeeee";
            }
            jdekUserEntity.setClient_id(AesUtil.Decrypt(jdekUserEntity.getClient_id(), key));
            System.out.println("请输入retrofitJdek.userEntity.client_secret密钥:");
            if(!readPassword) {
                key = getAndcheckRepeatKey(keysMap, scanner);
            }else{
                key="ffffffffffffffff";
            }
            jdekUserEntity.setClient_secret(AesUtil.Decrypt(jdekUserEntity.getClient_secret(), key));
            System.out.println("请输入retrofitJdek.userEntity.username密钥:");
            if(!readPassword) {
                key = getAndcheckRepeatKey(keysMap, scanner);
            }else{
                key="gggggggggggggggg";
            }
            jdekUserEntity.setUsername(AesUtil.Decrypt(jdekUserEntity.getUsername(), key));
            System.out.println("请输入retrofitJdek.userEntity.password密钥:");
            if(!readPassword) {
                key = getAndcheckRepeatKey(keysMap, scanner);
            }else{
                key="hhhhhhhhhhhhhhhh";
            }
            jdekUserEntity.setPassword(AesUtil.Decrypt(jdekUserEntity.getPassword(), key));

            System.out.println("京东密钥输入完成！ ");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getAndcheckRepeatKey(Map<String, Object> keysMap, Scanner scanner) {
        String key = scanner.next();
        while (StringUtils.isEmpty(key) || key.length() != 16 || keysMap.containsKey(key)) {
            if (StringUtils.isEmpty(key)) {
                System.out.println("密钥不能为空,请重新输入");
            } else if (key.length() != 16) {
                System.out.println("密钥格式不正确,请重新输入");
            } else if (keysMap.containsKey(key)) {
                System.out.println("不能使用相同密钥,请重新输入");
            }
            key = scanner.next();
        }
        keysMap.put(key, null);
        return key;
    }


}
