package jd.service.jdapi.address;

import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import jd.api.request.address.AddressEntity;
import jd.api.response.address.AddressDetailResp;
import jd.api.service.address.JdAddressApi;
import jd.service.jdapi.token.TokenService;
import jd.service.retrofit.api.JdAddressRestApi;
import jd.service.service.JdSystemLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import retrofit2.Call;
import retrofit2.Retrofit;
import utils.Lang;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by xujingfeng on 2017/1/24.
 */
@MotanService
public class JdAddressApiImpl implements JdAddressApi {
    private Retrofit retrofit;
    private JdAddressRestApi jdAddressRestApi;
    private TokenService tokenService;
    @Autowired
    JdSystemLogService jdSystemLogService;

    public static final Logger logger = LoggerFactory.getLogger(JdAddressApiImpl.class);

    public JdAddressApiImpl(TokenService tokenService, Retrofit retrofit) {
        this.tokenService = tokenService;
        this.retrofit = retrofit;
        this.jdAddressRestApi = this.retrofit.create(JdAddressRestApi.class);
    }


    @Override
    public Map<String, Integer> getLevelOneAddress() {
        try {
            Map map = new HashMap<>();
            map.put("token", tokenService.accessToken());
            Call<AddressDetailResp> call = jdAddressRestApi.getProvince(Lang.filterNullMap(map, false));
            Map<String, Integer> returnMap=call.execute().body().getResult();
           // jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return returnMap;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public Map<String, Integer> getLevelTwoAddress(AddressEntity addressEntity) {
        try {
            Map map = new HashMap<>();
            map.put("token", tokenService.accessToken());
            map.put("id",addressEntity.getId());
            Call<AddressDetailResp> call = jdAddressRestApi.getCity(Lang.filterNullMap(map, false));
            Map<String, Integer> returnMap=call.execute().body().getResult();
            //jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return returnMap;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public Map<String, Integer> getLevelThreeAddress(AddressEntity addressEntity) {
        try {
            Map map = new HashMap<>();
            map.put("token", tokenService.accessToken());
            map.put("id",addressEntity.getId());
            Call<AddressDetailResp> call = jdAddressRestApi.getCounty(Lang.filterNullMap(map, false));
            Map<String, Integer> returnMap=call.execute().body().getResult();
           // jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return returnMap;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public Map<String, Integer> getLevelFourAddress(AddressEntity addressEntity) {
        try {
            Map map = new HashMap<>();
            map.put("token", tokenService.accessToken());
            map.put("id",addressEntity.getId());
            Call<AddressDetailResp> call = jdAddressRestApi.getTown(Lang.filterNullMap(map, false));
            Map<String, Integer> returnMap=call.execute().body().getResult();
           // jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return returnMap;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }
}
