package jd.service.jdapi.aftersale;

import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import jd.api.request.aftersale.*;
import jd.api.response.aftersale.*;
import jd.api.service.aftersale.JdAftersaleApi;
import jd.service.jdapi.address.JdAddressApiImpl;
import jd.service.jdapi.token.TokenService;
import jd.service.retrofit.api.JdAftersaleRestApi;
import jd.service.service.JdSystemLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import retrofit2.Call;
import retrofit2.Retrofit;
import utils.Lang;
import utils.convert.converters.map.ObjectToMapConverter;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by xujingfeng on 2017/3/7.
 */
@MotanService
public class JdAftersaleApiImpl implements JdAftersaleApi{

    private Retrofit retrofit;
    private JdAftersaleRestApi jdAftersaleRestApi;
    private TokenService tokenService;

    public static final Logger logger = LoggerFactory.getLogger(JdAddressApiImpl.class);

    @Autowired
    JdSystemLogService jdSystemLogService;

    public JdAftersaleApiImpl(TokenService tokenService, Retrofit retrofit) {
        this.tokenService = tokenService;
        this.retrofit = retrofit;
        this.jdAftersaleRestApi = this.retrofit.create(JdAftersaleRestApi.class);
    }

    @Override
    public AfsApplyResp createServiceTicket(AfsApplyEntity afsApplyEntity) {
        try {
           /* utils.convert.Converter converter = new ObjectToMapConverter();
            Map map = (Map) converter.convert(afsApplyEntity, HashMap.class);*/
            Map map = new HashMap();
            String json = JSONObject.toJSONString(afsApplyEntity);
            map.put("param",json);
            map.put("token", tokenService.accessToken());
            Call<AfsApplyResp> call = jdAftersaleRestApi.createAfsApply(Lang.filterNullMap(map, false));
            AfsApplyResp afsApplyResp= call.execute().body();
            Map returnMap=new HashMap();
            returnMap.put("response",afsApplyResp);
           // jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return afsApplyResp;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public SendSkuResp sendSku(SendSkuEntity sendSkuEntity) {
        try {
            utils.convert.Converter converter = new ObjectToMapConverter();
            Map map = (Map) converter.convert(sendSkuEntity, HashMap.class);
            map.put("token", tokenService.accessToken());
            Call<SendSkuResp> call = jdAftersaleRestApi.updateSendSku(Lang.filterNullMap(map, false));
            SendSkuResp sendSkuResp= call.execute().body();
            Map returnMap=new HashMap();
            returnMap.put("response",sendSkuResp);
           // jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return sendSkuResp;

        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public AvailableNumberCompResp getAvailableNumber(OrderSkuEntity orderSkuEntity) {
        try {
          /*  utils.convert.Converter converter = new ObjectToMapConverter();
            Map map = (Map) converter.convert(orderSkuEntity, HashMap.class);*/
            Map map = new HashMap();
            String json = JSONObject.toJSONString(orderSkuEntity);
            map.put("token", tokenService.accessToken());
            map.put("param",json);
            Call<AvailableNumberCompResp> call = jdAftersaleRestApi.getAvailableNumberComp(Lang.filterNullMap(map, false));
            AvailableNumberCompResp availableNumberCompResp= call.execute().body();
            Map returnMap=new HashMap();
            returnMap.put("response",availableNumberCompResp);
            //jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return availableNumberCompResp;
        } catch (Exception e) {
            e.printStackTrace();
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public CustomerExpectCompResp getCustomerExpect(OrderSkuEntity orderSkuEntity) {
        try {
           /* utils.convert.Converter converter = new ObjectToMapConverter();
            Map map = (Map) converter.convert(orderSkuEntity, HashMap.class);

            map.put("token", tokenService.accessToken());*/
            Map map = new HashMap();
            String json = JSONObject.toJSONString(orderSkuEntity);
            map.put("param",json);
            map.put("token", tokenService.accessToken());
           // Call<CustomerExpectCompResp> call = jdAftersaleRestApi.getCustomerExpectComp(Lang.filterNullMap(map, false));
            Call<CustomerExpectCompResp> call = jdAftersaleRestApi.getCustomerExpectComp(Lang.filterNullMap(map, false));
            CustomerExpectCompResp customerExpectCompResp= call.execute().body();
            Map returnMap=new HashMap();
            returnMap.put("response",customerExpectCompResp);
           // jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return customerExpectCompResp;

        } catch (Exception e) {
            e.printStackTrace();
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public WareReturnJdCompResp getWareReturnJd(OrderSkuEntity orderSkuEntity) {
        try {
          /*  utils.convert.Converter converter = new ObjectToMapConverter();
            Map map = (Map) converter.convert(orderSkuEntity, HashMap.class);*/
            Map map = new HashMap();
            String json = JSONObject.toJSONString(orderSkuEntity);
            map.put("param",json);
            map.put("token", tokenService.accessToken());

            Call<WareReturnJdCompResp> call = jdAftersaleRestApi.getWareReturnJdComp(Lang.filterNullMap(map, false));
            WareReturnJdCompResp wareReturnJdCompResp= call.execute().body();
            Map returnMap=new HashMap();
            returnMap.put("response",wareReturnJdCompResp);
           // jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return wareReturnJdCompResp;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public ServiceListPageResp getServiceListPage(ServiceListPageEntity serviceListPageEntity) {
        try {
           /* utils.convert.Converter converter = new ObjectToMapConverter();
            Map map = (Map) converter.convert(serviceListPageEntity, HashMap.class);*/
            Map map = new HashMap();
            String json = JSONObject.toJSONString(serviceListPageEntity);
            map.put("param",json);
            map.put("token", tokenService.accessToken());

            Call<ServiceListPageResp> call = jdAftersaleRestApi.getServiceListPage(Lang.filterNullMap(map, false));
            ServiceListPageResp serviceListPageResp= call.execute().body();
            Map returnMap=new HashMap();
            returnMap.put("response",serviceListPageResp);
           // jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return serviceListPageResp;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public ServiceDetailInfoResp getServiceDetailInfo(ServiceDetailInfoEntity serviceDetailInfoEntity) {
        try {
            /*utils.convert.Converter converter = new ObjectToMapConverter();
            Map map = (Map) converter.convert(serviceDetailInfoEntity, HashMap.class);*/

            Map map = new HashMap();
            String json = JSONObject.toJSONString(serviceDetailInfoEntity);
            map.put("param",json);
            map.put("token", tokenService.accessToken());
            Call<ServiceDetailInfoResp> call = jdAftersaleRestApi.getServiceDetailInfo(Lang.filterNullMap(map, false));
            ServiceDetailInfoResp serviceDetailInfoResp= call.execute().body();
            Map returnMap=new HashMap();
            returnMap.put("response",serviceDetailInfoResp);
            //jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return serviceDetailInfoResp;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public AuditCancelResp cancelAudit(AuditCancelEntity auditCancelEntity) {
        try {
            /*utils.convert.Converter converter = new ObjectToMapConverter();
            Map map = (Map) converter.convert(auditCancelEntity, HashMap.class);*/
            Map map = new HashMap();
            String json = JSONObject.toJSONString(auditCancelEntity);
            map.put("param",json);

            map.put("token", tokenService.accessToken());
            Call<AuditCancelResp> call = jdAftersaleRestApi.auditCancel(Lang.filterNullMap(map, false));

            AuditCancelResp auditCancelResp= call.execute().body();
            Map returnMap=new HashMap();
            returnMap.put("response",auditCancelResp);
           // jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return auditCancelResp;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }
}
