package jd.service.jdapi.order;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import jd.api.request.order.*;
import jd.api.response.order.*;
import jd.api.service.order.JdOrderApi;
import jd.api.vo.order.OrderFreightVO;
import jd.service.jdapi.token.TokenService;
import jd.service.retrofit.api.JdOrderRestApi;

import jd.service.service.JdSystemLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import retrofit2.Call;
import retrofit2.Retrofit;
import sinomall.global.common.vo.outsideapi.OrderCancelOrderResp;
import utils.Lang;
import utils.convert.converters.map.ObjectToMapConverter;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by xujingfeng on 2017/1/24.
 */
@MotanService
public class JdOrderApiImpl implements JdOrderApi {
    private Retrofit retrofit;
    private JdOrderRestApi jdOrderRestApi;
    private TokenService tokenService;

    public static final Logger logger = LoggerFactory.getLogger(JdOrderApiImpl.class);

    @Autowired
    JdSystemLogService jdSystemLogService;

    public JdOrderApiImpl(TokenService tokenService, Retrofit retrofit) {
        this.tokenService = tokenService;
        this.retrofit = retrofit;
        this.jdOrderRestApi = this.retrofit.create(JdOrderRestApi.class);
    }

    @Override
    public OrderUniteSubmitResp placeOrder(OrderEntity orderEntity) {
        try {
            utils.convert.Converter converter = new ObjectToMapConverter();
            Map map = (Map) converter.convert(orderEntity, HashMap.class);
            map.put("token", tokenService.accessToken());
            /*2017/3/7兼容旧接口所做的特殊处理*/
            map.put("sku",JSON.toJSONString(orderEntity.getSku()));
            Call<OrderUniteSubmitResp> call = jdOrderRestApi.submitOrder(Lang.filterNullMap(map, false));
            OrderUniteSubmitResp orderUniteSubmitResp= call.execute().body();
            Map returnMap=new HashMap();
            returnMap.put("response",orderUniteSubmitResp);
            jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return orderUniteSubmitResp;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public OccupyStockResp confirmOccupyStock(JdOrderIdEntity jdOrderIdEntity) {
        try {
            Map map = new HashMap<>();
            map.put("token", tokenService.accessToken());
            map.put("jdOrderId",jdOrderIdEntity.getJdOrderId());
            Call<OccupyStockResp> call = jdOrderRestApi.confirmOrder(Lang.filterNullMap(map, false));
            OccupyStockResp occupyStockResp= call.execute().body();
            Map returnMap=new HashMap();
            returnMap.put("response",occupyStockResp);
            jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return occupyStockResp;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public OrderCancelOrderResp cancelOrder(JdOrderIdEntity jdOrderIdEntity) {
        try {
            Map map = new HashMap<>();
            map.put("token", tokenService.accessToken());
            map.put("jdOrderId",jdOrderIdEntity.getJdOrderId());
            Call<OrderCancelOrderResp> call = jdOrderRestApi.cancel(Lang.filterNullMap(map, false));
            OrderCancelOrderResp orderCancelOrderResp= call.execute().body();
            Map returnMap=new HashMap();
            returnMap.put("response",orderCancelOrderResp);
            jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return orderCancelOrderResp;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public Map<String, Object> queryOrder(JdOrderIdEntity jdOrderIdEntity) {
        try {
            Map map = new HashMap<>();
            map.put("token", tokenService.accessToken());
            map.put("jdOrderId",jdOrderIdEntity.getJdOrderId());
            Call<OrderSplitResp> call = jdOrderRestApi.selectJdOrder(Lang.filterNullMap(map, false));
            Map returnMap=call.execute().body().getResult();
            jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return returnMap;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog("api/order/selectJdOrder", ""+JSON.toJSONString(jdOrderIdEntity),""+Lang.toString(e),null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public OrderFreightResp queryFreight(OrderFreightEntity orderFreightEntity) {
        try {
            utils.convert.Converter converter = new ObjectToMapConverter();
            Map map = (Map) converter.convert(orderFreightEntity, HashMap.class);

            map.put("token", tokenService.accessToken());
            /*2017/3/7兼容旧接口所做的特殊处理*/
            map.put("sku",JSON.toJSONString(orderFreightEntity.getSku()));
            Call<OrderFreightResp> call = jdOrderRestApi.getFreight(Lang.filterNullMap(map, false));
            OrderFreightResp orderFreightResp = call.execute().body();
            Map returnMap=new HashMap();
            returnMap.put("response",orderFreightResp);
            jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            logger.info("orderFreightResp:{}", JSON.toJSONString(orderFreightResp));
            return orderFreightResp;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public OrderRevResp queryOrderByThirdOrder(ThirdOrder thirdOrder) {
        try {
            utils.convert.Converter converter = new ObjectToMapConverter();
            Map map = (Map) converter.convert(thirdOrder, HashMap.class);

            map.put("token", tokenService.accessToken());
            Call<OrderRevResp> call = jdOrderRestApi.selectJdOrderIdByThirdOrder(Lang.filterNullMap(map, false));
            OrderRevResp orderRevResp= call.execute().body();
            Map returnMap=new HashMap();
            returnMap.put("response",orderRevResp);
            jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return orderRevResp;

        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public OrderTrackResp queryOrderTrack(JdOrderIdEntity jdOrderIdEntity) {
        try {
            long methodStart = System.currentTimeMillis();
            Map map = new HashMap<>();
            map.put("token", tokenService.accessToken());
            map.put("jdOrderId",jdOrderIdEntity.getJdOrderId());
            Call<OrderTrackResp> call = jdOrderRestApi.orderTrack(Lang.filterNullMap(map, false));
            OrderTrackResp orderTrackResp= call.execute().body();
            Map returnMap=new HashMap();
            returnMap.put("response",orderTrackResp);
           // jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            logger.info("京东物流接口耗时 {} ms", System.currentTimeMillis() - methodStart);
            return orderTrackResp;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public Map<String, Object> getBalance(OrderBalanceEntity orderBalanceEntity) {
        try {
            Map map = new HashMap<>();
            map.put("token", tokenService.accessToken());
            map.put("payType",orderBalanceEntity.getPayType());
            Call<OrderBalanceResp> call = jdOrderRestApi.getBalance(Lang.filterNullMap(map, false));
            String result=call.execute().body().getResult();
            Map returnMap=new HashMap();
            returnMap.put("result",result);
            //jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return returnMap;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public CheckOrderResp checkNewOrder(CheckOrderEntity checkOrderEntity) {
        try {
            utils.convert.Converter converter = new ObjectToMapConverter();
            Map map = (Map) converter.convert(checkOrderEntity, HashMap.class);

            map.put("token", tokenService.accessToken());
            Call<CheckOrderResp> call = jdOrderRestApi.checkNewOrder(Lang.filterNullMap(map, false));
            CheckOrderResp checkOrderResp= call.execute().body();
            Map returnMap=new HashMap();
            returnMap.put("response",checkOrderResp);
           // jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return checkOrderResp;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public CheckOrderResp checkDlokOrder(CheckOrderEntity checkOrderEntity) {
        try {
            utils.convert.Converter converter = new ObjectToMapConverter();
            Map map = (Map) converter.convert(checkOrderEntity, HashMap.class);

            map.put("token", tokenService.accessToken());
            Call<CheckOrderResp> call = jdOrderRestApi.checkDlokOrder(Lang.filterNullMap(map, false));
            CheckOrderResp checkOrderResp= call.execute().body();
            Map returnMap=new HashMap();
            returnMap.put("response",checkOrderResp);
            //jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return checkOrderResp;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public CheckOrderResp checkRefuseOrder(CheckOrderEntity checkOrderEntity) {
        try {
            utils.convert.Converter converter = new ObjectToMapConverter();
            Map map = (Map) converter.convert(checkOrderEntity, HashMap.class);

            map.put("token", tokenService.accessToken());
            Call<CheckOrderResp> call = jdOrderRestApi.checkRefuseOrder(Lang.filterNullMap(map, false));
            CheckOrderResp checkOrderResp= call.execute().body();
            Map returnMap=new HashMap();
            returnMap.put("response",checkOrderResp);
            //jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return checkOrderResp;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }


}
