package jd.service.jdapi.product;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import goods.api.GoodsApi;
import jd.api.request.product.*;
import jd.api.response.core.CommonResponse;
import jd.api.response.product.*;
import jd.api.service.product.JdProductApi;
import jd.api.vo.product.*;
import jd.dto.StockStateDto;
import jd.model.stock.StockState;
import jd.model.stock.StockStateDao;
import jd.service.jdapi.token.TokenService;
import jd.service.retrofit.api.JdProductRestApi;
import jd.service.service.JdSystemLogService;
import jd.service.service.ProductDbInitService;
import jd.service.service.ProductTransactionalService;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import retrofit2.Call;
import retrofit2.Retrofit;
import utils.Lang;
import utils.convert.converters.map.ObjectToMapConverter;

import java.util.*;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * Created by xujingfeng on 2017/1/23.
 */
@MotanService
public class JdProductApiImpl implements JdProductApi {
    private Retrofit retrofit;
    private JdProductRestApi jdProductRestApi;
    private TokenService tokenService;
    @MotanReferer
    GoodsApi goodsApi;

    @Autowired
    MapperFacade mapperFacade;

    public static final Logger logger = LoggerFactory.getLogger(JdProductApiImpl.class);
    @Autowired
    JdSystemLogService jdSystemLogService;

    public JdProductApiImpl(TokenService tokenService, Retrofit retrofit) {
        this.tokenService = tokenService;
        this.retrofit = retrofit;
        this.jdProductRestApi = this.retrofit.create(JdProductRestApi.class);
    }


    @Override
    public List<ProductPoolVO> getProductPool() {
        try {
            Map map = new HashMap<>();
            map.put("token", tokenService.accessToken());
            Call<ProductPoolResp> call = jdProductRestApi.getPageNum(Lang.filterNullMap(map, false));
            ProductPoolResp body = call.execute().body();
            Map returnMap = new HashMap();
            returnMap.put("response", body);
            // jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            // jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return body.getResult();
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public List<Long> getProductPoolProduct(PageNumEntity pageNumEntity) {
        try {
            utils.convert.Converter converter = new ObjectToMapConverter();
            Map map = (Map) converter.convert(pageNumEntity, HashMap.class);

            map.put("token", tokenService.accessToken());
            Call<ProductPoolProductResp> call = jdProductRestApi.getSku(Lang.filterNullMap(map, false));
            ProductPoolProductResp body = call.execute().body();
            Map returnMap = new HashMap();
            returnMap.put("response", body);

            //jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            String[] goodsNos = null;
            List<Long> goodsList = new ArrayList<>();
            if (!Lang.isEmpty(body) && !Lang.isEmpty(body.getResult())) {
                goodsNos = body.getResult().split(",");
                for (String goodsNo : goodsNos) {
                    goodsList.add(Long.valueOf(goodsNo));
                }
            }

            return goodsList;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public String getProductPoolProductResult(PageNumEntity pageNumEntity) {
        try {
            utils.convert.Converter converter = new ObjectToMapConverter();
            Map map = (Map) converter.convert(pageNumEntity, HashMap.class);

            map.put("token", tokenService.accessToken());
            Call<ProductPoolProductResp> call = jdProductRestApi.getSkuByPage(Lang.filterNullMap(map, false));
            ProductPoolProductResp body = call.execute().body();
            Map returnMap = new HashMap();
            returnMap.put("response", body);

            // jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);

            return body.getResult();

        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public List<Long> getProductPoolProductOld(PageNumEntity pageNumEntity) {
        String result = getProductPoolProductResult(pageNumEntity);

        String[] goodsNos = null;
        List<Long> goodsList = new ArrayList<>();
        if (!Lang.isEmpty(result)) {
            JSONObject object = JSONObject.parseObject(result);
            JSONArray skuIds = object.getJSONArray("skuIds");
            Integer pageCount = object.getInteger("pageCount");
            for (int i = 0; i < skuIds.size(); i++) {
                Object obj = skuIds.get(i);
                goodsList.add(Long.valueOf(obj.toString()));
            }

            Integer pageNo = pageNumEntity.getPageNo();
            while (pageNo <= pageCount) {
                pageNo++;
                pageNumEntity.setPageNo(pageNo);
                result = getProductPoolProductResult(pageNumEntity);
                if (!Lang.isEmpty(result)) {
                    object = JSONObject.parseObject(result);
                    skuIds = object.getJSONArray("skuIds");
                    //  pageCount = object.getInteger("pageCount");
                    for (int i = 0; i < skuIds.size(); i++) {
                        Object obj = skuIds.get(i);
                        goodsList.add(Long.valueOf(obj.toString()));
                    }
                }
            }

        }

        return goodsList;
    }


    @Override
    public ProductDetailVO getProductDetail(ProductDetailEntity productDetailEntity) {
        try {
            utils.convert.Converter converter = new ObjectToMapConverter();
            Map map = (Map) converter.convert(productDetailEntity, HashMap.class);

            map.put("token", tokenService.accessToken());
            Call<ProductDetailResp> call = jdProductRestApi.getDetail(Lang.filterNullMap(map, false));
            ProductDetailVO productDetailVO = call.execute().body().getResult();
            Map returnMap = new HashMap();
            returnMap.put("response", productDetailVO);
            //  jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return productDetailVO;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public List<ProductStateVO> getProductState(List<Long> skus) {
        try {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < skus.size(); i++) {
                if (i == 0)
                    sb.append(skus.get(i));
                else
                    sb.append(",").append(skus.get(i));
            }
            Map map = new HashMap();
            map.put("token", tokenService.accessToken());
            map.put("sku", sb.toString());
            Call<ProductStateResp> call = jdProductRestApi.skuState(Lang.filterNullMap(map, false));
            List<ProductStateVO> productDetailVOs = call.execute().body().getResult();
            Map returnMap = new HashMap();
            returnMap.put("response", productDetailVOs);
            // jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return productDetailVOs;
            //return call.execute().body().getResult();
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public Map<Long, List<ProductSkuImageVO>> getProductSkuImage(List<Long> skus) {
        try {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < skus.size(); i++) {
                if (i == 0)
                    sb.append(skus.get(i));
                else
                    sb.append(",").append(skus.get(i));
            }
            Map map = new HashMap();
            map.put("token", tokenService.accessToken());
            map.put("sku", sb.toString());
            Call<ProductSkuImageResp> call = jdProductRestApi.skuImage(Lang.filterNullMap(map, false));
            Map<Long, List<ProductSkuImageVO>> returnMap = call.execute().body().getResult();
            // jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return returnMap;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public List<ProductCommentSummarysVO> getProductCommentSummarys(List<Long> skus) {
        try {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < skus.size(); i++) {
                if (i == 0)
                    sb.append(skus.get(i));
                else
                    sb.append(",").append(skus.get(i));
            }
            Map map = new HashMap();
            map.put("token", tokenService.accessToken());
            map.put("sku", sb.toString());
            Call<ProductCommentSummarysResp> call = jdProductRestApi.getCommentSummarys(Lang.filterNullMap(map, false));
            List<ProductCommentSummarysVO> productCommentSummarysVOs = call.execute().body().getResult();
            Map returnMap = new HashMap();
            returnMap.put("response", productCommentSummarysVOs);
            //  jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return productCommentSummarysVOs;

        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public List<SkuIdsAndAreaVO> getProductLimit(SkuIdsAndAreaEntity skuIdsAndAreaEntity) {
        try {
            utils.convert.Converter converter = new ObjectToMapConverter();
            Map map = (Map) converter.convert(skuIdsAndAreaEntity, HashMap.class);

            map.put("token", tokenService.accessToken());
            Call<SkuIdsAndAreaNewResp> call = jdProductRestApi.checkAreaLimit(Lang.filterNullMap(map, false));
            List<SkuIdsAndAreaVO> skuIdsAndAreaVOs = call.execute().body().getResult();
            Map returnMap = new HashMap();
            returnMap.put("response", skuIdsAndAreaVOs);
            //jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return skuIdsAndAreaVOs;

        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public Boolean getProductIsCod(SkuIdsAndAreaEntity skuIdsAndAreaEntity) {
        try {
            utils.convert.Converter converter = new ObjectToMapConverter();
            Map map = (Map) converter.convert(skuIdsAndAreaEntity, HashMap.class);

            map.put("token", tokenService.accessToken());
            Call<CommonResponse<Boolean>> call = jdProductRestApi.getIsCod(Lang.filterNullMap(map, false));
            Boolean isCod = call.execute().body().getResult();
            Map returnMap = new HashMap();
            returnMap.put("response", isCod);
            // jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return isCod;

        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public ProductCheckResp getSkuCheck(List<Long> skus) {
        try {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < skus.size(); i++) {
                if (i == 0)
                    sb.append(skus.get(i));
                else
                    sb.append(",").append(skus.get(i));
            }
            Map map = new HashMap();
            map.put("token", tokenService.accessToken());
            map.put("skuIds", sb.toString());
            Call<ProductCheckResp> call = jdProductRestApi.check(Lang.filterNullMap(map, false));
            ProductCheckResp productCheckResp = call.execute().body();
            Map returnMap = new HashMap();
            returnMap.put("response", productCheckResp);
            //  jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return productCheckResp;

        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public List<SimilarProduct> getSimilarProduct(String skuId) {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("skuId", skuId);
            map.put("token", tokenService.accessToken());
            Call<CommonResponse<List<SimilarProduct>>> call = jdProductRestApi.getSimilarSku(Lang.filterNullMap(map, false));
            return call.execute().body().getResult();
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public List<PriceVO> getPrice(SkuEntity skuEntity) {
        try {
            utils.convert.Converter converter = new ObjectToMapConverter();
            Map map = (Map) converter.convert(skuEntity, HashMap.class);

            map.put("token", tokenService.accessToken());
            Call<PriceResp> call = jdProductRestApi.getSellPrice(Lang.filterNullMap(map, false));
            List<PriceVO> priceVOs = call.execute().body().getResult();
            Map returnMap = new HashMap();
            returnMap.put("response", priceVOs);
            // jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return priceVOs;

        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public List<StockNewResultVo> getStockForOrder(StockForOrderEntity stockForOrderEntity) {
        try {
            Map map = new HashMap();
            map.put("token", tokenService.accessToken());
            map.put("area", stockForOrderEntity.getArea());
            map.put("skuNums", JSON.toJSONString(stockForOrderEntity.getSkuNums()));
            Call<StockForOrderNewResp> call = jdProductRestApi.getNewStockById(Lang.filterNullMap(map, false));
            String result = call.execute().body().getResult();
            List<StockNewResultVo> stockNewResultVos = JSON.parseArray(result, StockNewResultVo.class);
            Map returnMap = new HashMap();
            returnMap.put("response", stockNewResultVos);
            //jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return stockNewResultVos;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public List<MessageGetVO> getMessage(MessageTypeEntity messageTypeEntity) {
        try {
            utils.convert.Converter converter = new ObjectToMapConverter();
            Map map = (Map) converter.convert(messageTypeEntity, HashMap.class);

            map.put("token", tokenService.accessToken());
            Call<MessageGetResp> call = jdProductRestApi.get(Lang.filterNullMap(map, false));
            List<MessageGetVO> messageGetVOs = call.execute().body().getResult();
            Map returnMap = new HashMap();
            returnMap.put("response", messageGetVOs);
            // jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return messageGetVOs;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public Boolean delMessage(MessageDelEntity messageDelEntity) {
        try {
            utils.convert.Converter converter = new ObjectToMapConverter();
            Map map = (Map) converter.convert(messageDelEntity, HashMap.class);

            map.put("token", tokenService.accessToken());
            Call<MessageDelResp> call = jdProductRestApi.del(Lang.filterNullMap(map, false));
            Boolean isDel = call.execute().body().getResult();
            Map returnMap = new HashMap();
            returnMap.put("response", isDel);
            // jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return isDel;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public CategoryResp getCategory(CategoryEntity categoryEntity) {
        try {
            utils.convert.Converter converter = new ObjectToMapConverter();
            Map map = (Map) converter.convert(categoryEntity, HashMap.class);

            map.put("token", tokenService.accessToken());

            Call<CategoryResp> call = jdProductRestApi.getCategory(Lang.filterNullMap(map, false));
            CategoryResp categoryResp = call.execute().body();
            Map returnMap = new HashMap();
            returnMap.put("response", categoryResp);
            //jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return categoryResp;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public CategorysResp getCategorys(CategorysEntity categorysEntity) {
        try {
            utils.convert.Converter converter = new ObjectToMapConverter();
            Map map = (Map) converter.convert(categorysEntity, HashMap.class);

            map.put("token", tokenService.accessToken());


            Call<CategorysResp> call = jdProductRestApi.getCategorys(Lang.filterNullMap(map, false));
            CategorysResp categorysResp = call.execute().body();
            Map returnMap = new HashMap();
            returnMap.put("response", categorysResp);
            // jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(returnMap),null,null);
            return categorysResp;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public String addJdGood(Long sku) {
        List<String> goodsIds = productTransactionalService.addGoods(sku);

        return goodsIds == null || goodsIds.size() <= 0 ? null : goodsIds.get(0);
    }


    //临时方法，不规范
    @Autowired
    StockStateDao stockStateDao;

    //    @Async
    @Override
    public void refreshCtStock() {
        new Thread() {
            @Override
            public void run() {
                logger.info("进入刷新诚通库存");
                long startTime = System.currentTimeMillis();
                /**
                 * 生产多线程nginx 有时502，暂时单线程
                 */
                ExecutorService executorService = Executors.newFixedThreadPool(1);
                try {
                    long totalNum = stockStateDao.count();
                    int pageSize = 100;
                    int totalPage;
                    if (totalNum % pageSize == 0) {
                        totalPage = (int) (totalNum / pageSize);
                    } else {
                        totalPage = (int) (totalNum / pageSize) + 1;
                    }
                    CountDownLatch countDownLatch = new CountDownLatch(totalPage);
                    for (int i = 0; i < totalPage; i++) {
                        int pageIndex = i;
                        executorService.execute(new Runnable() {
                            @Override
                            public void run() {
                                try {
                                    logger.info("正在调用第{}页京东商品,totalPage={}", pageIndex + 1, totalPage);
                                    Pageable pageable = new PageRequest(pageIndex, pageSize);
                                    Page<StockState> stockStates = stockStateDao.findAll(pageable);
                                    List<StockVO> stockVOs = new ArrayList<>();
                                    List<Long> skus = new ArrayList<>();
                                    for (StockState stockState : stockStates.getContent()) {
                                        StockVO stockVO = new StockVO();
                                        stockVO.setSkuId(stockState.getSkuId());
                                        stockVO.setNum(1);
                                        stockVOs.add(stockVO);
                                        skus.add(stockState.getSkuId());
                                    }
                                    StockForOrderEntity stockForOrderEntity = new StockForOrderEntity();
                                    stockForOrderEntity.setArea("1_2802_2821_0");
                                    stockForOrderEntity.setSkuNums(stockVOs);
                                    List<StockNewResultVo> stockForOrder = getStockForOrder(stockForOrderEntity);
                                    Map<Long, StockNewResultVo> map = new HashMap<>();
                                    for (StockNewResultVo stockNewResultVo : stockForOrder) {
                                        map.put(stockNewResultVo.getSkuId(), stockNewResultVo);
                                    }
                                    List<ProductStateVO> productStateVOS = getProductState(skus);
                                    Set<Long> saleOutSkus = new HashSet<>();//下架商品sku收集列表
                                    for (ProductStateVO productStateVO : productStateVOS) {
                                        if (productStateVO.getState() == 0) {
                                            //商品已下架
                                            saleOutSkus.add(productStateVO.getSku());
                                        }
                                    }
                                    for (StockState stockState : stockStates.getContent()) {
                                        StockNewResultVo stockNewResultVo = map.get(stockState.getSkuId());
                                        if (stockNewResultVo == null) {
                                            stockState.setStockStateId(34);//无货
                                            stockState.setStockStateDesc("无货");
                                            stockState.setRemainNum(0);
                                        } else if (!saleOutSkus.isEmpty() && saleOutSkus.contains(stockState.getSkuId())) {
                                            stockState.setRemainNum(stockNewResultVo.getRemainNum());
                                            stockState.setStockStateDesc(stockNewResultVo.getStockStateDesc());
                                            stockState.setStockStateId(stockNewResultVo.getStockStateId());
                                            stockState.setStockStateDesc("下架");
                                            stockState.setAreaId(stockNewResultVo.getAreaId());
                                        } else {
                                            stockState.setRemainNum(stockNewResultVo.getRemainNum());
                                            stockState.setStockStateDesc(stockNewResultVo.getStockStateDesc());
                                            stockState.setStockStateId(stockNewResultVo.getStockStateId());
                                            stockState.setStockStateDesc(stockNewResultVo.getStockStateDesc());
                                            stockState.setAreaId(stockNewResultVo.getAreaId());
                                        }
                                    }

                                    stockStateDao.save(stockStates.getContent());
                                } catch (Exception e) {
                                    logger.error("刷新第{}页商品库存出错", pageIndex);
                                } finally {
                                    countDownLatch.countDown();
                                }
                            }
                        });
                    }
                    countDownLatch.await();
                    logger.info("更新京东库存时间：{}", System.currentTimeMillis() - startTime);
                    goodsApi.refreshCtStock();
                } catch (Exception e) {
                    logger.error("刷新库存失败", e);
                } finally {
                    if (!executorService.isShutdown()) {
                        executorService.shutdown();
                    }
                }
            }
        }.start();
    }

    @Override
    public List<StockStateDto> findBySku(String sku) {
        Long skuId = Long.parseLong(sku);
        return mapperFacade.mapAsList(stockStateDao.findBySkuId(skuId),StockStateDto.class);
    }

    @Override
    public void save(StockStateDto stockState) {
        stockStateDao.save(mapperFacade.map(stockState,StockState.class));
    }

    @Override
    public void executorsPoolAdd(List<Long> productNosList, int totalNum, Boolean isThread, Integer poolSize) {
        productDbInitService.executorsPoolAdd(productNosList, totalNum, isThread, poolSize);
    }


    public Map addProdBySkus(Map resMap, String skus) {
        return productDbInitService.addProdBySkus(resMap, skus);
    }

    @Autowired
    ProductDbInitService productDbInitService;
    @Autowired
    ProductTransactionalService productTransactionalService;
}
