package jd.service.jdapi.product;

import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import jd.api.service.product.StockStateApi;
import jd.api.vo.product.StockStateDTO;
import jd.service.service.StockStateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

@MotanService
public class StockStateApiImpl implements StockStateApi {

    @Autowired
    private StockStateService stockStateService;

    /**
     * 分页查询所有诚通商品数据
     *
     * @param pageable
     * @return
     */
    @Override
    public Page<StockStateDTO> findAll(Pageable pageable) {
        return stockStateService.findAll(pageable);
    }

    /**
     * 数据总量
     *
     * @return
     */
    @Override
    public Long count() {
        return stockStateService.count();
    }
}
