package jd.service.jdapi.test;

import com.alibaba.fastjson.JSON;
import jd.service.retrofit.api.TestRestApi;
import jd.service.retrofit.converter.FastJsonConverterFactory;
import org.springframework.stereotype.Service;
import retrofit2.Call;
import retrofit2.Retrofit;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by xujingfeng on 2017/3/7.
 */
@Service
public class TestApi {
    private TestRestApi testRestApi;

    public TestApi() {
        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl("http://127.0.0.1:7081/")
                .addConverterFactory(FastJsonConverterFactory.create())
                .build();
        this.testRestApi = retrofit.create(TestRestApi.class);
    }

    public TestVO test(){
        try{
            Map<String,Object> map = new HashMap<>();
            map.put("name","徐旋");
            map.put("date",new Date());
            Call<TestVO> response = testRestApi.test(map);
            TestVO body = response.execute().body();
            System.out.println(JSON.toJSONString(body));
            return body;
        }catch (Exception e){
            e.printStackTrace();
            return null;
        }

    }
}
