package jd.service.jdapi.token;

import com.alibaba.fastjson.JSON;
import jd.service.retrofit.api.AbstractJdApi;
import jd.service.retrofit.api.JDAuthApi;
import jd.service.retrofit.config.RetrofitConfigVo;
import jd.service.retrofit.converter.BeanToMapUtil;
import jd.service.service.JdSystemLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;
import utils.Lang;
import utils.security.MD5Utils;

import javax.annotation.PostConstruct;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * Created by xujingfeng on 2016年10月26日
 */
@Service
public class TokenService extends AbstractJdApi {

    private static final Logger logger = LoggerFactory.getLogger(TokenService.class);
    private Retrofit retrofit;

    public final String accessTokenStr = "szjdapi:jdTokenData";

    private JDAuthApi jdAuthApi;

    private volatile TokenVO tokenVO = null;

    public void setTokenVO(TokenVO tokenVO) {
        this.tokenVO = tokenVO;
    }

    @Autowired
    RetrofitConfigVo retrofitConfigVo;

    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    JdSystemLogService jdSystemLogService;

    @PostConstruct
    private void inited() {
        logger.info("JD access token :{}", getToken(false));
    }

    public TokenService(@Value("${retrofit.tokenUrl}") String tokenUrl) {
        this.retrofit = new Retrofit.Builder()
                .baseUrl(tokenUrl)
                .addConverterFactory(JacksonConverterFactory.create())
                .build();
        this.jdAuthApi = this.retrofit.create(JDAuthApi.class);
    }

    public String accessToken() {
        return getToken(false).getAccess_token();
    }

    public TokenVO getToken(boolean force) {
        String tokenKey=accessTokenStr+retrofitConfigVo.getUserEntity().getUsername();
        BoundValueOperations<String, String> accessTokenOp = redisTemplate.boundValueOps(tokenKey);
        if (!force) {
            //内存中有，直接返回
            if (tokenVO != null) {
                return tokenVO;
            }
            //去京东取放入
            String tokenData =accessTokenOp.get();
            if (tokenData == null || "".equals(tokenData.trim())) {
                //调用接口获取
                TokenVO tokenVO = getTokenVO(retrofitConfigVo.getUserEntity());
                //设置redis
                if (tokenVO != null) {
                    accessTokenOp.set(JSON.toJSONString(tokenVO));
                }
                //设置内存
                this.tokenVO = tokenVO;
            } else {
                //从redis拿
                try {
                    tokenVO = JSON.parseObject(tokenData, TokenVO.class);
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
            }
        } else {
            TokenVO tokenVO = getTokenVO(retrofitConfigVo.getUserEntity());
            if (tokenVO != null) {
                accessTokenOp.set(JSON.toJSONString(tokenVO));
                redisTemplate.expire(tokenKey.toString(), 10, TimeUnit.MINUTES); // 缓存10分钟后失效
                this.tokenVO = tokenVO;
            }
        }
        return tokenVO;
    }

    /**
     * 获取token
     *
     * @param user
     * @return
     * @throws Exception
     */
    private TokenVO getTokenVO(UserEntity user) {
        try {
            user.setTimestamp(sdf.get().format(new Date()));
            user.setSign(createSign(user));
//            utils.convert.Converter converter = new ObjectToMapConverter();
//            Map map = (Map) converter.convert(user, HashMap.class);
            Map map = BeanToMapUtil.convertBean(user);

            Call<TokenResponse> response = jdAuthApi.accessToken(Lang.filterNullMap(map, false));
            TokenVO token = null;
            if (response != null) {
                TokenResponse body = response.execute().body();
                logger.info("getTokenVO {}", JSON.toJSONString(body.getResult()));
                token = body.getResult();
            }
            return token;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    public TokenVO refreshToken() {
        Map<String, String> map = new HashMap<>();
        map.put("refresh_token", tokenVO.getRefresh_token());
        map.put("client_id", retrofitConfigVo.getUserEntity().getClient_id());
        map.put("client_secret", retrofitConfigVo.getUserEntity().getClient_secret());
        String tokenKey=accessTokenStr+retrofitConfigVo.getUserEntity().getUsername();
        Call<TokenResponse> call = jdAuthApi.refreshToken(map);
        try {
            TokenResponse body = call.execute().body();
            this.tokenVO = body.getResult();
            BoundValueOperations<String, String> accessTokenOp = redisTemplate.boundValueOps(tokenKey);
            accessTokenOp.set(JSON.toJSONString(this.tokenVO));
            redisTemplate.expire(tokenKey.toString(), 10, TimeUnit.MINUTES); // 缓存10分钟后失效
            logger.info("refreshToken {}", JSON.toJSONString(body.getResult()));
            return this.tokenVO;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    private String createSign(UserEntity user) {
        String username = user.getUsername();
        String password = user.getPassword();
        String timestamp = user.getTimestamp();
        String clientSecret = user.getClient_secret();
        String clientId = user.getClient_id();
        String sign = clientSecret + timestamp + clientId + username + password + "access_token" + clientSecret;
        return MD5Utils.MD5Encode(sign, "utf-8").toUpperCase();
    }
}
