package jd.service.job.scheduling;

import com.alibaba.fastjson.JSON;
import jd.service.jdapi.token.TokenService;
import jd.service.jdapi.token.TokenVO;
import jdek.service.jdekapi.token.TokenServiceJdek;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by xujingfeng on 2017/2/18.
 */
@Service
public class TokenJobRunner {

    @Autowired
    TokenService tokenService;
    @Autowired
    TokenServiceJdek tokenServiceJdek;

    final static private Logger logger = LoggerFactory.getLogger(TokenJobRunner.class);

    public TokenJobRunner() {
        System.out.println("TokenJobRunner=====================");
    }

    public void run(){
        logger.info("开始刷新token");
        try{
            TokenVO tokenVO = tokenService.refreshToken();
            logger.info("定时刷新 tokenVO {}", JSON.toJSONString(tokenVO));
        }catch (Exception e){
            logger.info("刷新 tokenVO 异常 {}", JSON.toJSONString(e));
        }
        try{
                tokenServiceJdek.refreshToken();
        }catch (Exception e){
            logger.info("刷新 tokenVO 异常 {}", JSON.toJSONString(e));
        }
    }

}
