package jd.service.retrofit.api;

import jd.api.response.address.AddressDetailResp;
import retrofit2.Call;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.POST;

import java.util.Map;

/**
 * Created by xujingfeng on 2017/3/7.
 */
public interface JdAddressRestApi {

    /**
     * 4.1 获取一级地址
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/area/getProvince")
    Call<AddressDetailResp> getProvince(@FieldMap Map<String, Object> map);

    /**
     * 4.2 获取二级地址
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/area/getCity")
    Call<AddressDetailResp> getCity(@FieldMap Map<String, Object> map);

    /**
     * 4.3 获取三级地址
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/area/getCounty")
    Call<AddressDetailResp> getCounty(@FieldMap Map<String, Object> map);

    /**
     * 4.4 获取四级地址
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/area/getTown")
    Call<AddressDetailResp> getTown(@FieldMap Map<String, Object> map);



}
