package jd.service.retrofit.api;

import jd.api.response.aftersale.*;
import retrofit2.Call;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.POST;

import java.util.Map;

/**
 * Created by xujingfeng on 2017/3/7.
 */
public interface JdAftersaleRestApi {

    /**
     * 10.1 服务单保存申请
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/afterSale/createAfsApply")
    Call<AfsApplyResp> createAfsApply(@FieldMap Map<String, Object> map);

    /**
     * 10.2 填写客户发运信息
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/afterSale/updateSendSku")
    Call<SendSkuResp> updateSendSku(@FieldMap Map<String, Object> map);

    /**
     * 10.3 校验某订单中某商品是否可以提交售后服务
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/afterSale/getAvailableNumberComp")
    Call<AvailableNumberCompResp> getAvailableNumberComp(@FieldMap Map<String, Object> map);

    /**
     * 10.4 根据订单号、商品编号查询支持的服务类型
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/afterSale/getCustomerExpectComp")
    Call<CustomerExpectCompResp> getCustomerExpectComp(@FieldMap Map<String, Object> map);

    /**
     * 10.5 根据订单号、商品编号查询支持的商品返回京东方式
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/afterSale/getWareReturnJdComp")
    Call<WareReturnJdCompResp> getWareReturnJdComp(@FieldMap Map<String, Object> map);

    /**
     * 10.6 根据客户账号和订单号分页查询服务单概要信息
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/afterSale/getServiceListPage")
    Call<ServiceListPageResp> getServiceListPage(@FieldMap Map<String, Object> map);

    /**
     * 10.7 根据服务单号查询服务单明细信息
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/afterSale/getServiceDetailInfo")
    Call<ServiceDetailInfoResp> getServiceDetailInfo(@FieldMap Map<String, Object> map);

    /**
     * 10.8 取消服务单/客户放弃
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/afterSale/auditCancel")
    Call<AuditCancelResp> auditCancel(@FieldMap Map<String, Object> map);



}
