package jd.service.retrofit.api;

import jd.api.response.order.*;
import retrofit2.Call;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.POST;
import sinomall.global.common.vo.outsideapi.OrderCancelOrderResp;

import java.util.Map;

/**
 * Created by xujingfeng on 2017/3/7.
 */
public interface JdOrderRestApi {

    /**
     * 7.1 统一下单接口
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/order/submitOrder")
    Call<OrderUniteSubmitResp> submitOrder(@FieldMap Map<String, Object> map);

    /**
     * 7.2 确认预占库存订单接口
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/order/confirmOrder")
    Call<OccupyStockResp> confirmOrder(@FieldMap Map<String, Object> map);

    /**
     * 7.3 取消未确认订单接口
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/order/cancel")
    Call<OrderCancelOrderResp> cancel(@FieldMap Map<String, Object> map);


    /**
     * 7.6 订单反查接口
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/order/selectJdOrderIdByThirdOrder")
    Call<OrderRevResp> selectJdOrderIdByThirdOrder(@FieldMap Map<String, Object> map);

    /**
     * 7.7 查询京东订单信息接口
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/order/selectJdOrder")
    Call<OrderSplitResp> selectJdOrder(@FieldMap Map<String, Object> map);

    /**
     * 7.8 查询配送信息接口
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/order/orderTrack")
    Call<OrderTrackResp> orderTrack(@FieldMap Map<String, Object> map);

    /**
     * 3.11 运费查询接口
     *
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/order/getFreight")
    Call<OrderFreightResp> getFreight(@FieldMap Map<String, Object> map);


    /***
     * 7.13 统一余额查询接口
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/price/getBalance")
    Call<OrderBalanceResp> getBalance(@FieldMap Map<String, Object> map);
    /**
     * 8.1 新建订单查询接口
     *
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/checkOrder/checkNewOrder")
    Call<CheckOrderResp> checkNewOrder(@FieldMap Map<String, Object> map);

    /**
     * 8.2 获取妥投订单接口
     *
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/checkOrder/checkDlokOrder")
    Call<CheckOrderResp> checkDlokOrder(@FieldMap Map<String, Object> map);

    /**
     * 8.3 获取拒收消息接口
     *
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/checkOrder/checkRefuseOrder")
    Call<CheckOrderResp> checkRefuseOrder(@FieldMap Map<String, Object> map);

}
