package jd.service.retrofit.api;

import jd.api.response.core.CommonResponse;
import jd.api.response.product.*;
import jd.api.vo.product.SimilarProduct;
import retrofit2.Call;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.POST;

import java.util.List;
import java.util.Map;

/**
 * Created by xujingfeng on 2017/3/7.
 */
public interface JdProductRestApi {

    /**
     * 3.1 获取商品池编号接口
     *
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/product/getPageNum")
    Call<ProductPoolResp> getPageNum(@FieldMap Map<String, Object> map);

    /**
     * 3.2 获取池内商品编号接口
     *
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/product/getSku")
    Call<ProductPoolProductResp> getSku(@FieldMap Map<String, Object> map);

    /***
     * 3.3 获取池内商品编号接口-品类商品池（兼容老接口）
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/product/getSkuByPage")
    Call<ProductPoolProductResp> getSkuByPage(@FieldMap Map<String, Object> map);
    /**
     * 3.4 获取商品详细信息接口
     *
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/product/getDetail")
    Call<ProductDetailResp> getDetail(@FieldMap Map<String, Object> map);

    /**
     * 3.5 获取商品上下架状态接口
     *
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/product/skuState")
    Call<ProductStateResp> skuState(@FieldMap Map<String, Object> map);

    /**
     * 3.6 获取所有图片信息
     *
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/product/skuImage")
    Call<ProductSkuImageResp> skuImage(@FieldMap Map<String, Object> map);

    /**
     * 3.7 商品好评度查询
     *
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/product/getCommentSummarys")
    Call<ProductCommentSummarysResp> getCommentSummarys(@FieldMap Map<String, Object> map);

    /**
     * 3.8 商品区域购买限制查询
     *
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/product/checkAreaLimit")
    Call<SkuIdsAndAreaNewResp> checkAreaLimit(@FieldMap Map<String, Object> map);

    /**
     * 3.9 商品区域是否支持货到付款
     *
     * 2017/3/6 该接口新增
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/product/getIsCod")
    Call<CommonResponse<Boolean>> getIsCod(@FieldMap Map<String, Object> map);


    /**
     * 3.13 商品可售验证接口
     *
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/product/check")
    Call<ProductCheckResp> check(@FieldMap Map<String, Object> map);

    /**
     * 3.15 查询分类信息接口
     *
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/product/getCategory")
    Call<CategoryResp> getCategory(@FieldMap Map<String, Object> map);

    /**
     * 3.16 查询分类列表信息接口
     *
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/product/getCategorys")
    Call<CategorysResp> getCategorys(@FieldMap Map<String, Object> map);

    /**
     * 3.17 同类商品查询
     *
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/product/getSimilarSku")
    Call<CommonResponse<List<SimilarProduct>>> getSimilarSku(@FieldMap Map<String, Object> map);

    /**
     * 5.3 批量查询商品售卖价
     *
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/price/getSellPrice")
    Call<PriceResp> getSellPrice(@FieldMap Map<String, Object> map);

    /**
     * 6.2 批量获取库存接口（建议订单详情页、下单使用）
     *
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/stock/getNewStockById")
    Call<StockForOrderNewResp> getNewStockById(@FieldMap Map<String, Object> map);

    /**
     * 6.3 批量获取库存接口 (建议商品列表页使用)
     *
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/stock/getStockById")
    Call<StockForFrontResp> getStockById(@FieldMap Map<String, Object> map);

    /**
     * 9.1 信息推送接口
     *
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/message/get")
    Call<MessageGetResp> get(@FieldMap Map<String, Object> map);

    /**
     * 9.2 根据推送id，删除推送信息接口
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("api/message/del")
    Call<MessageDelResp> del(@FieldMap Map<String, Object> map);

}
