package jd.service.retrofit.config;

import brave.Tracing;
import brave.opentracing.BraveTracer;
import com.weibo.api.motan.filter.opentracing.TracerFactory;
import io.opentracing.Tracer;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.okhttp3.OkHttpSender;

/**
 * @author Liang Wenxu
 * @since 2018-05-24
 */
public class BraveTarcerFactory implements TracerFactory {

    private static Tracer braveTracer;

    public BraveTarcerFactory(ZipkinBraveTarcerProperties zipkinBraveTarcerProperties) {
        if(zipkinBraveTarcerProperties.isEnable() != null && zipkinBraveTarcerProperties.isEnable()) {
            braveTracer = BraveTracer.create(Tracing.newBuilder()
                    .localServiceName(zipkinBraveTarcerProperties.getServiceName())
                    .spanReporter(AsyncReporter.builder(
                            OkHttpSender.newBuilder()
                                    .endpoint(zipkinBraveTarcerProperties.getUrl())
                                    .compressionEnabled(zipkinBraveTarcerProperties.isCompressionEnabled())
                                    .connectTimeout(zipkinBraveTarcerProperties.getConnectTimeout())
                                    .readTimeout(zipkinBraveTarcerProperties.getReadTimeout()).build()
                            ).build()
                    ).build());
        }

    }




    @SuppressWarnings("deprecation")
    @Override
    public Tracer getTracer() {
//        return mockTracer;
        return braveTracer;
    }

}