package jd.service.retrofit.config;

import com.weibo.api.motan.config.springsupport.*;
import com.weibo.api.motan.filter.opentracing.OpenTracingContext;
import com.weibo.api.motan.filter.opentracing.TracerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import utils.Lang;
import utils.spring.ApplicationContextProvider;

/**
 * Created by xujingfeng on 2016年10月26日
 */
@Configuration
public class MotanConfig {

    @Value("${motan.client.group}")
    private String motanClientGroup;

    @Value("${motan.client.access.log}")
    private Boolean motanClientAccessLog;

    @Value("${motan.server.group}")
    private String motanServerGroup;

    @Value("${motan.server.access.log}")
     private Boolean motanServerAccessLog;

    @Value("${motan.server.maxWorkerThread:800}")
    private Integer maxWorkerThread;

    @Value("${motan.server.minWorkerThread:20}")
    private Integer minWorkerThread;



    @Bean
    ApplicationContextProvider applicationContextProvider(){
        return  new ApplicationContextProvider();
    }

    @Bean
    public AnnotationBean motanAnnotationBean() {
        AnnotationBean motanAnnotationBean = new AnnotationBean();
        motanAnnotationBean.setPackage("jd.service,jdek.service");
        if(motanAnnotationBean.getPackage()==null){
            throw new RuntimeException("请配置maton api 包");
        }
        return motanAnnotationBean;
    }

    @Bean(name = "motan")
    public ProtocolConfigBean protocolConfig() {
       ProtocolConfigBean config = new ProtocolConfigBean();config.setMaxClientConnection(30);
        config.setDefault(true);
        config.setName("motan");
        config.setMaxContentLength(999999999);
        config.setMaxWorkerThread(maxWorkerThread == null ? 800 : maxWorkerThread);
        config.setMinWorkerThread(minWorkerThread == null ? 20 : minWorkerThread);

        //config.setLoadbalance("localFirst");
       // config.setSerialization("fastjson");
        config.setSerialization("hibernateHessian2");
        return config;
    }

    @Bean(name = "registry")
    public RegistryConfigBean registryConfigSit(@Value("${motan.zookeeper.host}")String zookeeperAddress) {
        RegistryConfigBean config = new RegistryConfigBean();
        config.setDefault(true);
        config.setRegProtocol("commondZookeeper");
        config.setAddress(zookeeperAddress);
        return config;
    }

    /**
     * 基础服务端配置
     * @param port
     * @return
     */
    @Bean(name = "motanServerBasicConfig")
    public BasicServiceConfigBean baseServiceConfig(@Value("${motan.export.port}") String port,
                                                    @Value("${spring.zipkin.tarcer.brave.enable:false}") Boolean opentracingEnabled) {
        BasicServiceConfigBean config = new BasicServiceConfigBean();
        config.setDefault(true);
        config.setExport("motan:"+port);
        // config.setGroup("sinomall");
        // config.setAccessLog(false);
        if(Lang.isEmpty(motanServerGroup)){
            config.setGroup("sinomall");
        }else {
            config.setGroup(motanServerGroup);
        }
        if(Lang.isEmpty(motanServerAccessLog)){
            config.setAccessLog(false);
        }else {
            config.setAccessLog(motanServerAccessLog);
        }
        config.setShareChannel(true);
        //config.setModule("motan-demo-rpc");
        //config.setApplication("myMotanDemo");
        config.setRequestTimeout(9000000);
//        config.setFilter("openjpasession");
        config.setRegistry("registry");
        if(opentracingEnabled) {
            config.setFilter("opentracing");
        }
        return config;
    }


    @Bean(name = "motanClientBasicConfig")
    public BasicRefererConfigBean baseRefererConfig(@Value("${spring.zipkin.tarcer.brave.enable:false}") Boolean opentracingEnabled) {
        BasicRefererConfigBean config = new BasicRefererConfigBean();
        config.setProtocol("motan");
        //  config.setGroup("sinomall");
        if(Lang.isEmpty(motanClientGroup)){
            config.setGroup("sinomall");
        }else {
            config.setGroup(motanClientGroup);
        }
        if(Lang.isEmpty(motanClientAccessLog)){
            config.setAccessLog(false);
        }else {
            config.setAccessLog(motanClientAccessLog);
        }
        ///config.setModule("motan-demo-rpc");
        //config.setApplication("myMotanDemo");
        config.setRegistry("registry");
        config.setCheck(false);
        // config.setAccessLog(false);
        //config.setRetries(2);
        config.setThrowException(true);
        config.setRequestTimeout(120*1000);

        config.setDefault(true);
        if(opentracingEnabled) {
            config.setFilter("opentracing");
        }
        return config;
    }

    /**
     * 不进行重试的Motan客户端配置
     * @return
     */
    @Bean(name = "motanClientFastFailConfig")
    public BasicRefererConfigBean clientFastFailConfig(@Value("${spring.zipkin.tarcer.brave.enable:false}") Boolean opentracingEnabled) {
        BasicRefererConfigBean config = new BasicRefererConfigBean();
        config.setProtocol("motan");
        if(Lang.isEmpty(motanClientGroup)){
            config.setGroup("sinomall");
        }else {
            config.setGroup(motanClientGroup);
        }
        if(Lang.isEmpty(motanClientAccessLog)){
            config.setAccessLog(false);
        }else {
            config.setAccessLog(motanClientAccessLog);
        }
        config.setRegistry("registry");
        config.setCheck(false);
        config.setRequestTimeout(120*1000);
        config.setThrowException(true);
        config.setDefault(true);
        if(opentracingEnabled) {
            config.setFilter("opentracing");
        }
        return config;
    }
}
