package jd.service.retrofit.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import okhttp3.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import retrofit2.Retrofit;
import jd.service.jdapi.token.TokenService;
import jd.service.retrofit.converter.FastJsonConverterFactory;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

/**
 * Created by xiaoqian on 2016/8/10.
 */
@Configuration
@ComponentScan("jdek.service")
public class RetrofitConfig {

    private static final Logger okhttpLogger = LoggerFactory.getLogger("retrofitLog");

    @ConfigurationProperties(prefix = "retrofit")
    @Bean
    RetrofitConfigVo retrofitConfigVo() {
        return new RetrofitConfigVo();
    }


    @Bean
    public Retrofit retrofit(final TokenService tokenService) {
        RetrofitConfigVo retrofitConfigVo = retrofitConfigVo();
        OkHttpClient.Builder builder = new OkHttpClient.Builder();

        if (retrofitConfigVo.getLogRequest()) {
            builder.addInterceptor(new Interceptor() {
                @Override
                public Response intercept(Chain chain) throws IOException {
                    //打印post请求日志
                    Request request = chain.request();
                    okhttpLogger.info("Sending request {} ,request method:{}", request.url(), request.method());
                    if ("POST".equals(request.method())) {
                        StringBuilder sb = new StringBuilder();
                        if (request.body() instanceof FormBody) {
                            FormBody body = (FormBody) request.body();
                            for (int i = 0; i < body.size(); i++) {
                                sb.append(body.encodedName(i) + "=" + body.encodedValue(i) + ",");
                            }
                            sb.delete(sb.length() - 1, sb.length());
                            okhttpLogger.info("requestParams: {}", sb.toString());
                        }
                    }
                    //先获取响应，做token过期判断
                    Long requestTime = System.currentTimeMillis();
                    Response response = chain.proceed(request);
                    MediaType mediaType = response.body().contentType();
                    String content = response.body().string();
                    okhttpLogger.info("content:{}, 耗时：{}ms", content, System.currentTimeMillis() - requestTime);
                    JSONObject parseObject = JSON.parseObject(content);
                    if (parseObject != null) {
                        if ("2007".equals(parseObject.get("resultCode"))) {
                            tokenService.getToken(true);
                            String accessToken = tokenService.accessToken();
                            //重新执行请求

                            Request original = request;
                            HttpUrl originalHttpUrl = original.url();

                            HttpUrl url = originalHttpUrl.newBuilder()
                                    .setQueryParameter("token",accessToken)
                                    .build();
                            // Request customization: add request headers
                            Request.Builder requestBuilder = original.newBuilder()
                                    .url(url);
                            return chain.proceed(requestBuilder.build());
                        }
                    }
                    return response
                            .newBuilder()
                            .body(ResponseBody.create(mediaType,
                                    content)).build();
                }
            });

        }

        builder.connectTimeout(60, TimeUnit.SECONDS);
        builder.readTimeout(60, TimeUnit.SECONDS);

        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(retrofitConfigVo.getBaseUrl())
                .addConverterFactory(FastJsonConverterFactory.create())
                .client(builder.build()).build();
        return retrofit;
    }

}
