package jd.service.service;


import cms.model.Organization;
import cms.model.repository.OrganizationRepos;
import goods.model.Goods;
import goods.model.ProductCategory;
import goods.model.ProductCategoryConfig;
import goods.model.repository.GoodsRepos;
import goods.model.repository.ProductCategoryConfigRepos;
import goods.model.repository.ProductCategoryExtTaxRateRepos;
import goods.model.repository.ProductCategoryRepos;
import jd.api.request.product.CategoryEntity;
import jd.api.request.product.CategorysEntity;
import jd.api.request.product.ProductDetailEntity;
import jd.api.response.product.CategoryResp;
import jd.api.response.product.CategorysResp;
import jd.api.service.product.JdProductApi;
import jd.api.vo.product.CategoryVO;
import jd.api.vo.product.ProductDetailVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import utils.Lang;
import utils.log.Log;
import utils.log.Logs;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * Created by xujingfeng on 2016/12/2.
 */
@Service
public class CategoryDbService {
    Log logger = Logs.getLog(CategoryDbService.class.getName());

    @Autowired
    JdProductApi jdProductApi;
    @Autowired
    ProductCategoryRepos productCategoryRepos;

    @Autowired
    GoodsRepos goodsRepos;

    @Autowired
    OrganizationRepos organizationRepos;

    @Autowired
    ProductCategoryConfigRepos productCategoryConfigRepos;

    @Value("${jd.store.code}")
    private String jdCode;

    @Value("${jd.store.id}")
    private String jdId;

    public void initCategory() {
        List<CategoryVO> categoryOneVOs = queryCategorysByCatclass(0, 100);
        if (categoryOneVOs != null) {
            for (CategoryVO categoryOneVO : categoryOneVOs) {
                //一级分类
                ProductCategory categoryOne = new ProductCategory();
                categoryOne.setState(categoryOneVO.getState());
                categoryOne.setCode(categoryOneVO.getCatId());
                categoryOne.setLayerIndex(categoryOneVO.getCatClass() + 1);
                categoryOne.setName(categoryOneVO.getName());
                categoryOne.setTplChannel(jdCode);
                categoryOne.setSourceCode(jdCode);
                productCategoryRepos.saveAndFlush(categoryOne);
                //查找该一级分类下的二级分类
                List<CategoryVO> categoryTwoVOs = queryCategorysByParentId(categoryOneVO.getCatId(), 100);
                if (categoryTwoVOs != null) {
                    for (CategoryVO categoryTwoVO : categoryTwoVOs) {
                        //二级分类
                        ProductCategory categoryTwo = new ProductCategory();
                        categoryTwo.setParent(categoryOne);
                        categoryTwo.setState(categoryTwoVO.getState());
                        categoryTwo.setCode(categoryTwoVO.getCatId());
                        categoryTwo.setLayerIndex(categoryTwoVO.getCatClass() + 1);
                        categoryTwo.setName(categoryTwoVO.getName());
                        categoryTwo.setTplChannel(jdCode);
                        categoryTwo.setSourceCode(jdCode);
                        productCategoryRepos.saveAndFlush(categoryTwo);
                        //查找该二级分类下的三级分类
                        List<CategoryVO> categoryThreeVOs = queryCategorysByParentId(categoryTwoVO.getCatId(), 100);
                        if (categoryThreeVOs != null) {
                            for (CategoryVO categoryThreeVO : categoryThreeVOs) {
                                //三级分类
                                ProductCategory categoryThree = new ProductCategory();
                                categoryThree.setParent(categoryTwo);
                                categoryThree.setState(categoryThreeVO.getState());
                                categoryThree.setCode(categoryThreeVO.getCatId());
                                categoryThree.setLayerIndex(categoryThreeVO.getCatClass() + 1);
                                categoryThree.setName(categoryThreeVO.getName());
                                categoryThree.setTplChannel(jdCode);
                                categoryThree.setSourceCode(jdCode);
                                productCategoryRepos.saveAndFlush(categoryThree);
                            }
                        }
                    }
                }
            }
        }
    }

    //根据级别查找
    public List<CategoryVO> queryCategorysByCatclass(int catClass, int pageSize) {
        CategorysResp categorysResp = jdProductApi.getCategorys(new CategorysEntity(1, pageSize, null, catClass));
        List<CategoryVO> categoryVOs = null;
        //1.查询catClass级分类
        if (categorysResp != null && categorysResp.getResult().getCategorys().size() > 0) {
            //查询第一页
            categoryVOs = categorysResp.getResult().getCategorys();
            Integer totalRows = categorysResp.getResult().getTotalRows();
            Integer totalPage = totalRows % pageSize == 0 ? totalRows / pageSize : totalRows / pageSize + 1;
            //查询剩余页
            for (int i = 2; i <= totalPage; i++) {
                categorysResp = jdProductApi.getCategorys(new CategorysEntity(i, 100, null, catClass));
                categoryVOs.addAll(categorysResp.getResult().getCategorys());
            }
        }
        return categoryVOs;
    }

    public List<CategoryVO> queryCategorysByParentId(int parentId, int pageSize) {
        CategorysResp categorysResp = jdProductApi.getCategorys(new CategorysEntity(1, pageSize, parentId, null));
        List<CategoryVO> categoryVOs = null;
        //查询parentId下所有的分类
        if (categorysResp != null && categorysResp.getResult().getCategorys().size() > 0) {
            //查询第一页
            categoryVOs = categorysResp.getResult().getCategorys();
            Integer totalRows = categorysResp.getResult().getTotalRows();
            Integer totalPage = totalRows % pageSize == 0 ? totalRows / pageSize : totalRows / pageSize + 1;
            //查询剩余页
            for (int i = 2; i <= totalPage; i++) {
                categorysResp = jdProductApi.getCategorys(new CategorysEntity(i, pageSize, parentId, null));
                categoryVOs.addAll(categorysResp.getResult().getCategorys());
            }
        }
        return categoryVOs;
    }

    /**
     * 重新关联所有未关联分类的商品
     * @return
     */
    public Map restAllProdCateGory() {
        long queryPageSize = 100;
        logger.info("Start restAllProdCateGory....");
        org.springframework.data.domain.Pageable pageable = new PageRequest(0, (int) queryPageSize);
        Specification specification = new Specification<Goods>() {
            @Override
            public Predicate toPredicate(Root<Goods> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                return cb.and(
                        cb.isNull(root.get("product").get("productCategory")),
                        cb.notEqual(root.get("isDelete"), true),
                        cb.equal(root.get("storeId"), jdId)
                );
            }
        };
        Page<Goods> goodsPage = null;
        List<String> skus = null;
        long totalCount = 0;
        while((totalCount = goodsRepos.count(specification)) > 0) {
            // 计算总页数
            long totalPageNum = (totalCount  +  queryPageSize  - 1) / queryPageSize;
            Sort sort = new Sort(Sort.Direction.ASC, "id");
            ExecutorService pool = Executors.newFixedThreadPool(3);
            for(int pn=0; pn < totalPageNum; pn++) {
                pool.execute(new ResetProductCatThread(specification, pn, (int)queryPageSize, sort, (int)totalPageNum));
            }

            if(!pool.isShutdown()) {
                pool.shutdown();
            }
        }
        return null;
    }

    private class ResetProductCatThread extends Thread {
        private Specification specification;
        private int page;
        private int pageSize;
        private Sort sort;
        private int totalPages;

        public ResetProductCatThread(Specification specification, int page, int pageSize, Sort sort, int totalPages) {
            this.specification = specification;
            this.page = page;
            this.pageSize = pageSize;
            this.sort = sort;
            this.totalPages = totalPages;
        }

        @Override
        public void run() {
            List<String> skus = new ArrayList<>();
            Page<Goods> goodsPage = goodsRepos.findAll(specification, new PageRequest(page, pageSize, sort));
            logger.info("正在处理需重新关联分类的商品[" + (page + 1) + "/" + totalPages + "]");
            for(Goods g : goodsPage) {
                skus.add(g.getSku());
            }
            resetProdCategory(skus);
        }
    }

    @Transactional
    public Map resetProdCategory(List<String> skus) {
        Organization organization = organizationRepos.findByOrgCodeAndIsDelete("jicai", false);
        String catId = null;
        ProductCategory category = null;
        StringBuilder sb = new StringBuilder();
        int handled = 1;
        for(String sku : skus) {
            logger.info("正在处理sku: " + sku);
            try {
                sb.append(handleRestCat(sku, organization)).append("\r\n");
                logger.info("已处理["+(handled++)+"/"+skus.size()+"]sku: " + sku);

            } catch (Exception ex) {
                logger.error("处理["+(handled++)+"/"+skus.size()+"]失败！sku: " + sku + ", 新分类: " + (category == null ? "" : category.getName()), ex);
            }
        }

        return new HashMap(){{
            put("status", "success");
            put("data", sb.toString());
        }};
    }

    @Transactional(propagation = Propagation.REQUIRES_NEW)
    private String handleRestCat(String sku, Organization organization) {
        StringBuilder rsStr = new StringBuilder();
        ProductDetailEntity productDetailEntity = new ProductDetailEntity();
        productDetailEntity.setSku(Long.valueOf(sku));
        String catId = null;
        ProductCategory category = null;
        ProductDetailVO productDetailVO = jdProductApi.getProductDetail(productDetailEntity);
        if(productDetailVO != null) {
            if(!Lang.isEmpty(productDetailVO.getCategory())) {
                String[] catIds =  productDetailVO.getCategory().split(";");
                if(catIds != null && catIds.length >= 1) {
                    catId = catIds[catIds.length - 1];
                }
                List<ProductCategory> categoryList = productCategoryRepos.findByCode(new Integer(catId));

                if(categoryList != null && categoryList.size() > 0) {
                    category = categoryList.get(0);
                    if(category.getIsDelete()) {
//                        category.setIsDelete(false);
                    }
                } else {
                    // 库里没有的，新增
                    String pid = null;
                    for (int i = 0; i < catIds.length; i++) {
                        categoryList = productCategoryRepos.findByCode(new Integer(catIds[i]));
                        if(categoryList != null && categoryList.size() > 0) {
                            category = categoryList.get(0);
                            if(category.getIsDelete()) {
//                                category.setIsDelete(false);
                                pid = category.getId();
                            }
                        } else {
                            category = new ProductCategory();
                            CategoryEntity categoryEntity = new CategoryEntity();
                            categoryEntity.setCid(catIds[i]);
                            CategoryResp categoryResp = jdProductApi.getCategory(categoryEntity);
                            if(categoryResp != null && categoryResp.getSuccess()) {
                                category.setLayerIndex(i + 1);
                                category.setCode(categoryResp.getResult().getCatId());
                                category.setName(categoryResp.getResult().getName());
                                category.setPath("https://www.jd.com/");

                            }
                            category.setParent(category == null ? null : productCategoryRepos.findById(pid));

                            category = productCategoryRepos.save(category);
                            // 增加config表
                            ProductCategoryConfig productCategoryConfig = new ProductCategoryConfig();
                            productCategoryConfig.setProductCategoryId(category.getId());
                            productCategoryConfig.setIsUp(true);
                            productCategoryConfig.setOrganizationId(organization.getId());
                            productCategoryConfigRepos.save(productCategoryConfig);
                            pid = category.getId();
                        }
                    }
                }
            }
            List<Goods> goods = goodsRepos.findBySku(sku);
            if(category != null) {
                for(Goods g : goods) {
                    g.getProduct().setProductCategory(category);
                }

                goodsRepos.save(goods);
            }

            logger.info("已处理sku: " + sku + ", 新分类: " + category == null ? "" : category.getName());
            return "已处理sku: " + sku + ", 新分类: " + category == null ? "" : category.getName();
        } else {
            logger.error("处理sku: "+ sku +"失败！失败原因： 京东接口查询不到该SKU");
            return "处理sku: "+ sku +"失败！失败原因： 京东接口查询不到该SKU";
        }
    }

    @Autowired
    ProductCategoryExtTaxRateRepos productCategoryExtTaxRateRepos;

//    @Autowired
//    SnCategoryTaxRateRepos snCategoryTaxRateRepos;


    public void matchCategory(){
//        BigDecimal shuilv=null;
//        List<String> temp=new ArrayList<String>();
//        boolean flag=true;
//        List<ProductCategory> productCategories= productCategoryRepos.findByLayerIndex(1);
//        for(int i=0;i<productCategories.size();i++){
//
//            String id1=productCategories.get(i).getId();
//            Integer code1=productCategories.get(i).getCode();
//            String name1=productCategories.get(i).getName();
//            List<ProductCategory> productCategories1=productCategoryRepos.findByParentIdOrderByShowIndexAsc(id1);
//            for(int j=0;j<productCategories1.size();j++)
//            {
//                String id2=productCategories1.get(j).getId();
//                Integer code2=productCategories1.get(j).getCode();
//                String name2=productCategories1.get(j).getName();
//                List<ProductCategory> productCategories2=productCategoryRepos.findByParentIdOrderByShowIndexAsc(id2);
//                for(int k=0;k<productCategories2.size();k++){
//
//                    List<String> SuningShuiLV=snCategoryTaxRateRepos.findAllLikeLevelThreeName(productCategories2.get(k).getName());
//                    if(SuningShuiLV.size()!=0){
//                        String shuilvtemp=SuningShuiLV.get(0);
//                        if(!Lang.isEmpty(shuilvtemp)) {
//                            shuilv = new BigDecimal(shuilvtemp);
//                        }
//
//                    }
//                    List<SnCategoryTaxRate> suNingCategories = snCategoryTaxRateRepos.findAllByLevelThreeName(productCategories2.get(k).getName());
//                    if(!Lang.isEmpty(suNingCategories) &&suNingCategories.size()<0 ){
//                    //if(suNingCategories.size()!=0){
//
//                        for(int m=0;m<suNingCategories.size();m++){
//                            ProductCategory productCategory=new ProductCategory();
//                            if(!suNingCategories.get(m).getLevelFourName().equals(productCategories2.get(k).getName())) {
//
//                                for (String name:temp)
//                                {
//                                    if(name.equals(suNingCategories.get(m).getLevelFourName())){
//                                        flag=false;
//                                    }
//                                }
//
//                                if(flag) {
//                                    productCategory.setCode(Integer.parseInt(suNingCategories.get(m).getLevelFourCode().substring(1)));
//                                    productCategory.setName(suNingCategories.get(m).getLevelFourName());
//                                    productCategory.setParent(productCategories1.get(j));
//                                    productCategoryRepos.saveAndFlush(productCategory);
//
//
//                                    ProductCategoryExtTaxRate productCategoryExtTaxRate = new ProductCategoryExtTaxRate();
//                                    productCategoryExtTaxRate.setLevelOneId(id1);
//                                    productCategoryExtTaxRate.setLevelOneCode(Integer.toString(code1));
//                                    productCategoryExtTaxRate.setLevelOneName(name1);
//                                    productCategoryExtTaxRate.setLevelTwoId(id2);
//                                    productCategoryExtTaxRate.setLevelTwoCode(Integer.toString(code2));
//                                    productCategoryExtTaxRate.setLevelTwoName(name2);
//                                    productCategoryExtTaxRate.setLevelThreeId(productCategory.getId());
//                                    productCategoryExtTaxRate.setLevelThreeCode(Integer.toString(productCategory.getCode()));
//                                    productCategoryExtTaxRate.setLevelThreeName(productCategory.getName());
//                                    productCategoryExtTaxRate.setTaxRate(new BigDecimal(suNingCategories.get(m).getTaxRate()));
//                                    productCategoryExtTaxRateRepos.save(productCategoryExtTaxRate);
//
//                                    temp.add(suNingCategories.get(m).getLevelFourName());
//
//                                }
//                                flag=true;
//                            }
//
//                        }
//
//                    }
//                    String id3=productCategories2.get(k).getId();
//                    Integer code3=productCategories2.get(k).getCode();
//                    String name3=productCategories2.get(k).getName();
//
//                    ProductCategoryExtTaxRate productCategoryExtTaxRate =new ProductCategoryExtTaxRate();
//                    productCategoryExtTaxRate.setLevelOneId(id1);
//                    productCategoryExtTaxRate.setLevelOneCode(Integer.toString(code1));
//                    productCategoryExtTaxRate.setLevelOneName(name1);
//                    productCategoryExtTaxRate.setLevelTwoId(id2);
//                    productCategoryExtTaxRate.setLevelTwoCode(Integer.toString(code2));
//                    productCategoryExtTaxRate.setLevelTwoName(name2);
//                    productCategoryExtTaxRate.setLevelThreeId(id3);
//                    productCategoryExtTaxRate.setLevelThreeCode(Integer.toString(code3));
//                    productCategoryExtTaxRate.setLevelThreeName(name3);
//                    productCategoryExtTaxRate.setTaxRate(shuilv);
//                    shuilv=null;
//                    productCategoryExtTaxRateRepos.save(productCategoryExtTaxRate);
//
//                }
//                temp.clear();
//            }
//
//
//
//
//        }
//        System.out.print("success");
    }


    public void deleteCategoryMatch() {
        productCategoryExtTaxRateRepos.deleteAll();

    }

}
