package jd.service.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import goods.api.GoodsConfigApi;
import goods.api.GoodsProductCatgoryApi;
import goods.model.*;
import goods.model.repository.*;
import goods.vo.GoodsConfigUpdateMessage;
import jd.api.request.product.CategorysEntity;
import jd.api.request.product.PageNumEntity;
import jd.api.request.product.ProductDetailEntity;
import jd.api.request.product.SkuEntity;
import jd.api.response.product.CategorysResp;
import jd.api.response.product.ProductCheckResp;
import jd.api.service.product.JdProductApi;
import jd.api.vo.product.*;

import jd.service.vo.ExistGoodsVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestParam;
import sinomall.global.common.response.BaseResponse;
import store.api.dto.modeldto.core.StoreDto;
import utils.Lang;
import utils.file.FileUtils;
import utils.log.Log;
import utils.log.Logs;
import utils.web.ResponseMapUtils;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * Created by Roney on 2017-07-15.
 * 初始化京东同步数据接口
 */
@Component
public class ProductDbInitService {
    private final static Log log = Logs.getLog(ProductDbInitService.class.getName());
    @Value("${spring.profiles.active}")
    private String activeEnv;

    public String getActiveEnv() {
        return activeEnv;
    }

    public void setActiveEnv(String activeEnv) {
        this.activeEnv = activeEnv;
    }

    @Autowired
    JdProductApi jdProductApi;

    @Autowired
    GoodsTempRepos goodsTempRepos;
    @Autowired
    GoodsRepos goodsRepos;
    @Autowired
    ProductRepos productRepos;
    @Autowired
    ProductCategoryRepos productCategoryRepos;
    @Autowired
    ProductBrandRepos productBrandRepos;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @MotanReferer
    GoodsConfigApi goodsConfigApi;

    @Autowired
    ProductPoolRepos productPoolRepos;

    @Autowired
    ProductPoolSkuRepos productPoolSkuRepos;


    @Value("${jd.store.code}")
    private String jdCode;

    @Value("${jd.store.id}")
    private String jdId;

    //所有商品池的商品编号（去重后）
    List<Long> productNosList;
    //线程池大小
    // final static int poolSize = 50;
    //商品总数
    int totalNum;

    //同步入口
    public void asyncInitProduct(Boolean isCompatible, Boolean isThread, Integer poolSize) {
        log.info("=======同步开始=======");
        //获取所有商品池
        List<ProductPoolVO> productPools = jdProductApi.getProductPool();
        //set去重
        Set<Long> productNoSet = new HashSet<Long>();
        for (ProductPoolVO productPool : productPools) {
            String pageNum = productPool.getPage_num();
            Boolean isProdEnv = true;
            /** 非生产环境不调用接口 */
            if (!Lang.isEmpty(this.activeEnv)) {
                String[] envArr = this.activeEnv.split(",");
                for (String env : envArr) {
                    if (!"product".equals(env.trim()) && !"prod".equals(env.trim())) {
                        isProdEnv = false;
                    }
                }
            }
            isProdEnv = true;
            if (isProdEnv) {
                List<Long> productNos = null;
                if (isCompatible) {
                    productNos = jdProductApi.getProductPoolProductOld(new PageNumEntity(pageNum, 1));
                } else {
                    productNos = jdProductApi.getProductPoolProduct(new PageNumEntity(pageNum));
                }
                productNoSet.addAll(productNos);
                //TODO: 记得关闭
            } else {
                String JsonContext = FileUtils.ReadFile(getPath());
                List<Map<String, Object>> listMap = JSON.parseObject(JsonContext, new TypeReference<List<Map<String, Object>>>() {
                });
                for (int i = 0; i < listMap.size(); i++) {
                    String name = listMap.get(i).get("name") + "";
                    if (name.equals(productPool.getName())) {
                        List<Long> productNos = jdProductApi.getProductPoolProduct(new PageNumEntity(pageNum));
                        productNoSet.addAll(productNos);
                    } else {
                        continue;
                    }
                }
            }

        }
        productNosList = new ArrayList<Long>(productNoSet);
        totalNum = productNosList.size();
        executorsPoolAdd(productNosList, totalNum, isThread, poolSize);
    }

    public void executorsPoolAdd(List<Long> productNosList, int totalNum, Boolean isThread, Integer poolSize) {
        if (Lang.isEmpty(poolSize)) {
            poolSize = 50;
        }
        ExecutorService pool = Executors.newFixedThreadPool(poolSize);
        List<String> skus = new ArrayList<>();
        try {
            for (int i = 0; i < totalNum; i++) {
                log.info("=======同步第{}/{}个商品=======", i, totalNum);
                try {
                    if (isThread) {
                        ProductDbInitService.GoodsThread thread = new ProductDbInitService.GoodsThread(productNosList.get(i));
                        pool.execute(thread);
                    } else {//不是多线程的时候，直接更新索引
                        List<String> goodsIds = productTransactionalService.addGoods(Long.valueOf(productNosList.get(i)));
                        productNosList.forEach(sku -> {
                            skus.add(String.valueOf(sku));
                        });

                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } catch (Exception e) {
            log.error("同步京东商品出错", e);
        } finally {
            if (!pool.isShutdown()) {
                pool.shutdown();
            }
        }

        triggerUpdateSearch(skus);

    }

    public CategorysResp getCategorys(CategorysEntity categorysEntity) {
        return jdProductApi.getCategorys(categorysEntity);
    }

    public Map initProductPool(Integer poolSize) {
        Map returnMap = new HashMap();
        List<ProductPoolVO> productPools = jdProductApi.getProductPool();
        for (ProductPoolVO productPool : productPools) {
            String pageNum = productPool.getPage_num();
            String pageName = productPool.getName();
            returnMap.put("poolName", pageName);
            returnMap.put("poolNum", pageNum);
            ProductPool productPoolEntityExist = productPoolRepos.findByPoolNumAndStoreIdAndIsDelete(pageNum, jdId, false);
            ProductPool productPoolEntity = null;
            if (Lang.isEmpty(productPoolEntityExist)) {
                productPoolEntity = new ProductPool(pageNum, pageName, jdId, jdCode);

            } else {
                productPoolEntity = productPoolEntityExist;
            }

            List<Long> productNos = jdProductApi.getProductPoolProductOld(new PageNumEntity(pageNum, 1));
            returnMap.put("productNos", productNos);
            List<ProductPoolSku> productPoolSkus = new ArrayList<>();
            for (int i = 0; i < productNos.size(); i++) {
                String sku = productNos.get(i).toString();
                ProductPoolSku productPoolSku = productPoolSkuRepos.findBySkuAndStoreIdAndIsDelete(sku, jdId, false);
                if (Lang.isEmpty(productPoolSku)) {
                    productPoolSku = new ProductPoolSku(sku, jdId, jdCode);
                    productPoolSkus.add(productPoolSku);
                }
                //   ExecutorService pool = Executors.newFixedThreadPool(poolSize);
                //    ProductDbInitService.ProductPoolThread thread = new ProductDbInitService.ProductPoolThread(productPoolEntity,sku);
                //  pool.execute(thread);
            }

            productPoolEntity.setProductPoolSkus(productPoolSkus);
            productPoolRepos.save(productPoolEntity);
        }
        return returnMap;
    }


    //商品线程
    class GoodsThread extends Thread {
        Long productNo;

        GoodsThread(Long productNo) {
            this.productNo = productNo;
        }

        @Override
        public void run() {
            productTransactionalService.addGoods(productNo);

        }
    }

    public String getPath() {
        String path = this.getClass().getResource("/").getPath();
        path = path.substring(0, path.length() - 15) + "productPool.json";
        return path;
    }


    @Transactional
    public List<String> addGoods(Long productNo) {
        //获取商品基本信息
        ProductDetailVO productDetail = jdProductApi.getProductDetail(new ProductDetailEntity(productNo));
        //获取商品价格信息
        List<PriceVO> prices = jdProductApi.getPrice(new SkuEntity(productNo + ""));
        if (prices == null || prices.size() == 0) {
            throw new RuntimeException("prices：商品价格为空,商品编号:" + productNo);
        }
        PriceVO priceVO = prices.get(0);
        //获取商品全部图片
        Map<Long, List<ProductSkuImageVO>> imageMap = jdProductApi.getProductSkuImage(Arrays.asList(productNo));
        if (imageMap == null || imageMap.size() == 0) {
            throw new RuntimeException("imageMap：商品图片信息为空,商品编号:" + productNo);
        }
        List<ProductSkuImageVO> productSkuImageVOs = imageMap.get(productNo);
        if (productSkuImageVOs == null || productSkuImageVOs.size() == 0) {
            throw new RuntimeException("productSkuImageVOs：商品图片信息为空,商品编号:" + productNo);
        }
        //商品的可售性校验
        ProductCheckResp productCheckResp = jdProductApi.getSkuCheck((Arrays.asList(productNo)));
        Boolean isDelete = false;
        if (!Lang.isEmpty(productCheckResp) && !Lang.isEmpty(productCheckResp.getResult())) {
            for (ProductCheckRepVO productCheckRepVO : productCheckResp.getResult()) {
                if (productCheckRepVO.getSkuId().equals(productNo)) {
                    if (productCheckRepVO.getIsCanVAT() == ProductCheckRepVO.CAN_VAT_NO_SUPPORT || productCheckRepVO.getSaleState() == ProductCheckRepVO.SALE_NO_SUPPORT) {//商品不可售或者不支持开增票，需要将商品不上架处理
                        isDelete = true;
                    }
                }
            }
        }

        //copy商品信息
        Goods goods = null;
        List<String> returnStrs = new ArrayList<>();
        ExistGoodsVo existGoodsVo = isExistGoods(Long.toString(productNo), priceVO, productDetail, isDelete);
        if (!Lang.isEmpty(existGoodsVo)) {
            if (!existGoodsVo.getExistGoods()) {
                goods = new Goods();
                //设置基本信息，价格信息，图片信息
                setBaseInfo(goods, productDetail, priceVO, productSkuImageVOs, isDelete);
                //设置product，productFashion
                goods = setProduct(goods, productDetail, isDelete);
                //保存Goods,级联保存GoodsPicture
                goods = goodsRepos.saveAndFlush(goods);
                returnStrs.add(goods.getId());

            } else {
                if (!Lang.isEmpty(existGoodsVo.getGoodses())) {
                    for (Goods goods1 : existGoodsVo.getGoodses()) {
                        returnStrs.add(goods1.getId());
                    }
                }
            }
        }


        return returnStrs;//goods.getId();
    }


    /**
     * 判断商品是否存在，如果存在，只需要更新价格和商品详情
     *
     * @param skuId
     * @param priceVO
     * @param productDetail
     * @param isDelete
     * @return
     */
    private ExistGoodsVo isExistGoods(String skuId, PriceVO priceVO, ProductDetailVO productDetail, Boolean isDelete) {

        Boolean isExistGoods = false;
        List<Goods> returnList = new ArrayList<>();
        List<Goods> goodsList = goodsRepos.findAll(new Specification() {
            @Override
            public Predicate toPredicate(Root root, CriteriaQuery query, CriteriaBuilder cb) {
                return cb.and(
                        cb.equal(root.get("sku"), skuId),
                        cb.equal(root.get("storeId"), jdId),
                        cb.equal(root.get("code"), skuId)
                );
            }
        });

        if (!Lang.isEmpty(goodsList) && goodsList.size() > 0) {
            isExistGoods = true;
            //更新下架商品
            for (Goods goods : goodsList) {
                goods.setIsDelete(isDelete);
                BigDecimal initPrice = new BigDecimal(0);
                if (!Lang.isEmpty(priceVO)) {
                    //销售价初始化为京东市场价
                    if (!Lang.isEmpty(priceVO.getJdPrice())) {
                        initPrice = priceVO.getJdPrice();
                    }
                    goods.setMarketPrice(initPrice);
                    goods.setSalePrice(initPrice);
                    if (Lang.isEmpty(priceVO.getPrice())) {
                        goods.setCostPrice(initPrice);
                    } else {
                        goods.setCostPrice(priceVO.getPrice());
                    }
                } else {
                    //没有价格，默认为0
                    goods.setMarketPrice(initPrice);
                    goods.setSalePrice(initPrice);
                    goods.setCostPrice(initPrice);
                    goods.setDiscountRate(initPrice);
                }

                if (!Lang.isEmpty(productDetail)) {//更新商品详情
                    goods.setIntroduction(productDetail.getIntroduction());
                }
                returnList.add(goods);
                goodsRepos.saveAndFlush(goods);

            }
        }
        ExistGoodsVo existGoodsVo = new ExistGoodsVo(isExistGoods, returnList);
        return existGoodsVo;
    }

    private void setBaseInfo(Goods goods, ProductDetailVO productDetail, PriceVO priceVO, List<ProductSkuImageVO> productSkuImageVOs, Boolean isDelete) {
        if (!Lang.isEmpty(productDetail)) {
            goods.setName(productDetail.getName());
            goods.setStoreId(jdId);
            //销售价初始化为京东市场价
            BigDecimal initPrice = new BigDecimal(0);
            if (!Lang.isEmpty(priceVO.getJdPrice())) {
                initPrice = priceVO.getJdPrice();
            }
            goods.setMarketPrice(initPrice);
            goods.setSalePrice(initPrice);
            if (Lang.isEmpty(priceVO.getPrice())) {
                goods.setCostPrice(initPrice);
            } else {
                goods.setCostPrice(priceVO.getPrice());
            }
            goods.setBrandName(productDetail.getBrandName());
            goods.setIntroduction(productDetail.getIntroduction());
            goods.setParam(productDetail.getParam());
            goods.setProductArea(productDetail.getProductArea());
            goods.setSaleUnit(productDetail.getSaleUnit());
            goods.setSku(productDetail.getSku() + "");
            goods.setCode(productDetail.getSku() + "");
            goods.setState(productDetail.getState());
            goods.setUpc(productDetail.getUpc());
            goods.setWareQD(productDetail.getWareQD());
            goods.setWeight(productDetail.getWeight());
            goods.setPushUpDate(new Date());
            if (isDelete) {
                goods.setIsDelete(isDelete);
            }
            List<GoodsPicture> goodsPictures = new ArrayList<GoodsPicture>();
            if (productSkuImageVOs != null) {
                for (ProductSkuImageVO imageVO : productSkuImageVOs) {
                    GoodsPicture goodsPicture = new GoodsPicture();
                    goodsPicture.setPicturePath("http://img20.360buyimg.com/vc/" + imageVO.getPath());
                    goodsPicture.setBigPicturePath("http://img20.360buyimg.com/vc/" + imageVO.getPath());
                    if (imageVO.getIsPrimary() != null && imageVO.getIsPrimary().equals(1)) {
                        goodsPicture.setShowIndex(0);
                    } else {
                        goodsPicture.setShowIndex(Integer.parseInt(imageVO.getOrderSort()));
                    }
                    //保存关联
                    goodsPicture.setGoods(goods);
                    if (isDelete) {
                        goodsPicture.setIsDelete(isDelete);
                    }
                    goodsPictures.add(goodsPicture);
                }
                goods.setGoodsPictures(goodsPictures);
            }

        }
    }

    private ProductBrand setBrand(String brandName) {
        if (Lang.isEmpty(brandName)) {//如果品牌名称为空，需要将品牌数据设置默认
            brandName = "没有品牌的商品" + jdCode;
        }
        ProductBrand productBrand = productBrandRepos.findByNameAndAndSourceCodeAndIsDelete(brandName, jdCode, false);

        if (Lang.isEmpty(productBrand)) {
            productBrand = new ProductBrand();
            String websitesUrl = "www.jd.com";//官网地址
            String BRAND_NAME = brandName;
            productBrand.setShowIndex(1);
            productBrand.setDescription(BRAND_NAME);
            productBrand.setName(BRAND_NAME);
            productBrand.setSimpleName(BRAND_NAME);
            productBrand.setWebsitesUrl(websitesUrl);
            productBrand.setSourceCode(jdCode);
            productBrandRepos.save(productBrand);
        }
        return productBrand;

    }

    @Transactional
    public Goods setProduct(Goods goods, ProductDetailVO productDetail, Boolean isDelete) {
        if (!Lang.isEmpty(productDetail)) {
            //product
            Product product = new Product();
            String productName = goods.getName();
            //product.setGoodses(Arrays.asList(goods));
            product.setCostPrice(goods.getCostPrice());
            product.setMarketPrice(goods.getMarketPrice());
            product.setSalePrice(goods.getSalePrice());
            product.setProductName(productName);
            product.setTitle(productName);
            product.setCode(goods.getSku());
            product.setStoreId(jdId);
            //productFashion
            ProductFashion productFashion = new ProductFashion();
            productFashion.setMarketPrice(goods.getMarketPrice());
            productFashion.setSalePrice(goods.getSalePrice());
            productFashion.setCostPrice(goods.getCostPrice());
            productFashion.setProductCode(goods.getSku());
            productFashion.setStockCount(goods.getStockCount().intValue());
            productFashion.setLackRemind(0);//庫存預警 默認10 2017-01-11: 暂不控制库存预警，默认值设为0
            productFashion.setOnSale(true);//是否在销
            productFashion.setFashionPic(goods.getGoodsPictures().get(0).getPicturePath());//圖片

            // 保存productFashionPicture
            ProductFashionPicture fashionPic = null;
            boolean hasDefault = false;
            List<ProductFashionPicture> productFashionPictures = new ArrayList<>();
            for (GoodsPicture gp : goods.getGoodsPictures()) {
                fashionPic = new ProductFashionPicture();
                fashionPic.setProductFashion(productFashion);
                fashionPic.setAppPicturePath(gp.getAppPicturePath());
                fashionPic.setBigPicturePath(gp.getBigPicturePath());
                fashionPic.setPicturePath(gp.getPicturePath());
                fashionPic.setShowIndex(gp.getShowIndex());
                if (!hasDefault && (gp.getShowIndex() == 0 || goods.getGoodsPictures().size() == 1)) {
                    fashionPic.setDefaultFlag(true);
                    hasDefault = true;
                }
                productFashionPictures.add(fashionPic);
            }
            productFashion.setProductFashionPictures(productFashionPictures);

            /**
             * 写死数据
             */
            productFashion.setFieldName("颜色");
            productFashion.setFieldType("1");
            productFashion.setValue("黑色");
            productFashion.setValueName("黑色");
            if (isDelete) {
                productFashion.setIsDelete(isDelete);
            }
            /**
             * 写死数据
             */
            //设置双向关联
            productFashion.setFashionTitle(productName);
            productFashion.setProduct(product);

            product.setProductFashions(Arrays.asList(productFashion));
            //productCategory
            try {
                String category = productDetail.getCategory();
                Integer code = Integer.parseInt(category.split(";")[2]);
                //设置品牌信息
                ProductBrand productBrand = setBrand(productDetail.getBrandName());
                ProductCategory productCategory = productCategoryRepos.findTopByCodeAndSourceCode(code, jdCode);
                if (Lang.isEmpty(productCategory)) {
                    code = Integer.parseInt(category.split(";")[1]);
                    productCategory = productCategoryRepos.findTopByCodeAndSourceCode(code, jdCode);
                    if (Lang.isEmpty(productCategory)) {
                        code = Integer.parseInt(category.split(";")[0]);
                        productCategory = productCategoryRepos.findTopByCodeAndSourceCode(code, jdCode);
                        if (Lang.isEmpty(productCategory)) {
                            throw new RuntimeException("商品分类关联异常，属于问题商品:" + productDetail.getSku());
                        }
                    }
                }
                product.setProductCategory(productCategory);

                if (!Lang.isEmpty(productBrand) && !Lang.isEmpty(productCategory)) {

                    Integer count = (Integer) jdbcTemplate.queryForObject(countSql, new Object[]{productBrand.getId(), productCategory.getId()}, Integer.class);
                    if (Lang.isEmpty(count) || count == 0) {
                        List<ProductBrand> productBrands = new ArrayList<>();
                        productBrands.add(productBrand);
                        productCategory.setProductBrands(productBrands);
                        productCategoryRepos.save(productCategory);
                    }
                }

            } catch (Exception e) {
            }
            if (isDelete) {
                product.setIsDelete(isDelete);
            }
            product = productRepos.save(product);
            goods.setProduct(product);
        }
//        goods = goodsRepos.saveAndFlush(goods);
        return goods;
    }


    private static final String countSql = "SELECT count(*) FROM product_category_brand  where brand_id = ?  and category_id =? ";


    public void batchDelete() {
        goodsRepos.deleteAll();
        productRepos.deleteAll();
    }

    /**
     * 同步完成，触发goods_config 和索引
     *
     * @param skus
     */
    public void triggerUpdateSearch(List<String> skus) {
        /**Akers 2017-09-15修改： 同步商品时同步新增GoodsConfig START */
        // 异步触发GoodsConfig生成
        String storeCode = "jd";
//        goodsConfigApi.addOrUpdateMallGoods(skus, storeCode);
        /**Akers 2017-09-15修改： 同步商品时同步新增GoodsConfig END */
    }

    class ProductPoolThread extends Thread {
        String sku;
        ProductPool productPoolEntity;

        ProductPoolThread(ProductPool productPoolEntity, String sku) {
            this.productPoolEntity = productPoolEntity;
            this.sku = sku;
        }

        @Override
        public void run() {
            addProductPool(productPoolEntity, sku);
        }
    }

    private void addProductPool(ProductPool productPoolEntity, String sku) {
        ProductPoolSku productPoolSku = new ProductPoolSku(sku, jdId, jdCode);
        productPoolEntity.setProductPoolSkus(Arrays.asList(productPoolSku));
        productPoolRepos.save(productPoolEntity);
        // productPoolSkuRepos.save(productPoolSku);
    }

    public Map addProdBySkus(Map resMap, String skuids) {
        resMap = ResponseMapUtils.success(null);
        Map rsData = new HashMap<>();
        List<Map> errorDetail = new ArrayList<>();
        if (!Lang.isEmpty(skuids)) {
            List<String> skuList = new ArrayList<>();
            if (skuids.contains(",")) {
                String[] skuArr = skuids.split(",");
                for (String s : skuArr) {
                    if (!Lang.isEmpty(s)) {
                        skuList.add(s.trim());
                    }
                }
            } else {
                skuList.add(skuids.trim());
            }

            int sucCount = 0;
            int errorCount = 0;
            int totalCount = skuList.size();
            String goodsId = null;
            List<String> goodsIds = new ArrayList<>();
            for (String sku : skuList) {
                try {
                    if (!Lang.isEmpty(productTransactionalService.addGoods(Long.parseLong(sku)))) {
                        goodsIds.add(goodsId);
                    }
                    sucCount++;
                } catch (Exception e) {
                    errorCount++;
                    errorDetail.add(new HashMap() {{
                        put("sku", sku);
                        put("message", e.getLocalizedMessage());
                    }});
                    e.printStackTrace();
                }
            }

            /**Akers 2017-09-15修改： 同步商品时同步新增GoodsConfig START */
            // 异步触发GoodsConfig生成
            String storeCode = "jd";
//            goodsConfigApi.addOrUpdateMallGoods(skuList, storeCode);
            /**Akers 2017-09-15修改： 同步商品时同步新增GoodsConfig END */
            rsData.put("suc", sucCount);
            rsData.put("error", errorCount);
            rsData.put("total", totalCount);
            rsData.put("errorDetail", errorDetail);
            resMap.put("data", rsData);
        } else {
            resMap = ResponseMapUtils.error("skuids必传，多个sku用','隔开", "2");
        }

        return resMap;
    }

    @Autowired
    ProductTransactionalService productTransactionalService;

}
