package jd.service.service;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.GoodsProductCatgoryApi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import utils.Lang;
import utils.log.Log;
import utils.log.Logs;

import java.util.ArrayList;
import java.util.List;

@Component
public class ProductTransactionalService {
    private final static Log log = Logs.getLog(ProductTransactionalService.class.getName());
    @Autowired
    ProductDbInitService productDbInitService;
    @MotanReferer
    GoodsProductCatgoryApi goodsProductCatgoryApi;

    public List<String> addGoods(Long sku) {
        List<String> returnStrs =new ArrayList<>();
        if (!Lang.isEmpty(sku)) {
            returnStrs= productDbInitService.addGoods(sku);
            // 2018-03-09 京东同步商品成功,进行同类产品处理(赋予规格数据)
            if (!Lang.isEmpty(returnStrs)) {
                try {
                    goodsProductCatgoryApi.categorize(sku.toString());
                } catch (Exception e) {
                    log.error("同类产品处理失败, SKU={}", sku, e);
                }
            }
        }
        return returnStrs;
    }


}
