package jd.service.service;

import jd.api.vo.product.StockStateDTO;
import jd.model.stock.StockState;
import jd.model.stock.StockStateDao;
import ma.glasnost.orika.MapperFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class StockStateService {

    @Autowired
    MapperFacade mapperFacade;

    @Autowired
    StockStateDao stockStateDao;

    public Page<StockStateDTO> findAll(Pageable pageable) {
        Page<StockState> stockStatePage = stockStateDao.findAll(pageable);
        List<StockStateDTO> stockStateDTOS = mapperFacade.mapAsList(stockStatePage.getContent(), StockStateDTO.class);
        Page<StockStateDTO> stateDTOPage = new PageImpl<>(stockStateDTOS, pageable, stockStatePage.getTotalElements());
        return stateDTOPage;
    }

    public Long count() {
        return stockStateDao.count();
    }
}
