package jd.service.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import jd.api.request.address.AddressEntity;
import jd.api.request.aftersale.*;
import jd.api.request.order.*;
import jd.api.request.product.*;
import jd.api.response.aftersale.*;
import jd.api.response.order.*;
import jd.api.response.product.CategoryResp;
import jd.api.response.product.CategorysResp;
import jd.api.response.product.ProductCheckResp;
import jd.api.service.address.JdAddressApi;
import jd.api.service.aftersale.JdAftersaleApi;
import jd.api.service.order.JdOrderApi;
import jd.api.service.product.JdProductApi;
import jd.api.vo.order.OrderFreightVO;
import jd.api.vo.product.*;
import jd.model.stock.StockState;
import jd.model.stock.StockStateDao;
import jd.service.service.CategoryDbService;
import jd.service.service.ProductDbInitService;
import jd.service.task.JdOrderConstant;
import jd.service.task.OrderPriceSnap;
import org.apache.poi.hssf.usermodel.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import sinomall.global.common.vo.outsideapi.OrderCancelOrderResp;
import utils.Lang;
import utils.file.FileUtils;
import utils.log.Log;
import utils.log.Logs;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.math.BigDecimal;
import java.util.*;

/**
 * Created by xujingfeng on 2017/3/6.
 */
@RestController
//@Controller
@RequestMapping("api")
public class JdApiController {
    private final static Log log = Logs.getLog(JdApiController.class.getName());


    @Autowired
    JdProductApi jdProductApi;

    @Autowired
    CategoryDbService categoryDbService;

    @Autowired
    JdAftersaleApi jdAftersaleApi;

    @RequestMapping("/getProductPool")
    public List<ProductPoolVO> getProductPool() {

        List<ProductPoolVO> productPool = jdProductApi.getProductPool();
        log.info("手动调用{}", productPool);
        return productPool;
    }

    @RequestMapping("/getProductPoolProduct")
    public List<Long> getProductPoolProduct(PageNumEntity pageNumEntity) {
        log.info("手动调用{}", pageNumEntity);
        List<Long> productPoolProduct = jdProductApi.getProductPoolProduct(pageNumEntity);
        return productPoolProduct;
    }

    @RequestMapping("/totalProduct")
    @ResponseBody
    public Map getProductPoolProduct(@RequestParam Integer pageNo, HttpServletResponse response, @RequestParam Boolean isGetPools, Integer separateSize) {
        Integer totalPools = 0;
        Integer totalProductNum = 0;
        Map returnMap = new HashMap();
        log.info("手动调用{}", pageNo);
        //获取所有商品池
        List<ProductPoolVO> productPools = jdProductApi.getProductPool();
        if (!Lang.isEmpty(productPools)) {
            List<String> productPoolsNames = new ArrayList<>();
            // totalPools=productPools.size();
            List<Long> productNoTotal = new ArrayList<>();
            Map poolsProductNo = new HashMap();

            Integer poolsSize = 0;
            List<Map> writeTextList = new ArrayList<>();
            for (ProductPoolVO productPool : productPools) {
                log.info(productPool.toString());
                productPoolsNames.add(productPool.getName());

                if (isGetPools) {
                    poolsSize++;
                    Map returnPoolsMap = new HashMap();
                    returnPoolsMap.put("poolsName", productPool.getName());
                    returnPoolsMap.put("pageNum", productPool.getPage_num());
                    writeTextList.add(returnPoolsMap);
                    if (Lang.isEmpty(separateSize)) {
                        separateSize = 50;
                    }
                    if (poolsSize % separateSize == 0) {
                        FileUtils.textToFile("F://productPools//" + "商品池" + poolsSize + ".txt", JSON.toJSONString(writeTextList));
                    }
                } else {
                    List<Long> productNos = jdProductApi.getProductPoolProductOld(new PageNumEntity(productPool.getPage_num(), pageNo));
                    for (Long productNo : productNos) {
                        totalProductNum++;
                        log.info(productNo.toString());
                        productNoTotal.add(productNo);
                    }

                    poolsProductNo.put(productPool.getName(), productPool.getName());
                    poolsProductNo.put(productPool.getName() + "SKU", productNoTotal);

                }
            }

            log.info("totalPools" + totalPools);
            log.info("totalProductNum" + totalProductNum);
            List newList = new ArrayList(new HashSet(productNoTotal));
            log.info("productNoTotal" + newList.size());
            returnMap.put("totalPools", totalPools);
            returnMap.put("productPoolsNames", productPoolsNames);
            returnMap.put("totalProductNum", totalProductNum);
            returnMap.put("productNoTotal", productNoTotal);
            returnMap.put("poolsProductNo", poolsProductNo);
        }


        return returnMap;

    }

    @RequestMapping("/downloadProductPools")
    @ResponseBody
    public Map downloadProductPools(@RequestParam Integer pageNo, HttpServletResponse response, @RequestParam String fileName) {
        HSSFWorkbook wb = new HSSFWorkbook();

        String readStr = FileUtils.ReadFile("F://productPools//" + fileName + ".txt");
        List<Map<String, Object>> listMap = JSON.parseObject(readStr, new TypeReference<List<Map<String, Object>>>() {
        });
        Integer totalPools = 0;
        for (int i = 0; i < listMap.size(); i++) {

            String pageNum = (String) listMap.get(i).get("pageNum");
            String name = (String) listMap.get(i).get("poolsName");
            List<Map> writeExcelList = new ArrayList<>();
            List<Long> productNos = jdProductApi.getProductPoolProductOld(new PageNumEntity(pageNum, pageNo));
            for (Long productNo : productNos) {
                log.info(productNo.toString());
                ProductDetailVO productDetailVO = jdProductApi.getProductDetail(new ProductDetailEntity(productNo));
                Map writeExcelMap = new HashMap();
                writeExcelMap.put("poolsName", name);
                writeExcelMap.put("pageNum", pageNum);
                writeExcelMap.put("sku", productNo.toString());
                //  writeExcelMap.put("name", null);
                if (!Lang.isEmpty(productDetailVO)) {
                    writeExcelMap.put("name", productDetailVO.getName());
                }
                writeExcelList.add(writeExcelMap);
            }

            // 在webbook中添加一个sheet,对应Excel文件中的sheet
            HSSFSheet sheet = wb.createSheet();
            wb.setSheetName(totalPools, name.replace("/", "-") + totalPools);
            setContentColumnWidth(sheet);
            HSSFCellStyle cellStyle = setContentCellStyle(wb);
            createCellHead(sheet.createRow(0), cellStyle, sheet.createRow(0).createCell(0));
            createCellContent(writeExcelList, cellStyle, sheet);
            totalPools++;
        }
        // FileUtils.textToFile("e://ss.txt", JSONObject.toJSONString(returnMap));
        // 将文件存到指定位置
        try {
            response.setHeader("Content-disposition", "attachment; filename=" + fileName + ".xls");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream out = response.getOutputStream();
            wb.write(out);
            out.flush();
            out.close();
        } catch (Exception e) {
            e.printStackTrace();
            log.error("Error", e);
        }
        return null;
    }

    /**
     * 1155583,1128461,1128460,1155581,1155582,1128463,947461,644123,822899,316916, 617635, 907719, 822897, 375228, 375231, 375229, 295682, 295678, 316917, 650000, 616370, 1106007, 1106010, 1261168, 1261174, 1278110, 1261173,615211,679537,546048,899573,1312102,1312090,1251201,1251256,1106009,1251315,375219,1106015, 1174556, 1256147, 1174553, 1174554, 649982, 1269200, 1230201, 295679, 295677, 857131, 1261206, 313245, 313243, 1278087, 934770, 1221611, 617636, 934768, 617638, 1179556, 1242654, 934775, 1268129, 934772, 1268130, 1221613, 1160162, 1160163, 1221622, 1221621, 932637, 932636, 947447, 1106017, 1106016, 1261176, 316921, 316920, 1251251, 1262628, 1261172, 1173218, 822891, 1261165, 1252758, 1099994, 615222, 1262452, 1155584, 1262457, 1173213, 1173215, 1264632, 1251203, 1277632, 295683, 295680, 295681, 1168363, 1128462, 1251209, 3875976, 3478118, 3446021, 3446031, 3784998, 3309077, 3785002, 3479329, 3739210, 3354559, 2728439, 3784978, 3472485, 3784980, 3354505, 3478096, 3784974, 3478110, 2983873, 3266893, 3440171, 3734992, 3355751, 3266881, 3735002, 3440167, 3355771, 3786270, 3355769, 3734976, 3696780, 3617392, 3354577, 3291523, 3735018, 3354587, 3383108, 3902914, 3038261, 3674138, 3480423, 2950687, 3149969, 3291519, 3696764, 3870170, 3721508, 2983705, 3870172, 3786220, 3038253, 3266977, 3870190, 3207291, 3291745, 3674160, 3480397, 3440105, 2757466, 3361790, 3472529, 3911382, 3902888, 3888098, 3720868, 3902896, 3304931, 3870136, 3207479, 3742682, 3472563, 2877645, 2861650, 2898401, 2975351, 2975359, 2975353, 3140510, 3140512, 3140338, 2972676, 2312702,
     * 100012,100041,100077,100109,100111,100142,100143,100284,100293,100297, 100300, 100303, 100306, 100307, 100332, 100376, 100391, 100401,
     */
    @RequestMapping("/getProductDetail")
    public ProductDetailVO getProductPool(ProductDetailEntity productDetailEntity) {
        ProductDetailVO productDetailVO = jdProductApi.getProductDetail(productDetailEntity);
        return productDetailVO;
    }


    @RequestMapping("/getProductDetailBySku")
    @ResponseBody
    public Map getProductPool(@RequestParam String sku) {
        ProductDetailEntity productDetailEntity = new ProductDetailEntity();
        productDetailEntity.setSku(Long.valueOf(sku));
        ProductDetailVO productDetailVO = jdProductApi.getProductDetail(productDetailEntity);
        Map returnMap = new HashMap();
        returnMap.put("productDetailVO", productDetailVO);
        return returnMap;
    }

    @RequestMapping("/getProductState")
    public List<ProductStateVO> getProductState(Long[] skus) {
        List<ProductStateVO> list = jdProductApi.getProductState(Arrays.asList(skus));
        return list;
    }

    @RequestMapping("/getProductSkuImage")
    public Map<Long, List<ProductSkuImageVO>> getProductSkuImage(Long[] skus) {
        Map<Long, List<ProductSkuImageVO>> map = jdProductApi.getProductSkuImage((Arrays.asList(skus)));
        return map;
    }

    @RequestMapping("/getProductCommentSummarys")
    public List<ProductCommentSummarysVO> getProductCommentSummarys(Long[] skus) {
        List<ProductCommentSummarysVO> list = jdProductApi.getProductCommentSummarys((Arrays.asList(skus)));
        return list;
    }

    @RequestMapping("/getProductLimit")
    public List<SkuIdsAndAreaVO> getProductLimit(SkuIdsAndAreaEntity skuIdsAndAreaEntity) {
        List<SkuIdsAndAreaVO> limit = jdProductApi.getProductLimit(skuIdsAndAreaEntity);
        return limit;
    }

    @RequestMapping("/getProductIsCod")
    public Boolean getProductIsCod(SkuIdsAndAreaEntity skuIdsAndAreaEntity) {
        Boolean b = jdProductApi.getProductIsCod(skuIdsAndAreaEntity);
        return b;
    }

    @RequestMapping("/getSkuCheck")
    public ProductCheckResp getSkuCheck(Long[] skus) {
        ProductCheckResp productCheckResp = jdProductApi.getSkuCheck((Arrays.asList(skus)));
        return productCheckResp;
    }

    @RequestMapping("/getPrice")
    public List<PriceVO> getPrice(SkuEntity skuEntity) {
        List<PriceVO> list = jdProductApi.getPrice(skuEntity);
        return list;
    }

    @RequestMapping("/queryOrderTrack")
    @ResponseBody
    public Map queryOrderTrack(@RequestParam Long jdOrderId) {
        JdOrderIdEntity jdOrderIdEntity = new JdOrderIdEntity();
        jdOrderIdEntity.setJdOrderId(jdOrderId);

        OrderTrackResp orderTrackResp = jdOrderApi.queryOrderTrack(jdOrderIdEntity);
        Map returnMap = new HashMap();
        returnMap.put("orderTrackResp", orderTrackResp);
        return returnMap;
    }


    @RequestMapping("/queryOrderTracks")
    @ResponseBody
    public Map queryOrderTracks(@RequestParam Long[] jdOrderIds) {
        Map returnMap = new HashMap();
        for (int i = 0; i < jdOrderIds.length; i++) {
            Long jdOrderId = jdOrderIds[i];
            JdOrderIdEntity jdOrderIdEntity = new JdOrderIdEntity();
            jdOrderIdEntity.setJdOrderId(jdOrderId);

            OrderTrackResp orderTrackResp = jdOrderApi.queryOrderTrack(jdOrderIdEntity);

            returnMap.put(jdOrderId, orderTrackResp);
        }
        return returnMap;
    }

    @RequestMapping("/getPriceSkus")
    @ResponseBody
    public Map getPrice(@RequestParam(name = "skus[]", required = true) String[] skus) {
        log.info("手动调用{}", skus);
        Map returnMap = new HashMap();
        for (int i = 0; i < skus.length; i++) {
            SkuEntity skuEntity = new SkuEntity();
            skuEntity.setSku(skus[i]);
            List<PriceVO> list = jdProductApi.getPrice(skuEntity);
            returnMap.put(skus[i], list);
        }

        return returnMap;
    }


    @RequestMapping("getStockForOrder/{sku}/{number}/{area}")
    @ResponseBody
    public List<StockNewResultVo> getStockForOrder(@PathVariable Long sku,
                                                   @PathVariable Integer number,
                                                   @PathVariable String area) {
        StockForOrderEntity stockForOrderEntity = new StockForOrderEntity();
        StockVO stockVO = new StockVO();
        stockVO.setNum(number);
        stockVO.setSkuId(sku);
        stockForOrderEntity.setArea(area);
        stockForOrderEntity.setSkuNums(Arrays.asList(stockVO));
        List<StockNewResultVo> list = jdProductApi.getStockForOrder(stockForOrderEntity);
        return list;
    }


    @RequestMapping("batchGetStock")
    @ResponseBody
    public String batchGetStock() {
        jdProductApi.refreshCtStock();
        return "success";
    }

    @Autowired
    StockStateDao stockStateDao;

    @Value("${stock.inputPath:C:\\Users\\25057\\Desktop\\ct-stock.txt}")
    String skuIdsInput;

    @RequestMapping("initBatchGetStock")
    @ResponseBody
    public String initBatchGetStock() throws Exception {
        File in = new File(skuIdsInput);
        BufferedReader reader = new BufferedReader(new FileReader(in));
        String line = "";
        List<StockState> stockStates = new ArrayList<>();
        while ((line = reader.readLine()) != null) {
            String[] lines = line.split(",");
            StockState stockState = new StockState();
            stockState.setSkuId(Long.parseLong(lines[0]));
            stockState.setAreaId("1_2802_2821_0");
            stockState.setRemainNum(Integer.parseInt(lines[1]));
            stockState.setStockStateDesc(lines[2]);
            stockState.setStockStateId(Integer.parseInt(lines[3]));
            stockStates.add(stockState);
            if (stockStates.size() > 1000) {
                stockStateDao.save(stockStates);
                stockStates.clear();
            }
        }
        if (stockStates.size() > 0) {
            stockStateDao.save(stockStates);
        }
        reader.close();
        return "success";
    }

    @RequestMapping("/getMessage")
    public List<MessageGetVO> getMessage(MessageTypeEntity messageTypeEntity) {
        List<MessageGetVO> list = jdProductApi.getMessage(messageTypeEntity);
        return list;
    }


    @RequestMapping("/getMessageByType")
    public List<MessageGetVO> getMessageByType(String type) {
        for(int i=0;i<100;i++) {
            log.info("输出info  ");
            log.debug("输出debug+skkkw嗡嗡嗡kw");
            log.error("输出error  嗡嗡嗡我");
        }
        MessageTypeEntity messageTypeEntity = new MessageTypeEntity(type);
        List<MessageGetVO> list = jdProductApi.getMessage(messageTypeEntity);
        return list;
    }

    @RequestMapping("/delMessage")
    public Boolean delMessage(MessageDelEntity messageDelEntity) {
        Boolean b = jdProductApi.delMessage(messageDelEntity);
        return b;
    }

    @RequestMapping("/getCategory")
    public CategoryResp getCategory(CategoryEntity categoryEntity) {
        CategoryResp categoryResp = jdProductApi.getCategory(categoryEntity);
        return categoryResp;
    }

    @RequestMapping("/getCategorys")
    public CategorysResp getCategorys(CategorysEntity categorysEntity) {
        CategorysResp categorysResp = jdProductApi.getCategorys(categorysEntity);
        return categorysResp;
    }

    @Autowired
    JdAddressApi jdAddressApi;

    @RequestMapping("/getAddress")
    @ResponseBody
    public Map<String, Integer> getAddress(Integer parent, Integer lv) {
        Map<String, Integer> address = null;
        AddressEntity addressEntity = new AddressEntity();
        addressEntity.setId(parent);
        switch (lv) {
            case 1:
                address = jdAddressApi.getLevelOneAddress();
                break;
            case 2:
                address = jdAddressApi.getLevelTwoAddress(addressEntity);
                break;
            case 3:
                address = jdAddressApi.getLevelThreeAddress(addressEntity);
                break;
            case 4:
                address = jdAddressApi.getLevelFourAddress(addressEntity);
                break;
        }
        return address;
    }


    @Autowired
    JdOrderApi jdOrderApi;

    @RequestMapping("/placeOrder")
    public OrderUniteSubmitResp placeOrder(@RequestParam Long skuId, @RequestParam Double price, @RequestParam String thirdOrderNo) {
        log.info("手动调用{}", skuId);
        OrderEntity orderEntity = new OrderEntity();
        orderEntity.setThirdOrder(thirdOrderNo);//第三方订单号
        SkuIdAndNumEntity skuIdAndNumEntity = new SkuIdAndNumEntity(skuId, 4);
        orderEntity.setSku(Arrays.asList(skuIdAndNumEntity));//商品列表
        orderEntity.setName("朱婧玮");//下单人姓名
        orderEntity.setProvince(2);//省
        orderEntity.setCity(2830);//市
        orderEntity.setCounty(51803);//乡
        orderEntity.setTown(0);//镇
        orderEntity.setAddress("民生路1399号太平人寿大厦1610");//详细地址
        orderEntity.setMobile("15618967956");//手机号码
        orderEntity.setEmail(JdOrderConstant.email);//邮箱 Y-
        orderEntity.setInvoiceState(JdOrderConstant.invoiceState);
        orderEntity.setInvoiceType(JdOrderConstant.invoiceType);
        orderEntity.setSelectedInvoiceTitle(JdOrderConstant.selectedInvoiceTitle);
        orderEntity.setInvoiceName(JdOrderConstant.invoiceName);
        orderEntity.setInvoiceContent(JdOrderConstant.invoiceContent);
        orderEntity.setPaymentType(JdOrderConstant.paymentType);
        orderEntity.setIsUseBalance(JdOrderConstant.isUseBalance);
        orderEntity.setSubmitState(JdOrderConstant.submitState);
        orderEntity.setDoOrderPriceMode(JdOrderConstant.doOrderPriceMode);
        orderEntity.setOrderPriceSnap(JSON.toJSONString(Arrays.asList(new OrderPriceSnap(BigDecimal.valueOf(price), skuId))));
        OrderUniteSubmitResp orderUniteSubmitResp = jdOrderApi.placeOrder(orderEntity);
        return orderUniteSubmitResp;
    }

    //52737567815,
    //52923319943 2017/4/7 魏育成
    @RequestMapping("/confirmOrder")
    public OccupyStockResp confirmOrder(Long jdOrderId) {
        log.info("手动调用jdOrderId{}", jdOrderId);
        JdOrderIdEntity jdOrderIdEntity = new JdOrderIdEntity();
        jdOrderIdEntity.setJdOrderId(jdOrderId);
        OccupyStockResp occupyStockResp = jdOrderApi.confirmOccupyStock(jdOrderIdEntity);
        return occupyStockResp;
    }

    @RequestMapping("/confirmOrders")
    public Map confirmOrders(Long[] jdOrderIds) {
        Map returnMap = new HashMap();
        log.info("手动调用jdOrderId{}", jdOrderIds);
        for (int i = 0; i < jdOrderIds.length; i++) {
            Long jdOrderId = jdOrderIds[i];
            JdOrderIdEntity jdOrderIdEntity = new JdOrderIdEntity();
            jdOrderIdEntity.setJdOrderId(jdOrderId);
            OccupyStockResp occupyStockResp = jdOrderApi.confirmOccupyStock(jdOrderIdEntity);
            returnMap.put(jdOrderId, occupyStockResp);
        }
        return returnMap;
    }

    @RequestMapping("/cancelOrder")
    public OrderCancelOrderResp cancelOrder(JdOrderIdEntity jdOrderIdEntity) {
        log.info("手动调用jdOrderIdEntity{}", jdOrderIdEntity);
        OrderCancelOrderResp orderCancelOrderResp = jdOrderApi.cancelOrder(jdOrderIdEntity);
        return orderCancelOrderResp;
    }

    @RequestMapping("/batchCancelOrder")
    public Map batchCancelOrder(@RequestParam(name = "orderNos[]", required = true) Long[] orderNos) {
        log.info("手动调用orderNos{}", orderNos);
        Map returnMap = new HashMap();

        for (int i = 0; i < orderNos.length; i++) {
            JdOrderIdEntity jdOrderIdEntity = new JdOrderIdEntity();
            jdOrderIdEntity.setJdOrderId(orderNos[i]);
            OrderCancelOrderResp orderCancelOrderResp = jdOrderApi.cancelOrder(jdOrderIdEntity);
            log.info("orderCancelOrderResp{}", orderCancelOrderResp);

            returnMap.put(orderNos[i], orderCancelOrderResp);
        }

        return returnMap;


    }


    @RequestMapping("/queryOrderBySkus")
    public Map queryOrder(@RequestParam(name = "skus[]", required = true) Long[] skus) {
        Map returnMap = new HashMap();
        List<Long> statOne = new ArrayList();
        List<Long> statZero = new ArrayList();
        for (int i = 0; i < skus.length; i++) {
            JdOrderIdEntity jdOrderIdEntity = new JdOrderIdEntity();
            jdOrderIdEntity.setJdOrderId(skus[i]);
            Map<String, Object> orderMap = jdOrderApi.queryOrder(jdOrderIdEntity);
            if (orderMap.get("submitState").equals(0)) {
                statZero.add(skus[i]);
            } else {
                statOne.add(skus[i]);
            }
            returnMap.put(skus[i], orderMap);
        }
        returnMap.put("0", statZero);
        returnMap.put("1", statOne);
        return returnMap;
    }

    /*52737567815*/
    @RequestMapping("/queryOrder")
    public Map queryOrder(JdOrderIdEntity jdOrderIdEntity) {
        Map<String, Object> orderMap = jdOrderApi.queryOrder(jdOrderIdEntity);
        return orderMap;
    }

    @RequestMapping("/queryOrderByThirdOrder")
    public OrderRevResp queryOrderByThirdOrder(ThirdOrder thirdOrder) {
        OrderRevResp orderRevResp = jdOrderApi.queryOrderByThirdOrder(thirdOrder);
        return orderRevResp;
    }


    @RequestMapping("/queryFreight")
    public OrderFreightVO queryOrderByThirdOrder() {
        OrderFreightEntity orderFreightEntity = new OrderFreightEntity();
        SkuIdAndNumEntity skuIdAndNumEntity = new SkuIdAndNumEntity(100143l, 1);
        orderFreightEntity.setProvince(2);
        orderFreightEntity.setCity(2830);
        orderFreightEntity.setCounty(51803);
        orderFreightEntity.setTown(0);
        orderFreightEntity.setPaymentType(4);
        orderFreightEntity.setSku(Arrays.asList(skuIdAndNumEntity));//商品列表
        OrderFreightVO orderFreightVO = jdOrderApi.queryFreight(orderFreightEntity).getResult();
        return orderFreightVO;
    }

    @RequestMapping("/getBalance")
    public Map getBalance(Integer payType) {
        OrderBalanceEntity orderBalanceEntity = new OrderBalanceEntity(payType);
        Map returnMap = jdOrderApi.getBalance(orderBalanceEntity);

        return returnMap;
    }

    @RequestMapping("/resetProdCategory")
    @Transactional
    public Map resetProdCategory(String skus) {
        String[] skuidsArray = skus.split(",");
        return categoryDbService.resetProdCategory(Arrays.asList(skuidsArray));
    }

    @RequestMapping("/resetAllProdCategory")
    public Map resetAllProdCategory() {
        return categoryDbService.restAllProdCateGory();
    }

    /**
     * 获取可用数量
     */
    @RequestMapping("/getAvailableNumber")
    public AvailableNumberCompResp getAvailableNumber(OrderSkuEntity orderSkuEntity) {
        return jdAftersaleApi.getAvailableNumber(orderSkuEntity);
    }

    /**
     * 根据订单号、商品编号查询支持的服务类型
     */
    @RequestMapping("/getCustomerExpect")
    public CustomerExpectCompResp getCustomerExpect(OrderSkuEntity orderSkuEntity) {
        return jdAftersaleApi.getCustomerExpect(orderSkuEntity);
    }

    /**
     * 根据订单号、商品编号查询支持的商品返回京东方式
     */
    @RequestMapping("/getWareReturnJd")
    public WareReturnJdCompResp getWareReturnJd(OrderSkuEntity orderSkuEntity) {
        return jdAftersaleApi.getWareReturnJd(orderSkuEntity);
    }

    @RequestMapping("/createServiceTicket")
    public AfsApplyResp createServiceTicket(Long jdOrderId, Long skuId, Integer skuNum) {
        AfsApplyEntity afsApplyEntity = new AfsApplyEntity();
        afsApplyEntity.setJdOrderId(jdOrderId);
        afsApplyEntity.setCustomerExpect(10);
        afsApplyEntity.setQuestionDesc("测试退货功能");
        afsApplyEntity.setIsNeedDetectionReport(false);
        //客户信息实体
        AfterSaleCustomerDto asCustomerDto = new AfterSaleCustomerDto();
//        asCustomerDto.setCustomerContactName("徐靖峰");
        asCustomerDto.setCustomerContactName("朱婧玮");
//        asCustomerDto.setCustomerMobilePhone("17011963281");
        asCustomerDto.setCustomerMobilePhone("15618967956");
//        asCustomerDto.setCustomerTel("17011963281");
        asCustomerDto.setCustomerTel("15618967956");
        asCustomerDto.setCustomerEmail("250577914@qq.com");
        asCustomerDto.setCustomerPostcode("200120");
        afsApplyEntity.setAsCustomerDto(asCustomerDto);
        //取件信息实体
        AfterSalePickwareDto afterSalePickwareDto = new AfterSalePickwareDto();
        afterSalePickwareDto.setPickwareType(40);
        afterSalePickwareDto.setPickwareProvince(2);
        afterSalePickwareDto.setPickwareCity(2830);
        afterSalePickwareDto.setPickwareCounty(51803);
        afterSalePickwareDto.setPickwareVillage(0);
        afterSalePickwareDto.setPickwareAddress("民生路1399号太平人寿大厦1603");
        afsApplyEntity.setAsPickwareDto(afterSalePickwareDto);
        //返件信息实体，即商品如何返回客户手中
        AfterSaleReturnwareDto afterSaleReturnwareDto = new AfterSaleReturnwareDto();
        afterSaleReturnwareDto.setReturnwareType(10);
        afterSaleReturnwareDto.setReturnwareProvince(2);
        afterSaleReturnwareDto.setReturnwareCity(2830);
        afterSaleReturnwareDto.setReturnwareCounty(51803);
        afterSaleReturnwareDto.setReturnwareVillage(0);
        afterSaleReturnwareDto.setReturnwareAddress("民生路1399号太平人寿大厦1603");
        afsApplyEntity.setAsReturnwareDto(afterSaleReturnwareDto);
        //申请单明细
        AfterSaleDetailDto afterSaleDetailDto = new AfterSaleDetailDto();
        afterSaleDetailDto.setSkuId(skuId);
        afterSaleDetailDto.setSkuNum(skuNum);
        afsApplyEntity.setAsDetailDto(afterSaleDetailDto);
        return jdAftersaleApi.createServiceTicket(afsApplyEntity);
    }


    @RequestMapping("/getServiceListPage")
    public ServiceListPageResp getServiceListPage(Long jdOrderId, Integer pageIndex, Integer pageSize) {
        ServiceListPageEntity serviceListPageEntity = new ServiceListPageEntity();
        serviceListPageEntity.setJdOrderId(jdOrderId);
        serviceListPageEntity.setPageIndex(pageIndex);
        serviceListPageEntity.setPageSize(pageSize);
        return jdAftersaleApi.getServiceListPage(serviceListPageEntity);
    }

    @RequestMapping("/getServiceDetailInfo")
    public ServiceDetailInfoResp getServiceDetailInfo(Long afsServiceId) {
        ServiceDetailInfoEntity serviceDetailInfoEntity = new ServiceDetailInfoEntity();
        serviceDetailInfoEntity.setAfsServiceId(afsServiceId);
        List<Integer> steps = new ArrayList<>();
        steps.add(1);
        steps.add(2);
        steps.add(3);
        steps.add(4);
        steps.add(5);
        serviceDetailInfoEntity.setAppendInfoSteps(steps);
        return jdAftersaleApi.getServiceDetailInfo(serviceDetailInfoEntity);
    }

    @RequestMapping("/cancelAudit")
    public AuditCancelResp cancelAudit(Integer... serviceIds) {
        AuditCancelEntity auditCancelEntity = new AuditCancelEntity();
        auditCancelEntity.setApproveNotes("取消服务单");
        List<Integer> serviceIdList = new ArrayList<>();
        for (Integer serviceId : serviceIds) {
            serviceIdList.add(serviceId);
        }
        auditCancelEntity.setServiceIdList(serviceIdList);
        return jdAftersaleApi.cancelAudit(auditCancelEntity);
    }

    /**
     * 设置单元格宽度
     *
     * @param sheet
     */
    private void setContentColumnWidth(HSSFSheet sheet) {
        sheet.setColumnWidth(0, 5000); //商品池名称
        sheet.setColumnWidth(1, 5000); //编码
        sheet.setColumnWidth(2, 5000); //sku
        sheet.setColumnWidth(3, 50000); //name

    }

    /**
     * 设置单元格样式
     *
     * @param wb
     * @return
     */
    private HSSFCellStyle setContentCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle cellStyle = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontName("黑体");
        font.setFontHeightInPoints((short) 10);//设置字体大小
//        font.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);//粗体显示
        cellStyle.setFont(font);
        cellStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN);
        cellStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);
        cellStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);
        cellStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);
        cellStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
        return cellStyle;
    }

    /**
     * 设置单元格内容
     *
     * @param value
     * @return
     */
    private String setContentCellValue(String value) {
        if (Lang.isEmpty(value)) {
            return "";
        } else {
            return value;
        }
    }

    /**
     * 创建表头
     *
     * @param row
     * @param cellStyle
     * @param cell
     */
    private void createCellHead(HSSFRow row, HSSFCellStyle cellStyle, HSSFCell cell) {
        cell.setCellStyle(cellStyle);
        cell.setCellValue("商品池名称");
        cell = row.createCell(1);
        cell.setCellValue("商品池编号");
        cell = row.createCell(2);
        cell.setCellValue("sku");
        cell = row.createCell(3);
        cell.setCellValue("商品名称");
        cell = row.createCell(4);

    }

    /**
     * 创建表内容
     *
     * @param writeExcelList
     * @param cellStyle
     * @param sheet
     */
    private void createCellContent(List<Map> writeExcelList, HSSFCellStyle cellStyle, HSSFSheet sheet) {
        for (int i = 0; i < writeExcelList.size(); i++) {
            int rowCount = i + 1;
            HSSFRow row = sheet.createRow(rowCount);
            Map returnMap = writeExcelList.get(i);
            HSSFCell theCell = row.createCell(0);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(setContentCellValue((String) returnMap.get("poolsName")));
            theCell = row.createCell(1);
            theCell.setCellValue(setContentCellValue((String) returnMap.get("pageNum")));
            theCell = row.createCell(2);
            theCell.setCellValue(setContentCellValue((String) returnMap.get("sku")));
            theCell = row.createCell(3);
            theCell.setCellValue(setContentCellValue((String) returnMap.get("name")));

        }
    }

    @Autowired
    ProductDbInitService productDbInitService;

    @RequestMapping("jd/initGoodsPriceAndState")
    public Object initGoodsPriceAndState() {
        return null;
        //return productDbInitService.initGoodsPriceAndState();
    }

}
