package jd.service.web;


import jd.api.request.product.CategorysEntity;
import jd.api.request.product.PageNumEntity;
import jd.api.response.product.CategorysResp;

import jd.api.service.product.JdProductApi;
import jd.service.service.CategoryDbService;
import jd.service.service.ProductDbInitService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.Lang;

import utils.log.Log;
import utils.log.Logs;

import java.util.*;

/**
 * Created by Roney on 2017-07-15.
 */
@Controller
@RequestMapping("prod")
public class JdProductController {
    private final static Log log = Logs.getLog(JdProductController.class.getName());

    @Autowired
    ProductDbInitService productDbInitService;
    @Autowired
    CategoryDbService categoryDbService;

    @Autowired
    JdProductApi jdProductApi;
    List<Long> productNos;
    List<Long> productNosList;
    int totalNum;

    @RequestMapping("asyncInitProduct")
    @ResponseBody
    public String asyncInitProduct(@RequestParam Boolean isCompatible,@RequestParam(name = "isThread", required = true) Boolean isThread,@RequestParam(name = "poolSize") Integer poolSize) {

        productDbInitService.asyncInitProduct(isCompatible,isThread,poolSize);
        return "asyncInitProduct";
    }

    /**
     * 手工同步数据
     * @param skus
     * @return
     */
    @RequestMapping("/synchronizData")
    @ResponseBody
    public Map synchronizData(@RequestParam(name = "skus[]", required = true) String[] skus ,@RequestParam(name = "isThread", required = true) Boolean isThread,@RequestParam(name = "poolSize") Integer poolSize) {
        Map returnMap = new HashMap();
        Set<Long> productNoSet = new HashSet<Long>();
        List<String> goodsIds = new ArrayList<>();
        for (String sku : skus) {
            productNoSet.add(Long.parseLong(sku));
//            List<String> goodsIdList=productDbInitService.addGoods(Long.valueOf(sku));
//            for(String id:goodsIdList){
//                if(!Lang.isEmpty(id)){
//                    goodsIds.add(id);
//                }
//            }
//            returnMap.put(sku,goodsIdList);

        }

        productNosList = new ArrayList<Long>(productNoSet);
        totalNum = productNosList.size();

        //更新索引和goods_config
         productDbInitService.executorsPoolAdd(productNosList,totalNum,isThread,poolSize);
        returnMap.put("skus",productNosList);
        return returnMap;
    }

    @RequestMapping("/asyncInitProdByProductPool")
    @ResponseBody
    public Map asyncInitProdByPool(@RequestParam(name = "poolsNums[]", required = true) String[] poolsNums ,@RequestParam(name = "isCompatible",required = true) Boolean isCompatible,@RequestParam(name = "isThread", required = true) Boolean isThread,@RequestParam(name = "poolSize") Integer poolSize) {
        Set<Long> productNoSet = new HashSet<Long>();
       // List<String> goodsIds = new ArrayList<>();

        Map returnMap = new HashMap();

        for (String poolsNum : poolsNums) {
            if(isCompatible) {
                productNos = jdProductApi.getProductPoolProductOld(new PageNumEntity(poolsNum, 1));
            }else {
                productNos = jdProductApi.getProductPoolProduct(new PageNumEntity(poolsNum));
            }
            productNoSet.addAll(productNos);
        }


        productNosList = new ArrayList<Long>(productNoSet);
        totalNum = productNosList.size();


        productDbInitService.executorsPoolAdd(productNosList,totalNum,isThread,poolSize);
        returnMap.put("skus",productNosList);
        return returnMap;
    }



    @RequestMapping("getCategorys/{pageNo}/{pageSize}/{catClass}")
    @ResponseBody
    public CategorysResp queryCategorysByCatclass(@PathVariable Integer pageNo, @PathVariable Integer pageSize, @PathVariable Integer catClass) {
        return productDbInitService.getCategorys(new CategorysEntity(pageNo, pageSize, null, catClass));
    }

    @RequestMapping("getCategorysByParent/{pageNo}/{pageSize}/{parentId}")
    @ResponseBody
    public CategorysResp queryCategorysByParent(@PathVariable Integer pageNo, @PathVariable Integer pageSize, @PathVariable Integer parentId) {
        return productDbInitService.getCategorys(new CategorysEntity(pageNo, pageSize, parentId, null));
    }


    @RequestMapping("batchDelete")
    @ResponseBody
    public String batchDelete() {
        productDbInitService.batchDelete();
        return "batchDelete";
    }

    @RequestMapping("initCategory")
    @ResponseBody
    public String initCategory() {
        categoryDbService.initCategory();
        return "initCategory";
    }


    @RequestMapping("categoryMatch")
    @ResponseBody
    public String categoryMatch() {
        categoryDbService.matchCategory();
        return "categoryMatch";
    }

    @RequestMapping("deleteCategoryMatch")
    @ResponseBody
    public String deleteCategoryMatch() {
        categoryDbService.deleteCategoryMatch();
        return "deleteCategoryMatch";
    }

    @RequestMapping("initProductPool")
    @ResponseBody
    public Map initProductPool(Integer poolSize) {
        if(Lang.isEmpty(poolSize)){
            poolSize=5;
        }
        Map returnMap=productDbInitService.initProductPool(poolSize);
        return returnMap;
    }


}
