package jd.service.web;

import com.alibaba.fastjson.JSON;

import jd.api.request.product.PageNumEntity;
import jd.api.service.product.JdProductApi;
import jd.api.vo.product.ProductPoolVO;
import jd.service.jdapi.test.TestApi;
import jd.service.jdapi.test.TestVO;

import jdek.api.request.*;
import jdek.api.response.JdekDelMessageResp;
import jdek.api.response.JdekGetMessageResp;
import jdek.api.response.JdekRepayResp;
import jdek.api.service.*;
import jdek.api.vo.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import utils.security.JdDesUtil;

import java.util.*;

/**
 * Created by xujingfeng on 2017/3/7.
 */
@Profile("local")
@RestController
public class TestController {

    @RequestMapping("api/test")
    public TestVO test(Map<String,Object> map,TestVO testVO){
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            System.out.println(entry.getKey()+":"+entry.getValue());
        }
        System.out.println(JSON.toJSONString(testVO));
        return new TestVO("徐靖峰",new Date());
    }

    @Autowired
    TestApi testApi;

    @RequestMapping("api/startTest")
    public TestVO startTest(){
        TestVO test = testApi.test();
        return test;
    }

    @Autowired
    JdProductApi jdProductApi;

    Logger logger = LoggerFactory.getLogger(TestController.class);

    @RequestMapping("countProduct")
    public String countProduct(){
        Set<Long> productNos = new HashSet<>();
        List<ProductPoolVO> productPool = jdProductApi.getProductPool();
        for (ProductPoolVO productPoolVO : productPool) {
            try{
                List<Long> productPoolProduct = jdProductApi.getProductPoolProduct(new PageNumEntity(productPoolVO.getPage_num()));
                productNos.addAll(productPoolProduct);
            }catch (Exception e){
                logger.error(e.getMessage());
            }
        }
        System.out.println(productNos.size());
        return "countProduct";
    }
    @Autowired
    JdekApi jdekApi;
    @RequestMapping(value = {"testJdek"},method = RequestMethod.POST)
    public JdekOrderVo testJdekOrder(JdekOrderEntity jdekOrderEntity){
        jdekOrderEntity.setIfSendMsg(false);
        jdekOrderEntity.setPaymentType(4);
        JdekSkuVo jdekSkuVo=new JdekSkuVo();
        jdekSkuVo.setNum("1");
        jdekSkuVo.setPrice("500");
        ArrayList list=new ArrayList<>();
        list.add(jdekSkuVo);
        jdekOrderEntity.setSku(list);
        jdekOrderEntity.setThirdOrder("uu123456789");
        return jdekApi.placeOrder(jdekOrderEntity);
    }

    @RequestMapping(value={"testJdek2"},method = RequestMethod.POST)
    public ArrayList<JdekInfoVo> testGetJdekOrderInfo(JdekSerchOrderEntity jdekSerchOrderEntity){
        jdekSerchOrderEntity.setJdOrderId("12345");
        return jdekApi.getJdekOrderInfo(jdekSerchOrderEntity);
    }

    @RequestMapping(value={"testJdek3"},method = RequestMethod.POST)
    public JdekSmsReissueVo testsendSms(JdekSmsReissueEntity jdekSmsReissueEntity){
        jdekSmsReissueEntity.setJdOrderId("12345");
        jdekSmsReissueEntity.setMobile("15576094185");
        return jdekApi.sendMessageAgin(jdekSmsReissueEntity);
    }


    @RequestMapping(value={"testJdek4"},method = RequestMethod.POST)
    public JdekSerchByThirdOrderVo testSerchByThirdOrder(JdekSerchByThirdOrderEntity jdekSerchByThirdOrderEntity){
        jdekSerchByThirdOrderEntity.setThirdOrder("12345");
        return jdekApi.selectByThirdOrder(jdekSerchByThirdOrderEntity);
    }


    @RequestMapping(value={"testJdek5"},method = RequestMethod.POST)
    public JdekBalanceVo testSerchByThirdOrder(JdekGetBalanceEntity jdekGetBalanceEntity){
        jdekGetBalanceEntity.setType(4);
        return jdekApi.getBalance(jdekGetBalanceEntity);
    }


    @RequestMapping(value={"testJdek6"},method = RequestMethod.POST)
    public JdekGetMessageResp testGetMessage(JdekGetMessageEntity jdekGetMessageEntity){
        jdekGetMessageEntity.setDel(0);
        jdekGetMessageEntity.setType("10,12");
        return jdekApi.getMessage(jdekGetMessageEntity);
    }


    @RequestMapping(value={"testJdek7"},method = RequestMethod.POST)
    public JdekDelMessageResp testDelMessage(JdekDelMessageEntity jdekGetMessageEntity){
        jdekGetMessageEntity.setId(1234567894556l);
        return jdekApi.delMessage(jdekGetMessageEntity);
    }


    @RequestMapping(value={"testJdek8"},method = RequestMethod.POST)
    public JdekRepayResp testDelMessage(JdekRepayEntity jdekRepayEntity){
        jdekRepayEntity.setJdOrderId(1234567894556l);
        return jdekApi.Repay(jdekRepayEntity);
    }
    @RequestMapping(value={"testJdek9"},method = RequestMethod.POST)
    public void testDesUtil(){
        String key="Q59BXC1A";
        String a="D6C4BA74A27B93DB";
        String result= null;
        try {
            result = JdDesUtil.encrypt(a,key);
        } catch (Exception e) {
            System.out.println(e);
    }
        System.out.println("加密后=========="+result);
        try {
            System.out.println("解密后=========="+JdDesUtil.decrypt(result,key));
        } catch (Exception e) {
            System.out.println(e);
        }
    }


}
