package jdek.service.jdekapi.JdekApiImpl;

import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import jd.service.service.JdSystemLogService;
import jdek.api.request.*;
import jdek.api.response.*;
import jdek.api.service.JdekApi;
import jdek.api.vo.*;
import jdek.service.jdekapi.token.TokenServiceJdek;

import jdek.service.retrofit.api.JdekRestApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import retrofit2.Call;
import retrofit2.Retrofit;
import utils.Lang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by bande on 2017/7/14.
 */
@MotanService
public class JdekApiImpl implements JdekApi {
    private Retrofit retrofit;
    private TokenServiceJdek tokenServiceJdek;
    private JdekRestApi jdekRestApi;

    @Autowired
    JdSystemLogService jdSystemLogService;
    public static final Logger logger = LoggerFactory.getLogger(JdekApiImpl.class);

    public JdekApiImpl(Retrofit retrofitJdek, TokenServiceJdek tokenServiceJdek) {
        this.retrofit = retrofitJdek;
        this.tokenServiceJdek = tokenServiceJdek;
        this.jdekRestApi=this.retrofit.create(JdekRestApi.class);
    }

    @Override
    public JdekDelMessageResp delMessage(JdekDelMessageEntity delMessageEntity) {
       try{ Map map = new HashMap<>();
        map.put("token", tokenServiceJdek.accessToken());
        map.put("id",delMessageEntity.getId());

        Call<JdekDelMessageResp> call = jdekRestApi.delMessage(Lang.filterNullMap(map, false));
        JdekDelMessageResp result=call.execute().body();
        jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(result),null,null);
        return result;
    } catch (Exception e) {
        jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
        logger.error(e.getMessage(), e);
        return null;
    }
    }

    @Override
    public JdekBalanceVo getBalance(JdekGetBalanceEntity jdekGetBalanceEntity) {
        try {
            Map map = new HashMap<>();
            map.put("token", tokenServiceJdek.accessToken());
            map.put("type",jdekGetBalanceEntity.getType());

            Call<JdekBalanceVo> call = jdekRestApi.getBalance(Lang.filterNullMap(map, false));
            JdekBalanceVo result=call.execute().body();
            jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(result),null,null);
            return result;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public JdekGetMessageResp getMessage(JdekGetMessageEntity jdekGetMessageEntity) {
        try {
            Map map = new HashMap<>();
            map.put("token", tokenServiceJdek.accessToken());
            map.put("del",jdekGetMessageEntity.getDel());
            map.put("type",jdekGetMessageEntity.getType());

            Call<JdekGetMessageResp> call = jdekRestApi.getMessage(Lang.filterNullMap(map, false));
            JdekGetMessageResp result=call.execute().body();
            jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(result),null,null);
            return result;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public JdekOrderVo placeOrder(JdekOrderEntity jdekOrderEntity) {
        try {
            Map map = new HashMap<>();
            map.put("token", tokenServiceJdek.accessToken());
            map.put("thirdOrder",jdekOrderEntity.getThirdOrder());
            map.put("sku",JSONObject.toJSONString(jdekOrderEntity.getSku()));
            map.put("mobile","00000000000");
            map.put("paymentType",jdekOrderEntity.getPaymentType());
            map.put("ifSendMsg",jdekOrderEntity.getIfSendMsg());
            Call<JdekOrderResp> call = jdekRestApi.placeOrder(Lang.filterNullMap(map, false));
            JdekOrderResp temp=call.execute().body();
            if("0".equals(temp.getResultCode())){
            JdekOrderVo result=temp.getResult();
            jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(result),null,null);
            return result;
            }else{
                return null;
            }
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }

    }

    @Override
    public JdekRepayResp Repay(JdekRepayEntity jdekRepayEntity) {
        try {
            Map map = new HashMap<>();
            map.put("token", tokenServiceJdek.accessToken());
            map.put("jdOrderId",jdekRepayEntity.getJdOrderId());
            Call<JdekRepayResp> call = jdekRestApi.repay(Lang.filterNullMap(map, false));
            JdekRepayResp result=call.execute().body();
            jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(result),null,null);
            return result;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public JdekSerchByThirdOrderVo selectByThirdOrder(JdekSerchByThirdOrderEntity jdekSerchByThirdOrderEntity) {
        try {
            Map map = new HashMap<>();
            map.put("token", tokenServiceJdek.accessToken());
            map.put("thirdOrder",jdekSerchByThirdOrderEntity.getThirdOrder());
            Call<JdekSerchByThirdOrderResp> call = jdekRestApi.selectByThirdOrder(Lang.filterNullMap(map, false));
            JdekSerchByThirdOrderResp temp=call.execute().body();
            if("0".equals(temp.getResultCode())) {
                JdekSerchByThirdOrderVo result = call.execute().body().getResult();
                jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map), JSONObject.toJSONString(result), null, null);
                return result;
            }else {
                return null;
            }
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public ArrayList<JdekInfoVo> getJdekOrderInfo(JdekSerchOrderEntity jdekSerchOrderEntity) {
        try {
            Map map = new HashMap<>();
            map.put("token", tokenServiceJdek.accessToken());
            map.put("jdOrderId",jdekSerchOrderEntity.getJdOrderId());
            Call<JdekSerchOrderResp> call = jdekRestApi.getJdekOrderInfo(Lang.filterNullMap(map, false));
            JdekSerchOrderResp temp=call.execute().body();
            if("0".equals(temp.getResultCode())){
            ArrayList<JdekInfoVo> result=temp.getResult();
            jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(result),null,null);
            return result;
            }else{
                return null;
            }
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public JdekSmsReissueVo sendMessageAgin(JdekSmsReissueEntity jdekSmsReissueEntity) {
        try{
            Map map=new HashMap<>();
            map.put("token",tokenServiceJdek.accessToken());
            map.put("jdOrderId",jdekSmsReissueEntity.getJdOrderId());
            map.put("mobile",jdekSmsReissueEntity.getMobile());
            Call<JdekSmsReissueVo> call=jdekRestApi.sendMessageAgin(Lang.filterNullMap(map,false));
            JdekSmsReissueVo result=call.execute().body();
            jdSystemLogService.asyncSysLog(call.request().url().toString(), JSONObject.toJSONString(map),JSONObject.toJSONString(result),null,null);
            return result;
        }catch (Exception e){
            jdSystemLogService.asyncSysLog(null,null,null,null,e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }
}
