package jdek.service.jdekapi.token;

import com.alibaba.fastjson.JSON;

import jd.service.service.JdSystemLogService;
import jdek.service.retrofit.api.AbstractJdApi;
import jdek.service.retrofit.api.JDAuthApi;
import jdek.service.retrofit.config.RetrofitConfigVoJdek;
import jdek.service.retrofit.converter.BeanToMapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;
import utils.Lang;
import utils.security.MD5Utils;

import javax.annotation.PostConstruct;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by xujingfeng on 2016年10月26日
 */
@Service
public class TokenServiceJdek extends AbstractJdApi {

    private static final Logger logger = LoggerFactory.getLogger(TokenServiceJdek.class);
    private Retrofit retrofitjdek;

    public final String accessTokenStr = "szjdapi:jdekTokenData";

    private JDAuthApi JDAuthApi;

    private volatile TokenVO tokenVO = null;

    public void setTokenVO(TokenVO tokenVO) {
        this.tokenVO = tokenVO;
    }

    @Autowired
    RetrofitConfigVoJdek retrofitConfigVoJdek;

    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    JdSystemLogService jdSystemLogService;

    @PostConstruct
    private void inited() {
        logger.info("JD access token :{}", getToken(false));
    }

    public TokenServiceJdek(@Value("${retrofitJdek.tokenUrl}") String tokenUrl) {
        this.retrofitjdek = new Retrofit.Builder()
                .baseUrl(tokenUrl)
                .addConverterFactory(JacksonConverterFactory.create())
                .build();
        this.JDAuthApi = this.retrofitjdek.create(JDAuthApi.class);
    }

    public String accessToken() {
        TokenVO tokenVO=getToken(false);
        if(tokenVO==null||"null".equals(tokenVO)){
            tokenVO = getTokenVO(retrofitConfigVoJdek.getUserEntity());
            if(tokenVO!=null){
                BoundValueOperations<String, String> accessTokenOp = redisTemplate.boundValueOps(accessTokenStr);
                accessTokenOp.set(JSON.toJSONString(tokenVO));
                this.tokenVO = tokenVO;
            }else {
                logger.error("获取token异常");
            }
            return tokenVO.getAccess_token();
        }else {
            return tokenVO.getAccess_token();
        }
    }

    public TokenVO getToken(boolean force) {
        BoundValueOperations<String, String> accessTokenOp = redisTemplate.boundValueOps(accessTokenStr);
        if (!force) {
            //内存中有，直接返回
            if (tokenVO != null)
                return tokenVO;
            //去京东取放入
            String tokenData = accessTokenOp.get();
            if (tokenData == null || "".equals(tokenData.trim())||"null".equals(tokenData)) {
                //调用接口获取
                TokenVO tokenVO = getTokenVO(retrofitConfigVoJdek.getUserEntity());
                //设置redis
                if (tokenVO != null) {
                    accessTokenOp.set(JSON.toJSONString(tokenVO));
                }
                //设置内存
                this.tokenVO = tokenVO;
            } else {
                //从redis拿
                try {
                    tokenVO = JSON.parseObject(tokenData, TokenVO.class);
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
            }
        } else {
            TokenVO tokenVO = getTokenVO(retrofitConfigVoJdek.getUserEntity());
            if (tokenVO != null) {
                accessTokenOp.set(JSON.toJSONString(tokenVO));
                this.tokenVO = tokenVO;
            }
        }
        return tokenVO;
    }

    /**
     * 获取token
     *
     * @param user
     * @return
     * @throws Exception
     */
    private TokenVO getTokenVO(UserEntity user) {
        try {
            user.setTimestamp(sdf.get().format(new Date()));
            user.setSign(createSign(user));
//            utils.convert.Converter converter = new ObjectToMapConverter();
//            Map map = (Map) converter.convert(user, HashMap.class);
            Map map = BeanToMapUtil.convertBean(user);

            Call<TokenResponseJdek> response = JDAuthApi.accessToken(Lang.filterNullMap(map, false));
            TokenVO token = null;
            if (response != null) {
                TokenResponseJdek body = response.execute().body();
                logger.info("getTokenVO {}", JSON.toJSONString(body.getResult()));
                token = body.getResult();
            }
            return token;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    public TokenVO refreshToken() {
        Map<String, String> map = new HashMap<>();
        map.put("refresh_token", tokenVO.getRefresh_token());
        map.put("client_id", retrofitConfigVoJdek.getUserEntity().getClient_id());
        map.put("client_secret", retrofitConfigVoJdek.getUserEntity().getClient_secret());
        Call<TokenVO> call = JDAuthApi.refreshToken(map);
        try {
            TokenVO result = call.execute().body();
            this.tokenVO = result;
            BoundValueOperations<String, String> accessTokenOp = redisTemplate.boundValueOps(accessTokenStr);
            accessTokenOp.set(JSON.toJSONString(this.tokenVO));
            logger.info("refreshToken {}", JSON.toJSONString(result));
            logger.info("定时刷新 tokenVO {}", JSON.toJSONString(this.tokenVO));
            return this.tokenVO;
        } catch (Exception e) {
            jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    private String createSign(UserEntity user) {
        String username = user.getUsername();
        String password = user.getPassword();
        String timestamp = user.getTimestamp();
        String clientSecret = user.getClient_secret();
        String clientId = user.getClient_id();
        String sign = clientSecret + timestamp + clientId + username + password + "access_token" + clientSecret;
        return MD5Utils.MD5Encode(sign, "utf-8").toUpperCase();
    }
}
