package jdek.service.retrofit.api;

import jdek.api.response.*;
import jdek.api.vo.JdekBalanceVo;
import jdek.api.vo.JdekSmsReissueVo;
import retrofit2.Call;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.POST;

import java.util.Map;

/**
 * Created by bande on 2017/7/14.
 */
public interface JdekRestApi {
    /**
     * 删除推送消息
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("vir/api/message/del")
    Call<JdekDelMessageResp> delMessage(@FieldMap Map<String, Object> map);

    /**
     * 获取余额
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("vir/api/pay/getBalance")
    Call<JdekBalanceVo> getBalance(@FieldMap Map<String, Object> map);

    /**
     * 获取消息推送
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("vir/api/message/get")
    Call<JdekGetMessageResp> getMessage(@FieldMap Map<String, Object> map);

    /**
     * 京东E卡下单接口
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("vir/api/giftCard/buy")
    Call<JdekOrderResp> placeOrder(@FieldMap Map<String, Object> map);

    /**
     * 重新发起支付
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("vir/api/pay/repay")
    Call<JdekRepayResp> repay(@FieldMap Map<String, Object> map);

    /**
     * 反查京东订单信息
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("vir/api/giftCard/selectByThirdOrder")
    Call<JdekSerchByThirdOrderResp> selectByThirdOrder(@FieldMap Map<String, Object> map);

    /**
     * 查询京东订单信息接口
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("vir/api/giftCard/select")
    Call<JdekSerchOrderResp> getJdekOrderInfo(@FieldMap Map<String, Object> map);

    /**
     * 京东E卡短信补发接口
     * ps：24小时内补发短信，最多只能补发3次，超过3次后调用接口就会失败
     * @param map
     * @return
     */
    @FormUrlEncoded
    @POST("vir/api/giftCard/sendSms")
    Call<JdekSmsReissueVo> sendMessageAgin(@FieldMap Map<String,Object> map);
}
