/*
 * Decompiled with CFR 0.152.
 */
package jd.service.jdapi.address;

import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import java.util.HashMap;
import java.util.Map;
import jd.api.request.address.AddressEntity;
import jd.api.response.address.AddressDetailResp;
import jd.api.service.address.JdAddressApi;
import jd.service.jdapi.token.TokenService;
import jd.service.retrofit.api.JdAddressRestApi;
import jd.service.service.JdSystemLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import retrofit2.Call;
import retrofit2.Retrofit;
import utils.Lang;

@MotanService
public class JdAddressApiImpl
implements JdAddressApi {
    private Retrofit retrofit;
    private JdAddressRestApi jdAddressRestApi;
    private TokenService tokenService;
    @Autowired
    JdSystemLogService jdSystemLogService;
    public static final Logger logger = LoggerFactory.getLogger(JdAddressApiImpl.class);

    public JdAddressApiImpl(TokenService tokenService, Retrofit retrofit) {
        this.tokenService = tokenService;
        this.retrofit = retrofit;
        this.jdAddressRestApi = (JdAddressRestApi)this.retrofit.create(JdAddressRestApi.class);
    }

    public Map<String, Integer> getLevelOneAddress() {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("token", this.tokenService.accessToken());
            Call call = this.jdAddressRestApi.getProvince(Lang.filterNullMap(map, (Boolean)false));
            Map returnMap = ((AddressDetailResp)call.execute().body()).getResult();
            return returnMap;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Map<String, Integer> getLevelTwoAddress(AddressEntity addressEntity) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("token", this.tokenService.accessToken());
            map.put("id", addressEntity.getId());
            Call call = this.jdAddressRestApi.getCity(Lang.filterNullMap(map, (Boolean)false));
            Map returnMap = ((AddressDetailResp)call.execute().body()).getResult();
            return returnMap;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Map<String, Integer> getLevelThreeAddress(AddressEntity addressEntity) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("token", this.tokenService.accessToken());
            map.put("id", addressEntity.getId());
            Call call = this.jdAddressRestApi.getCounty(Lang.filterNullMap(map, (Boolean)false));
            Map returnMap = ((AddressDetailResp)call.execute().body()).getResult();
            return returnMap;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Map<String, Integer> getLevelFourAddress(AddressEntity addressEntity) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("token", this.tokenService.accessToken());
            map.put("id", addressEntity.getId());
            Call call = this.jdAddressRestApi.getTown(Lang.filterNullMap(map, (Boolean)false));
            Map returnMap = ((AddressDetailResp)call.execute().body()).getResult();
            return returnMap;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

