/*
 * Decompiled with CFR 0.152.
 */
package jd.service.jdapi.aftersale;

import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import java.util.HashMap;
import java.util.Map;
import jd.api.request.aftersale.AfsApplyEntity;
import jd.api.request.aftersale.AuditCancelEntity;
import jd.api.request.aftersale.OrderSkuEntity;
import jd.api.request.aftersale.SendSkuEntity;
import jd.api.request.aftersale.ServiceDetailInfoEntity;
import jd.api.request.aftersale.ServiceListPageEntity;
import jd.api.response.aftersale.AfsApplyResp;
import jd.api.response.aftersale.AuditCancelResp;
import jd.api.response.aftersale.AvailableNumberCompResp;
import jd.api.response.aftersale.CustomerExpectCompResp;
import jd.api.response.aftersale.SendSkuResp;
import jd.api.response.aftersale.ServiceDetailInfoResp;
import jd.api.response.aftersale.ServiceListPageResp;
import jd.api.response.aftersale.WareReturnJdCompResp;
import jd.api.service.aftersale.JdAftersaleApi;
import jd.service.jdapi.address.JdAddressApiImpl;
import jd.service.jdapi.token.TokenService;
import jd.service.retrofit.api.JdAftersaleRestApi;
import jd.service.service.JdSystemLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import retrofit2.Call;
import retrofit2.Retrofit;
import utils.Lang;
import utils.convert.converters.map.ObjectToMapConverter;

@MotanService
public class JdAftersaleApiImpl
implements JdAftersaleApi {
    private Retrofit retrofit;
    private JdAftersaleRestApi jdAftersaleRestApi;
    private TokenService tokenService;
    public static final Logger logger = LoggerFactory.getLogger(JdAddressApiImpl.class);
    @Autowired
    JdSystemLogService jdSystemLogService;

    public JdAftersaleApiImpl(TokenService tokenService, Retrofit retrofit) {
        this.tokenService = tokenService;
        this.retrofit = retrofit;
        this.jdAftersaleRestApi = (JdAftersaleRestApi)this.retrofit.create(JdAftersaleRestApi.class);
    }

    public AfsApplyResp createServiceTicket(AfsApplyEntity afsApplyEntity) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            String json = JSONObject.toJSONString((Object)afsApplyEntity);
            map.put("param", json);
            map.put("token", this.tokenService.accessToken());
            Call call = this.jdAftersaleRestApi.createAfsApply(Lang.filterNullMap(map, (Boolean)false));
            AfsApplyResp afsApplyResp = (AfsApplyResp)call.execute().body();
            HashMap<String, AfsApplyResp> returnMap = new HashMap<String, AfsApplyResp>();
            returnMap.put("response", afsApplyResp);
            return afsApplyResp;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public SendSkuResp sendSku(SendSkuEntity sendSkuEntity) {
        try {
            ObjectToMapConverter converter = new ObjectToMapConverter();
            Map map = (Map)converter.convert((Object)sendSkuEntity, HashMap.class, new Object[0]);
            map.put("token", this.tokenService.accessToken());
            Call call = this.jdAftersaleRestApi.updateSendSku(Lang.filterNullMap((Map)map, (Boolean)false));
            SendSkuResp sendSkuResp = (SendSkuResp)call.execute().body();
            HashMap<String, SendSkuResp> returnMap = new HashMap<String, SendSkuResp>();
            returnMap.put("response", sendSkuResp);
            return sendSkuResp;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public AvailableNumberCompResp getAvailableNumber(OrderSkuEntity orderSkuEntity) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            String json = JSONObject.toJSONString((Object)orderSkuEntity);
            map.put("token", this.tokenService.accessToken());
            map.put("param", json);
            Call call = this.jdAftersaleRestApi.getAvailableNumberComp(Lang.filterNullMap(map, (Boolean)false));
            AvailableNumberCompResp availableNumberCompResp = (AvailableNumberCompResp)call.execute().body();
            HashMap<String, AvailableNumberCompResp> returnMap = new HashMap<String, AvailableNumberCompResp>();
            returnMap.put("response", availableNumberCompResp);
            return availableNumberCompResp;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public CustomerExpectCompResp getCustomerExpect(OrderSkuEntity orderSkuEntity) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            String json = JSONObject.toJSONString((Object)orderSkuEntity);
            map.put("param", json);
            map.put("token", this.tokenService.accessToken());
            Call call = this.jdAftersaleRestApi.getCustomerExpectComp(Lang.filterNullMap(map, (Boolean)false));
            CustomerExpectCompResp customerExpectCompResp = (CustomerExpectCompResp)call.execute().body();
            HashMap<String, CustomerExpectCompResp> returnMap = new HashMap<String, CustomerExpectCompResp>();
            returnMap.put("response", customerExpectCompResp);
            return customerExpectCompResp;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public WareReturnJdCompResp getWareReturnJd(OrderSkuEntity orderSkuEntity) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            String json = JSONObject.toJSONString((Object)orderSkuEntity);
            map.put("param", json);
            map.put("token", this.tokenService.accessToken());
            Call call = this.jdAftersaleRestApi.getWareReturnJdComp(Lang.filterNullMap(map, (Boolean)false));
            WareReturnJdCompResp wareReturnJdCompResp = (WareReturnJdCompResp)call.execute().body();
            HashMap<String, WareReturnJdCompResp> returnMap = new HashMap<String, WareReturnJdCompResp>();
            returnMap.put("response", wareReturnJdCompResp);
            return wareReturnJdCompResp;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public ServiceListPageResp getServiceListPage(ServiceListPageEntity serviceListPageEntity) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            String json = JSONObject.toJSONString((Object)serviceListPageEntity);
            map.put("param", json);
            map.put("token", this.tokenService.accessToken());
            Call call = this.jdAftersaleRestApi.getServiceListPage(Lang.filterNullMap(map, (Boolean)false));
            ServiceListPageResp serviceListPageResp = (ServiceListPageResp)call.execute().body();
            HashMap<String, ServiceListPageResp> returnMap = new HashMap<String, ServiceListPageResp>();
            returnMap.put("response", serviceListPageResp);
            return serviceListPageResp;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public ServiceDetailInfoResp getServiceDetailInfo(ServiceDetailInfoEntity serviceDetailInfoEntity) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            String json = JSONObject.toJSONString((Object)serviceDetailInfoEntity);
            map.put("param", json);
            map.put("token", this.tokenService.accessToken());
            Call call = this.jdAftersaleRestApi.getServiceDetailInfo(Lang.filterNullMap(map, (Boolean)false));
            ServiceDetailInfoResp serviceDetailInfoResp = (ServiceDetailInfoResp)call.execute().body();
            HashMap<String, ServiceDetailInfoResp> returnMap = new HashMap<String, ServiceDetailInfoResp>();
            returnMap.put("response", serviceDetailInfoResp);
            return serviceDetailInfoResp;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public AuditCancelResp cancelAudit(AuditCancelEntity auditCancelEntity) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            String json = JSONObject.toJSONString((Object)auditCancelEntity);
            map.put("param", json);
            map.put("token", this.tokenService.accessToken());
            Call call = this.jdAftersaleRestApi.auditCancel(Lang.filterNullMap(map, (Boolean)false));
            AuditCancelResp auditCancelResp = (AuditCancelResp)call.execute().body();
            HashMap<String, AuditCancelResp> returnMap = new HashMap<String, AuditCancelResp>();
            returnMap.put("response", auditCancelResp);
            return auditCancelResp;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

