/*
 * Decompiled with CFR 0.152.
 */
package jd.service.jdapi.order;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import java.util.HashMap;
import java.util.Map;
import jd.api.request.order.CheckOrderEntity;
import jd.api.request.order.JdOrderIdEntity;
import jd.api.request.order.OrderBalanceEntity;
import jd.api.request.order.OrderEntity;
import jd.api.request.order.OrderFreightEntity;
import jd.api.request.order.ThirdOrder;
import jd.api.response.order.CheckOrderResp;
import jd.api.response.order.OccupyStockResp;
import jd.api.response.order.OrderBalanceResp;
import jd.api.response.order.OrderFreightResp;
import jd.api.response.order.OrderRevResp;
import jd.api.response.order.OrderSplitResp;
import jd.api.response.order.OrderTrackResp;
import jd.api.response.order.OrderUniteSubmitResp;
import jd.api.service.order.JdOrderApi;
import jd.service.jdapi.token.TokenService;
import jd.service.retrofit.api.JdOrderRestApi;
import jd.service.service.JdSystemLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import retrofit2.Call;
import retrofit2.Retrofit;
import sinomall.global.common.vo.outsideapi.OrderCancelOrderResp;
import utils.Lang;
import utils.convert.converters.map.ObjectToMapConverter;

@MotanService
public class JdOrderApiImpl
implements JdOrderApi {
    private Retrofit retrofit;
    private JdOrderRestApi jdOrderRestApi;
    private TokenService tokenService;
    public static final Logger logger = LoggerFactory.getLogger(JdOrderApiImpl.class);
    @Autowired
    JdSystemLogService jdSystemLogService;

    public JdOrderApiImpl(TokenService tokenService, Retrofit retrofit) {
        this.tokenService = tokenService;
        this.retrofit = retrofit;
        this.jdOrderRestApi = (JdOrderRestApi)this.retrofit.create(JdOrderRestApi.class);
    }

    public OrderUniteSubmitResp placeOrder(OrderEntity orderEntity) {
        try {
            ObjectToMapConverter converter = new ObjectToMapConverter();
            Map map = (Map)converter.convert((Object)orderEntity, HashMap.class, new Object[0]);
            map.put("token", this.tokenService.accessToken());
            map.put("sku", JSON.toJSONString((Object)orderEntity.getSku()));
            Call call = this.jdOrderRestApi.submitOrder(Lang.filterNullMap((Map)map, (Boolean)false));
            OrderUniteSubmitResp orderUniteSubmitResp = (OrderUniteSubmitResp)call.execute().body();
            HashMap<String, OrderUniteSubmitResp> returnMap = new HashMap<String, OrderUniteSubmitResp>();
            returnMap.put("response", orderUniteSubmitResp);
            this.jdSystemLogService.asyncSysLog(call.request().url().toString(), (Object)JSONObject.toJSONString((Object)map), (Object)JSONObject.toJSONString(returnMap), null, null);
            return orderUniteSubmitResp;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public OccupyStockResp confirmOccupyStock(JdOrderIdEntity jdOrderIdEntity) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("token", this.tokenService.accessToken());
            map.put("jdOrderId", jdOrderIdEntity.getJdOrderId());
            Call call = this.jdOrderRestApi.confirmOrder(Lang.filterNullMap(map, (Boolean)false));
            OccupyStockResp occupyStockResp = (OccupyStockResp)call.execute().body();
            HashMap<String, OccupyStockResp> returnMap = new HashMap<String, OccupyStockResp>();
            returnMap.put("response", occupyStockResp);
            this.jdSystemLogService.asyncSysLog(call.request().url().toString(), (Object)JSONObject.toJSONString(map), (Object)JSONObject.toJSONString(returnMap), null, null);
            return occupyStockResp;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public OrderCancelOrderResp cancelOrder(JdOrderIdEntity jdOrderIdEntity) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("token", this.tokenService.accessToken());
            map.put("jdOrderId", jdOrderIdEntity.getJdOrderId());
            Call call = this.jdOrderRestApi.cancel(Lang.filterNullMap(map, (Boolean)false));
            OrderCancelOrderResp orderCancelOrderResp = (OrderCancelOrderResp)call.execute().body();
            HashMap<String, OrderCancelOrderResp> returnMap = new HashMap<String, OrderCancelOrderResp>();
            returnMap.put("response", orderCancelOrderResp);
            this.jdSystemLogService.asyncSysLog(call.request().url().toString(), (Object)JSONObject.toJSONString(map), (Object)JSONObject.toJSONString(returnMap), null, null);
            return orderCancelOrderResp;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Map<String, Object> queryOrder(JdOrderIdEntity jdOrderIdEntity) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("token", this.tokenService.accessToken());
            map.put("jdOrderId", jdOrderIdEntity.getJdOrderId());
            Call call = this.jdOrderRestApi.selectJdOrder(Lang.filterNullMap(map, (Boolean)false));
            Map returnMap = ((OrderSplitResp)call.execute().body()).getResult();
            this.jdSystemLogService.asyncSysLog(call.request().url().toString(), (Object)JSONObject.toJSONString(map), (Object)JSONObject.toJSONString((Object)returnMap), null, null);
            return returnMap;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog("api/order/selectJdOrder", (Object)("" + JSON.toJSONString((Object)jdOrderIdEntity)), (Object)("" + Lang.toString((Object)e)), null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public OrderFreightResp queryFreight(OrderFreightEntity orderFreightEntity) {
        try {
            ObjectToMapConverter converter = new ObjectToMapConverter();
            Map map = (Map)converter.convert((Object)orderFreightEntity, HashMap.class, new Object[0]);
            map.put("token", this.tokenService.accessToken());
            map.put("sku", JSON.toJSONString((Object)orderFreightEntity.getSku()));
            Call call = this.jdOrderRestApi.getFreight(Lang.filterNullMap((Map)map, (Boolean)false));
            OrderFreightResp orderFreightResp = (OrderFreightResp)call.execute().body();
            HashMap<String, OrderFreightResp> returnMap = new HashMap<String, OrderFreightResp>();
            returnMap.put("response", orderFreightResp);
            this.jdSystemLogService.asyncSysLog(call.request().url().toString(), (Object)JSONObject.toJSONString((Object)map), (Object)JSONObject.toJSONString(returnMap), null, null);
            logger.info("orderFreightResp:{}", (Object)JSON.toJSONString((Object)orderFreightResp));
            return orderFreightResp;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public OrderRevResp queryOrderByThirdOrder(ThirdOrder thirdOrder) {
        try {
            ObjectToMapConverter converter = new ObjectToMapConverter();
            Map map = (Map)converter.convert((Object)thirdOrder, HashMap.class, new Object[0]);
            map.put("token", this.tokenService.accessToken());
            Call call = this.jdOrderRestApi.selectJdOrderIdByThirdOrder(Lang.filterNullMap((Map)map, (Boolean)false));
            OrderRevResp orderRevResp = (OrderRevResp)call.execute().body();
            HashMap<String, OrderRevResp> returnMap = new HashMap<String, OrderRevResp>();
            returnMap.put("response", orderRevResp);
            this.jdSystemLogService.asyncSysLog(call.request().url().toString(), (Object)JSONObject.toJSONString((Object)map), (Object)JSONObject.toJSONString(returnMap), null, null);
            return orderRevResp;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public OrderTrackResp queryOrderTrack(JdOrderIdEntity jdOrderIdEntity) {
        try {
            long methodStart = System.currentTimeMillis();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("token", this.tokenService.accessToken());
            map.put("jdOrderId", jdOrderIdEntity.getJdOrderId());
            Call call = this.jdOrderRestApi.orderTrack(Lang.filterNullMap(map, (Boolean)false));
            OrderTrackResp orderTrackResp = (OrderTrackResp)call.execute().body();
            HashMap<String, OrderTrackResp> returnMap = new HashMap<String, OrderTrackResp>();
            returnMap.put("response", orderTrackResp);
            logger.info("\u4eac\u4e1c\u7269\u6d41\u63a5\u53e3\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - methodStart));
            return orderTrackResp;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Map<String, Object> getBalance(OrderBalanceEntity orderBalanceEntity) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("token", this.tokenService.accessToken());
            map.put("payType", orderBalanceEntity.getPayType());
            Call call = this.jdOrderRestApi.getBalance(Lang.filterNullMap(map, (Boolean)false));
            String result = ((OrderBalanceResp)call.execute().body()).getResult();
            HashMap<String, Object> returnMap = new HashMap<String, Object>();
            returnMap.put("result", result);
            return returnMap;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public CheckOrderResp checkNewOrder(CheckOrderEntity checkOrderEntity) {
        try {
            ObjectToMapConverter converter = new ObjectToMapConverter();
            Map map = (Map)converter.convert((Object)checkOrderEntity, HashMap.class, new Object[0]);
            map.put("token", this.tokenService.accessToken());
            Call call = this.jdOrderRestApi.checkNewOrder(Lang.filterNullMap((Map)map, (Boolean)false));
            CheckOrderResp checkOrderResp = (CheckOrderResp)call.execute().body();
            HashMap<String, CheckOrderResp> returnMap = new HashMap<String, CheckOrderResp>();
            returnMap.put("response", checkOrderResp);
            return checkOrderResp;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public CheckOrderResp checkDlokOrder(CheckOrderEntity checkOrderEntity) {
        try {
            ObjectToMapConverter converter = new ObjectToMapConverter();
            Map map = (Map)converter.convert((Object)checkOrderEntity, HashMap.class, new Object[0]);
            map.put("token", this.tokenService.accessToken());
            Call call = this.jdOrderRestApi.checkDlokOrder(Lang.filterNullMap((Map)map, (Boolean)false));
            CheckOrderResp checkOrderResp = (CheckOrderResp)call.execute().body();
            HashMap<String, CheckOrderResp> returnMap = new HashMap<String, CheckOrderResp>();
            returnMap.put("response", checkOrderResp);
            return checkOrderResp;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public CheckOrderResp checkRefuseOrder(CheckOrderEntity checkOrderEntity) {
        try {
            ObjectToMapConverter converter = new ObjectToMapConverter();
            Map map = (Map)converter.convert((Object)checkOrderEntity, HashMap.class, new Object[0]);
            map.put("token", this.tokenService.accessToken());
            Call call = this.jdOrderRestApi.checkRefuseOrder(Lang.filterNullMap((Map)map, (Boolean)false));
            CheckOrderResp checkOrderResp = (CheckOrderResp)call.execute().body();
            HashMap<String, CheckOrderResp> returnMap = new HashMap<String, CheckOrderResp>();
            returnMap.put("response", checkOrderResp);
            return checkOrderResp;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

