/*
 * Decompiled with CFR 0.152.
 */
package jd.service.jdapi.product;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import goods.api.GoodsApi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jd.api.request.product.CategoryEntity;
import jd.api.request.product.CategorysEntity;
import jd.api.request.product.MessageDelEntity;
import jd.api.request.product.MessageTypeEntity;
import jd.api.request.product.PageNumEntity;
import jd.api.request.product.ProductDetailEntity;
import jd.api.request.product.SkuEntity;
import jd.api.request.product.SkuIdsAndAreaEntity;
import jd.api.request.product.StockForOrderEntity;
import jd.api.response.core.CommonResponse;
import jd.api.response.product.CategoryResp;
import jd.api.response.product.CategorysResp;
import jd.api.response.product.MessageDelResp;
import jd.api.response.product.MessageGetResp;
import jd.api.response.product.PriceResp;
import jd.api.response.product.ProductCheckResp;
import jd.api.response.product.ProductCommentSummarysResp;
import jd.api.response.product.ProductDetailResp;
import jd.api.response.product.ProductPoolProductResp;
import jd.api.response.product.ProductPoolResp;
import jd.api.response.product.ProductSkuImageResp;
import jd.api.response.product.ProductStateResp;
import jd.api.response.product.SkuIdsAndAreaNewResp;
import jd.api.response.product.StockForOrderNewResp;
import jd.api.service.product.JdProductApi;
import jd.api.vo.product.MessageGetVO;
import jd.api.vo.product.PriceVO;
import jd.api.vo.product.ProductCommentSummarysVO;
import jd.api.vo.product.ProductDetailVO;
import jd.api.vo.product.ProductPoolVO;
import jd.api.vo.product.ProductSkuImageVO;
import jd.api.vo.product.ProductStateVO;
import jd.api.vo.product.SimilarProduct;
import jd.api.vo.product.SkuIdsAndAreaVO;
import jd.api.vo.product.StockNewResultVo;
import jd.dto.StockStateDto;
import jd.model.stock.StockState;
import jd.model.stock.StockStateDao;
import jd.service.jdapi.token.TokenService;
import jd.service.retrofit.api.JdProductRestApi;
import jd.service.service.JdSystemLogService;
import jd.service.service.ProductDbInitService;
import jd.service.service.ProductTransactionalService;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import retrofit2.Call;
import retrofit2.Retrofit;
import utils.Lang;
import utils.convert.converters.map.ObjectToMapConverter;

@MotanService
public class JdProductApiImpl
implements JdProductApi {
    private Retrofit retrofit;
    private JdProductRestApi jdProductRestApi;
    private TokenService tokenService;
    @MotanReferer
    GoodsApi goodsApi;
    @Autowired
    MapperFacade mapperFacade;
    public static final Logger logger = LoggerFactory.getLogger(JdProductApiImpl.class);
    @Autowired
    JdSystemLogService jdSystemLogService;
    @Autowired
    StockStateDao stockStateDao;
    @Autowired
    ProductDbInitService productDbInitService;
    @Autowired
    ProductTransactionalService productTransactionalService;

    public JdProductApiImpl(TokenService tokenService, Retrofit retrofit) {
        this.tokenService = tokenService;
        this.retrofit = retrofit;
        this.jdProductRestApi = (JdProductRestApi)this.retrofit.create(JdProductRestApi.class);
    }

    public List<ProductPoolVO> getProductPool() {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("token", this.tokenService.accessToken());
            Call call = this.jdProductRestApi.getPageNum(Lang.filterNullMap(map, (Boolean)false));
            ProductPoolResp body = (ProductPoolResp)call.execute().body();
            HashMap<String, ProductPoolResp> returnMap = new HashMap<String, ProductPoolResp>();
            returnMap.put("response", body);
            return body.getResult();
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<Long> getProductPoolProduct(PageNumEntity pageNumEntity) {
        try {
            ObjectToMapConverter converter = new ObjectToMapConverter();
            Map map = (Map)converter.convert((Object)pageNumEntity, HashMap.class, new Object[0]);
            map.put("token", this.tokenService.accessToken());
            Call call = this.jdProductRestApi.getSku(Lang.filterNullMap((Map)map, (Boolean)false));
            ProductPoolProductResp body = (ProductPoolProductResp)call.execute().body();
            HashMap<String, ProductPoolProductResp> returnMap = new HashMap<String, ProductPoolProductResp>();
            returnMap.put("response", body);
            String[] goodsNos = null;
            ArrayList<Long> goodsList = new ArrayList<Long>();
            if (!Lang.isEmpty((Object)body) && !Lang.isEmpty((Object)body.getResult())) {
                for (String goodsNo : goodsNos = body.getResult().split(",")) {
                    goodsList.add(Long.valueOf(goodsNo));
                }
            }
            return goodsList;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getProductPoolProductResult(PageNumEntity pageNumEntity) {
        try {
            ObjectToMapConverter converter = new ObjectToMapConverter();
            Map map = (Map)converter.convert((Object)pageNumEntity, HashMap.class, new Object[0]);
            map.put("token", this.tokenService.accessToken());
            Call call = this.jdProductRestApi.getSkuByPage(Lang.filterNullMap((Map)map, (Boolean)false));
            ProductPoolProductResp body = (ProductPoolProductResp)call.execute().body();
            HashMap<String, ProductPoolProductResp> returnMap = new HashMap<String, ProductPoolProductResp>();
            returnMap.put("response", body);
            return body.getResult();
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<Long> getProductPoolProductOld(PageNumEntity pageNumEntity) {
        String result = this.getProductPoolProductResult(pageNumEntity);
        Object goodsNos = null;
        ArrayList<Long> goodsList = new ArrayList<Long>();
        if (!Lang.isEmpty((Object)result)) {
            JSONObject object = JSONObject.parseObject((String)result);
            JSONArray skuIds = object.getJSONArray("skuIds");
            Integer pageCount = object.getInteger("pageCount");
            for (int i = 0; i < skuIds.size(); ++i) {
                Object obj = skuIds.get(i);
                goodsList.add(Long.valueOf(obj.toString()));
            }
            Integer pageNo = pageNumEntity.getPageNo();
            while (pageNo <= pageCount) {
                Integer obj = pageNo;
                Integer n = pageNo = Integer.valueOf(pageNo + 1);
                pageNumEntity.setPageNo(pageNo);
                result = this.getProductPoolProductResult(pageNumEntity);
                if (Lang.isEmpty((Object)result)) continue;
                object = JSONObject.parseObject((String)result);
                skuIds = object.getJSONArray("skuIds");
                for (int i = 0; i < skuIds.size(); ++i) {
                    Object obj2 = skuIds.get(i);
                    goodsList.add(Long.valueOf(obj2.toString()));
                }
            }
        }
        return goodsList;
    }

    public ProductDetailVO getProductDetail(ProductDetailEntity productDetailEntity) {
        try {
            ObjectToMapConverter converter = new ObjectToMapConverter();
            Map map = (Map)converter.convert((Object)productDetailEntity, HashMap.class, new Object[0]);
            map.put("token", this.tokenService.accessToken());
            Call call = this.jdProductRestApi.getDetail(Lang.filterNullMap((Map)map, (Boolean)false));
            ProductDetailVO productDetailVO = ((ProductDetailResp)call.execute().body()).getResult();
            HashMap<String, ProductDetailVO> returnMap = new HashMap<String, ProductDetailVO>();
            returnMap.put("response", productDetailVO);
            return productDetailVO;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<ProductStateVO> getProductState(List<Long> skus) {
        try {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < skus.size(); ++i) {
                if (i == 0) {
                    sb.append(skus.get(i));
                    continue;
                }
                sb.append(",").append(skus.get(i));
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("token", this.tokenService.accessToken());
            map.put("sku", sb.toString());
            Call call = this.jdProductRestApi.skuState(Lang.filterNullMap(map, (Boolean)false));
            List productDetailVOs = ((ProductStateResp)call.execute().body()).getResult();
            HashMap<String, List> returnMap = new HashMap<String, List>();
            returnMap.put("response", productDetailVOs);
            return productDetailVOs;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Map<Long, List<ProductSkuImageVO>> getProductSkuImage(List<Long> skus) {
        try {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < skus.size(); ++i) {
                if (i == 0) {
                    sb.append(skus.get(i));
                    continue;
                }
                sb.append(",").append(skus.get(i));
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("token", this.tokenService.accessToken());
            map.put("sku", sb.toString());
            Call call = this.jdProductRestApi.skuImage(Lang.filterNullMap(map, (Boolean)false));
            Map returnMap = ((ProductSkuImageResp)call.execute().body()).getResult();
            return returnMap;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<ProductCommentSummarysVO> getProductCommentSummarys(List<Long> skus) {
        try {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < skus.size(); ++i) {
                if (i == 0) {
                    sb.append(skus.get(i));
                    continue;
                }
                sb.append(",").append(skus.get(i));
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("token", this.tokenService.accessToken());
            map.put("sku", sb.toString());
            Call call = this.jdProductRestApi.getCommentSummarys(Lang.filterNullMap(map, (Boolean)false));
            List productCommentSummarysVOs = ((ProductCommentSummarysResp)call.execute().body()).getResult();
            HashMap<String, List> returnMap = new HashMap<String, List>();
            returnMap.put("response", productCommentSummarysVOs);
            return productCommentSummarysVOs;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<SkuIdsAndAreaVO> getProductLimit(SkuIdsAndAreaEntity skuIdsAndAreaEntity) {
        try {
            ObjectToMapConverter converter = new ObjectToMapConverter();
            Map map = (Map)converter.convert((Object)skuIdsAndAreaEntity, HashMap.class, new Object[0]);
            map.put("token", this.tokenService.accessToken());
            Call call = this.jdProductRestApi.checkAreaLimit(Lang.filterNullMap((Map)map, (Boolean)false));
            List skuIdsAndAreaVOs = ((SkuIdsAndAreaNewResp)call.execute().body()).getResult();
            HashMap<String, List> returnMap = new HashMap<String, List>();
            returnMap.put("response", skuIdsAndAreaVOs);
            return skuIdsAndAreaVOs;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Boolean getProductIsCod(SkuIdsAndAreaEntity skuIdsAndAreaEntity) {
        try {
            ObjectToMapConverter converter = new ObjectToMapConverter();
            Map map = (Map)converter.convert((Object)skuIdsAndAreaEntity, HashMap.class, new Object[0]);
            map.put("token", this.tokenService.accessToken());
            Call call = this.jdProductRestApi.getIsCod(Lang.filterNullMap((Map)map, (Boolean)false));
            Boolean isCod = (Boolean)((CommonResponse)call.execute().body()).getResult();
            HashMap<String, Boolean> returnMap = new HashMap<String, Boolean>();
            returnMap.put("response", isCod);
            return isCod;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public ProductCheckResp getSkuCheck(List<Long> skus) {
        try {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < skus.size(); ++i) {
                if (i == 0) {
                    sb.append(skus.get(i));
                    continue;
                }
                sb.append(",").append(skus.get(i));
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("token", this.tokenService.accessToken());
            map.put("skuIds", sb.toString());
            Call call = this.jdProductRestApi.check(Lang.filterNullMap(map, (Boolean)false));
            ProductCheckResp productCheckResp = (ProductCheckResp)call.execute().body();
            HashMap<String, ProductCheckResp> returnMap = new HashMap<String, ProductCheckResp>();
            returnMap.put("response", productCheckResp);
            return productCheckResp;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<SimilarProduct> getSimilarProduct(String skuId) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("skuId", skuId);
            map.put("token", this.tokenService.accessToken());
            Call call = this.jdProductRestApi.getSimilarSku(Lang.filterNullMap(map, (Boolean)false));
            return (List)((CommonResponse)call.execute().body()).getResult();
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<PriceVO> getPrice(SkuEntity skuEntity) {
        try {
            ObjectToMapConverter converter = new ObjectToMapConverter();
            Map map = (Map)converter.convert((Object)skuEntity, HashMap.class, new Object[0]);
            map.put("token", this.tokenService.accessToken());
            Call call = this.jdProductRestApi.getSellPrice(Lang.filterNullMap((Map)map, (Boolean)false));
            List priceVOs = ((PriceResp)call.execute().body()).getResult();
            HashMap<String, List> returnMap = new HashMap<String, List>();
            returnMap.put("response", priceVOs);
            return priceVOs;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<StockNewResultVo> getStockForOrder(StockForOrderEntity stockForOrderEntity) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("token", this.tokenService.accessToken());
            map.put("area", stockForOrderEntity.getArea());
            map.put("skuNums", JSON.toJSONString((Object)stockForOrderEntity.getSkuNums()));
            Call call = this.jdProductRestApi.getNewStockById(Lang.filterNullMap(map, (Boolean)false));
            String result = ((StockForOrderNewResp)call.execute().body()).getResult();
            List stockNewResultVos = JSON.parseArray((String)result, StockNewResultVo.class);
            HashMap<String, List> returnMap = new HashMap<String, List>();
            returnMap.put("response", stockNewResultVos);
            return stockNewResultVos;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<MessageGetVO> getMessage(MessageTypeEntity messageTypeEntity) {
        try {
            ObjectToMapConverter converter = new ObjectToMapConverter();
            Map map = (Map)converter.convert((Object)messageTypeEntity, HashMap.class, new Object[0]);
            map.put("token", this.tokenService.accessToken());
            Call call = this.jdProductRestApi.get(Lang.filterNullMap((Map)map, (Boolean)false));
            List messageGetVOs = ((MessageGetResp)call.execute().body()).getResult();
            HashMap<String, List> returnMap = new HashMap<String, List>();
            returnMap.put("response", messageGetVOs);
            return messageGetVOs;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Boolean delMessage(MessageDelEntity messageDelEntity) {
        try {
            ObjectToMapConverter converter = new ObjectToMapConverter();
            Map map = (Map)converter.convert((Object)messageDelEntity, HashMap.class, new Object[0]);
            map.put("token", this.tokenService.accessToken());
            Call call = this.jdProductRestApi.del(Lang.filterNullMap((Map)map, (Boolean)false));
            Boolean isDel = ((MessageDelResp)call.execute().body()).getResult();
            HashMap<String, Boolean> returnMap = new HashMap<String, Boolean>();
            returnMap.put("response", isDel);
            return isDel;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public CategoryResp getCategory(CategoryEntity categoryEntity) {
        try {
            ObjectToMapConverter converter = new ObjectToMapConverter();
            Map map = (Map)converter.convert((Object)categoryEntity, HashMap.class, new Object[0]);
            map.put("token", this.tokenService.accessToken());
            Call call = this.jdProductRestApi.getCategory(Lang.filterNullMap((Map)map, (Boolean)false));
            CategoryResp categoryResp = (CategoryResp)call.execute().body();
            HashMap<String, CategoryResp> returnMap = new HashMap<String, CategoryResp>();
            returnMap.put("response", categoryResp);
            return categoryResp;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public CategorysResp getCategorys(CategorysEntity categorysEntity) {
        try {
            ObjectToMapConverter converter = new ObjectToMapConverter();
            Map map = (Map)converter.convert((Object)categorysEntity, HashMap.class, new Object[0]);
            map.put("token", this.tokenService.accessToken());
            Call call = this.jdProductRestApi.getCategorys(Lang.filterNullMap((Map)map, (Boolean)false));
            CategorysResp categorysResp = (CategorysResp)call.execute().body();
            HashMap<String, CategorysResp> returnMap = new HashMap<String, CategorysResp>();
            returnMap.put("response", categorysResp);
            return categorysResp;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String addJdGood(Long sku) {
        List goodsIds = this.productTransactionalService.addGoods(sku);
        return goodsIds == null || goodsIds.size() <= 0 ? null : (String)goodsIds.get(0);
    }

    public void refreshCtStock() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public List<StockStateDto> findBySku(String sku) {
        Long skuId = Long.parseLong(sku);
        return this.mapperFacade.mapAsList((Iterable)this.stockStateDao.findBySkuId(skuId), StockStateDto.class);
    }

    public void save(StockStateDto stockState) {
        this.stockStateDao.save(this.mapperFacade.map((Object)stockState, StockState.class));
    }

    public void executorsPoolAdd(List<Long> productNosList, int totalNum, Boolean isThread, Integer poolSize) {
        this.productDbInitService.executorsPoolAdd(productNosList, totalNum, isThread, poolSize);
    }

    public Map addProdBySkus(Map resMap, String skus) {
        return this.productDbInitService.addProdBySkus(resMap, skus);
    }
}

