/*
 * Decompiled with CFR 0.152.
 */
package jd.service.jdapi.token;

import com.alibaba.fastjson.JSON;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import jd.service.jdapi.token.TokenResponse;
import jd.service.jdapi.token.TokenVO;
import jd.service.jdapi.token.UserEntity;
import jd.service.retrofit.api.AbstractJdApi;
import jd.service.retrofit.api.JDAuthApi;
import jd.service.retrofit.config.RetrofitConfigVo;
import jd.service.retrofit.converter.BeanToMapUtil;
import jd.service.service.JdSystemLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;
import utils.Lang;
import utils.security.MD5Utils;

@Service
public class TokenService
extends AbstractJdApi {
    private static final Logger logger = LoggerFactory.getLogger(TokenService.class);
    private Retrofit retrofit;
    public final String accessTokenStr = "szjdapi:jdTokenData";
    private JDAuthApi jdAuthApi;
    private volatile TokenVO tokenVO = null;
    @Autowired
    RetrofitConfigVo retrofitConfigVo;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    JdSystemLogService jdSystemLogService;

    public void setTokenVO(TokenVO tokenVO) {
        this.tokenVO = tokenVO;
    }

    @PostConstruct
    private void inited() {
        logger.info("JD access token :{}", (Object)this.getToken(false));
    }

    public TokenService(@Value(value="${retrofit.tokenUrl}") String tokenUrl) {
        this.retrofit = new Retrofit.Builder().baseUrl(tokenUrl).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build();
        this.jdAuthApi = (JDAuthApi)this.retrofit.create(JDAuthApi.class);
    }

    public String accessToken() {
        return this.getToken(false).getAccess_token();
    }

    public TokenVO getToken(boolean force) {
        String tokenKey = "szjdapi:jdTokenData" + this.retrofitConfigVo.getUserEntity().getUsername();
        BoundValueOperations accessTokenOp = this.redisTemplate.boundValueOps((Object)tokenKey);
        if (!force) {
            if (this.tokenVO != null) {
                return this.tokenVO;
            }
            String tokenData = (String)accessTokenOp.get();
            if (tokenData == null || "".equals(tokenData.trim())) {
                TokenVO tokenVO = this.getTokenVO(this.retrofitConfigVo.getUserEntity());
                if (tokenVO != null) {
                    accessTokenOp.set((Object)JSON.toJSONString((Object)tokenVO));
                }
                this.tokenVO = tokenVO;
            } else {
                try {
                    this.tokenVO = (TokenVO)JSON.parseObject((String)tokenData, TokenVO.class);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        } else {
            TokenVO tokenVO = this.getTokenVO(this.retrofitConfigVo.getUserEntity());
            if (tokenVO != null) {
                accessTokenOp.set((Object)JSON.toJSONString((Object)tokenVO));
                this.redisTemplate.expire((Object)tokenKey.toString(), 10L, TimeUnit.MINUTES);
                this.tokenVO = tokenVO;
            }
        }
        return this.tokenVO;
    }

    private TokenVO getTokenVO(UserEntity user) {
        try {
            user.setTimestamp(((DateFormat)this.sdf.get()).format(new Date()));
            user.setSign(this.createSign(user));
            Map map = BeanToMapUtil.convertBean((Object)user);
            Call response = this.jdAuthApi.accessToken(Lang.filterNullMap((Map)map, (Boolean)false));
            TokenVO token = null;
            if (response != null) {
                TokenResponse body = (TokenResponse)response.execute().body();
                logger.info("getTokenVO {}", (Object)JSON.toJSONString((Object)body.getResult()));
                token = body.getResult();
            }
            return token;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public TokenVO refreshToken() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("refresh_token", this.tokenVO.getRefresh_token());
        map.put("client_id", this.retrofitConfigVo.getUserEntity().getClient_id());
        map.put("client_secret", this.retrofitConfigVo.getUserEntity().getClient_secret());
        String tokenKey = "szjdapi:jdTokenData" + this.retrofitConfigVo.getUserEntity().getUsername();
        Call call = this.jdAuthApi.refreshToken(map);
        try {
            TokenResponse body = (TokenResponse)call.execute().body();
            this.tokenVO = body.getResult();
            BoundValueOperations accessTokenOp = this.redisTemplate.boundValueOps((Object)tokenKey);
            accessTokenOp.set((Object)JSON.toJSONString((Object)this.tokenVO));
            this.redisTemplate.expire((Object)tokenKey.toString(), 10L, TimeUnit.MINUTES);
            logger.info("refreshToken {}", (Object)JSON.toJSONString((Object)body.getResult()));
            return this.tokenVO;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String createSign(UserEntity user) {
        String username = user.getUsername();
        String password = user.getPassword();
        String timestamp = user.getTimestamp();
        String clientSecret = user.getClient_secret();
        String clientId = user.getClient_id();
        String sign = clientSecret + timestamp + clientId + username + password + "access_token" + clientSecret;
        return MD5Utils.MD5Encode((String)sign, (String)"utf-8").toUpperCase();
    }
}

