/*
 * Decompiled with CFR 0.152.
 */
package jd.service.retrofit.config;

import java.util.concurrent.TimeUnit;
import jd.service.jdapi.token.TokenService;
import jd.service.retrofit.config.RetrofitConfigVo;
import jd.service.retrofit.converter.FastJsonConverterFactory;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import retrofit2.Converter;
import retrofit2.Retrofit;

@Configuration
@ComponentScan(value={"jdek.service"})
public class RetrofitConfig {
    private static final Logger okhttpLogger = LoggerFactory.getLogger((String)"retrofitLog");

    @ConfigurationProperties(prefix="retrofit")
    @Bean
    RetrofitConfigVo retrofitConfigVo() {
        return new RetrofitConfigVo();
    }

    @Bean
    public Retrofit retrofit(TokenService tokenService) {
        RetrofitConfigVo retrofitConfigVo = this.retrofitConfigVo();
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (retrofitConfigVo.getLogRequest().booleanValue()) {
            builder.addInterceptor((Interceptor)new /* Unavailable Anonymous Inner Class!! */);
        }
        builder.connectTimeout(60L, TimeUnit.SECONDS);
        builder.readTimeout(60L, TimeUnit.SECONDS);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(retrofitConfigVo.getBaseUrl()).addConverterFactory((Converter.Factory)FastJsonConverterFactory.create()).client(builder.build()).build();
        return retrofit;
    }

    static /* synthetic */ Logger access$000() {
        return okhttpLogger;
    }
}

