/*
 * Decompiled with CFR 0.152.
 */
package jd.service.service;

import cms.model.Organization;
import cms.model.repository.OrganizationRepos;
import goods.model.Goods;
import goods.model.ProductCategory;
import goods.model.ProductCategoryConfig;
import goods.model.repository.GoodsRepos;
import goods.model.repository.ProductCategoryConfigRepos;
import goods.model.repository.ProductCategoryExtTaxRateRepos;
import goods.model.repository.ProductCategoryRepos;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jd.api.request.product.CategoryEntity;
import jd.api.request.product.CategorysEntity;
import jd.api.request.product.ProductDetailEntity;
import jd.api.response.product.CategoryResp;
import jd.api.response.product.CategorysResp;
import jd.api.service.product.JdProductApi;
import jd.api.vo.product.CategoryVO;
import jd.api.vo.product.ProductDetailVO;
import jd.service.service.CategoryDbService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import utils.Lang;
import utils.log.Log;
import utils.log.Logs;

@Service
public class CategoryDbService {
    Log logger = Logs.getLog((String)CategoryDbService.class.getName());
    @Autowired
    JdProductApi jdProductApi;
    @Autowired
    ProductCategoryRepos productCategoryRepos;
    @Autowired
    GoodsRepos goodsRepos;
    @Autowired
    OrganizationRepos organizationRepos;
    @Autowired
    ProductCategoryConfigRepos productCategoryConfigRepos;
    @Value(value="${jd.store.code}")
    private String jdCode;
    @Value(value="${jd.store.id}")
    private String jdId;
    @Autowired
    ProductCategoryExtTaxRateRepos productCategoryExtTaxRateRepos;

    public void initCategory() {
        List categoryOneVOs = this.queryCategorysByCatclass(0, 100);
        if (categoryOneVOs != null) {
            for (CategoryVO categoryOneVO : categoryOneVOs) {
                ProductCategory categoryOne = new ProductCategory();
                categoryOne.setState(categoryOneVO.getState());
                categoryOne.setCode(categoryOneVO.getCatId());
                categoryOne.setLayerIndex(Integer.valueOf(categoryOneVO.getCatClass() + 1));
                categoryOne.setName(categoryOneVO.getName());
                categoryOne.setTplChannel(this.jdCode);
                categoryOne.setSourceCode(this.jdCode);
                this.productCategoryRepos.saveAndFlush((Object)categoryOne);
                List categoryTwoVOs = this.queryCategorysByParentId(categoryOneVO.getCatId().intValue(), 100);
                if (categoryTwoVOs == null) continue;
                for (CategoryVO categoryTwoVO : categoryTwoVOs) {
                    ProductCategory categoryTwo = new ProductCategory();
                    categoryTwo.setParent(categoryOne);
                    categoryTwo.setState(categoryTwoVO.getState());
                    categoryTwo.setCode(categoryTwoVO.getCatId());
                    categoryTwo.setLayerIndex(Integer.valueOf(categoryTwoVO.getCatClass() + 1));
                    categoryTwo.setName(categoryTwoVO.getName());
                    categoryTwo.setTplChannel(this.jdCode);
                    categoryTwo.setSourceCode(this.jdCode);
                    this.productCategoryRepos.saveAndFlush((Object)categoryTwo);
                    List categoryThreeVOs = this.queryCategorysByParentId(categoryTwoVO.getCatId().intValue(), 100);
                    if (categoryThreeVOs == null) continue;
                    for (CategoryVO categoryThreeVO : categoryThreeVOs) {
                        ProductCategory categoryThree = new ProductCategory();
                        categoryThree.setParent(categoryTwo);
                        categoryThree.setState(categoryThreeVO.getState());
                        categoryThree.setCode(categoryThreeVO.getCatId());
                        categoryThree.setLayerIndex(Integer.valueOf(categoryThreeVO.getCatClass() + 1));
                        categoryThree.setName(categoryThreeVO.getName());
                        categoryThree.setTplChannel(this.jdCode);
                        categoryThree.setSourceCode(this.jdCode);
                        this.productCategoryRepos.saveAndFlush((Object)categoryThree);
                    }
                }
            }
        }
    }

    public List<CategoryVO> queryCategorysByCatclass(int catClass, int pageSize) {
        CategorysResp categorysResp = this.jdProductApi.getCategorys(new CategorysEntity(Integer.valueOf(1), Integer.valueOf(pageSize), null, Integer.valueOf(catClass)));
        List categoryVOs = null;
        if (categorysResp != null && categorysResp.getResult().getCategorys().size() > 0) {
            categoryVOs = categorysResp.getResult().getCategorys();
            Integer totalRows = categorysResp.getResult().getTotalRows();
            Integer totalPage = totalRows % pageSize == 0 ? totalRows / pageSize : totalRows / pageSize + 1;
            for (int i = 2; i <= totalPage; ++i) {
                categorysResp = this.jdProductApi.getCategorys(new CategorysEntity(Integer.valueOf(i), Integer.valueOf(100), null, Integer.valueOf(catClass)));
                categoryVOs.addAll(categorysResp.getResult().getCategorys());
            }
        }
        return categoryVOs;
    }

    public List<CategoryVO> queryCategorysByParentId(int parentId, int pageSize) {
        CategorysResp categorysResp = this.jdProductApi.getCategorys(new CategorysEntity(Integer.valueOf(1), Integer.valueOf(pageSize), Integer.valueOf(parentId), null));
        List categoryVOs = null;
        if (categorysResp != null && categorysResp.getResult().getCategorys().size() > 0) {
            categoryVOs = categorysResp.getResult().getCategorys();
            Integer totalRows = categorysResp.getResult().getTotalRows();
            Integer totalPage = totalRows % pageSize == 0 ? totalRows / pageSize : totalRows / pageSize + 1;
            for (int i = 2; i <= totalPage; ++i) {
                categorysResp = this.jdProductApi.getCategorys(new CategorysEntity(Integer.valueOf(i), Integer.valueOf(pageSize), Integer.valueOf(parentId), null));
                categoryVOs.addAll(categorysResp.getResult().getCategorys());
            }
        }
        return categoryVOs;
    }

    public Map restAllProdCateGory() {
        long queryPageSize = 100L;
        this.logger.info((Object)"Start restAllProdCateGory....");
        PageRequest pageable = new PageRequest(0, (int)queryPageSize);
        1 specification = new /* Unavailable Anonymous Inner Class!! */;
        Object goodsPage = null;
        Object skus = null;
        long totalCount = 0L;
        while ((totalCount = this.goodsRepos.count((Specification)specification)) > 0L) {
            long totalPageNum = (totalCount + queryPageSize - 1L) / queryPageSize;
            Sort sort = new Sort(Sort.Direction.ASC, new String[]{"id"});
            ExecutorService pool = Executors.newFixedThreadPool(3);
            int pn = 0;
            while ((long)pn < totalPageNum) {
                pool.execute((Runnable)new ResetProductCatThread(this, (Specification)specification, pn, (int)queryPageSize, sort, (int)totalPageNum));
                ++pn;
            }
            if (pool.isShutdown()) continue;
            pool.shutdown();
        }
        return null;
    }

    @Transactional
    public Map resetProdCategory(List<String> skus) {
        Organization organization = this.organizationRepos.findByOrgCodeAndIsDelete("jicai", false);
        Object catId = null;
        Object category = null;
        StringBuilder sb = new StringBuilder();
        int handled = 1;
        for (String sku : skus) {
            this.logger.info((Object)("\u6b63\u5728\u5904\u7406sku: " + sku));
            try {
                sb.append(this.handleRestCat(sku, organization)).append("\r\n");
                this.logger.info((Object)("\u5df2\u5904\u7406[" + handled++ + "/" + skus.size() + "]sku: " + sku));
            }
            catch (Exception ex) {
                this.logger.error((Object)("\u5904\u7406[" + handled++ + "/" + skus.size() + "]\u5931\u8d25\uff01sku: " + sku + ", \u65b0\u5206\u7c7b: " + (category == null ? "" : category.getName())), new Object[]{ex});
            }
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    private String handleRestCat(String sku, Organization organization) {
        StringBuilder rsStr = new StringBuilder();
        ProductDetailEntity productDetailEntity = new ProductDetailEntity();
        productDetailEntity.setSku(Long.valueOf(sku));
        String catId = null;
        ProductCategory category = null;
        ProductDetailVO productDetailVO = this.jdProductApi.getProductDetail(productDetailEntity);
        if (productDetailVO != null) {
            if (!Lang.isEmpty((Object)productDetailVO.getCategory())) {
                List categoryList;
                String[] catIds = productDetailVO.getCategory().split(";");
                if (catIds != null && catIds.length >= 1) {
                    catId = catIds[catIds.length - 1];
                }
                if ((categoryList = this.productCategoryRepos.findByCode(new Integer(catId))) != null && categoryList.size() > 0) {
                    category = (ProductCategory)categoryList.get(0);
                    if (category.getIsDelete().booleanValue()) {
                        // empty if block
                    }
                } else {
                    String pid = null;
                    for (int i = 0; i < catIds.length; ++i) {
                        categoryList = this.productCategoryRepos.findByCode(new Integer(catIds[i]));
                        if (categoryList != null && categoryList.size() > 0) {
                            category = (ProductCategory)categoryList.get(0);
                            if (!category.getIsDelete().booleanValue()) continue;
                            pid = category.getId();
                            continue;
                        }
                        category = new ProductCategory();
                        CategoryEntity categoryEntity = new CategoryEntity();
                        categoryEntity.setCid(catIds[i]);
                        CategoryResp categoryResp = this.jdProductApi.getCategory(categoryEntity);
                        if (categoryResp != null && categoryResp.getSuccess().booleanValue()) {
                            category.setLayerIndex(Integer.valueOf(i + 1));
                            category.setCode(categoryResp.getResult().getCatId());
                            category.setName(categoryResp.getResult().getName());
                            category.setPath("https://www.jd.com/");
                        }
                        category.setParent(category == null ? null : this.productCategoryRepos.findById(pid));
                        category = (ProductCategory)this.productCategoryRepos.save((Object)category);
                        ProductCategoryConfig productCategoryConfig = new ProductCategoryConfig();
                        productCategoryConfig.setProductCategoryId(category.getId());
                        productCategoryConfig.setIsUp(Boolean.valueOf(true));
                        productCategoryConfig.setOrganizationId(organization.getId());
                        this.productCategoryConfigRepos.save((Object)productCategoryConfig);
                        pid = category.getId();
                    }
                }
            }
            List goods = this.goodsRepos.findBySku(sku);
            if (category != null) {
                for (Goods g : goods) {
                    g.getProduct().setProductCategory(category);
                }
                this.goodsRepos.save((Iterable)goods);
            }
            this.logger.info((Object)("\u5df2\u5904\u7406sku: " + sku + ", \u65b0\u5206\u7c7b: " + category == null ? "" : category.getName()));
            return "\u5df2\u5904\u7406sku: " + sku + ", \u65b0\u5206\u7c7b: " + category == null ? "" : category.getName();
        }
        this.logger.error((Object)("\u5904\u7406sku: " + sku + "\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a \u4eac\u4e1c\u63a5\u53e3\u67e5\u8be2\u4e0d\u5230\u8be5SKU"));
        return "\u5904\u7406sku: " + sku + "\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a \u4eac\u4e1c\u63a5\u53e3\u67e5\u8be2\u4e0d\u5230\u8be5SKU";
    }

    public void matchCategory() {
    }

    public void deleteCategoryMatch() {
        this.productCategoryExtTaxRateRepos.deleteAll();
    }

    static /* synthetic */ String access$000(CategoryDbService x0) {
        return x0.jdId;
    }
}

