/*
 * Decompiled with CFR 0.152.
 */
package jd.service.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.GoodsConfigApi;
import goods.model.Goods;
import goods.model.GoodsPicture;
import goods.model.Product;
import goods.model.ProductBrand;
import goods.model.ProductCategory;
import goods.model.ProductFashion;
import goods.model.ProductFashionPicture;
import goods.model.ProductPool;
import goods.model.ProductPoolSku;
import goods.model.repository.GoodsRepos;
import goods.model.repository.GoodsTempRepos;
import goods.model.repository.ProductBrandRepos;
import goods.model.repository.ProductCategoryRepos;
import goods.model.repository.ProductPoolRepos;
import goods.model.repository.ProductPoolSkuRepos;
import goods.model.repository.ProductRepos;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jd.api.request.product.CategorysEntity;
import jd.api.request.product.PageNumEntity;
import jd.api.request.product.ProductDetailEntity;
import jd.api.request.product.SkuEntity;
import jd.api.response.product.CategorysResp;
import jd.api.response.product.ProductCheckResp;
import jd.api.service.product.JdProductApi;
import jd.api.vo.product.PriceVO;
import jd.api.vo.product.ProductCheckRepVO;
import jd.api.vo.product.ProductDetailVO;
import jd.api.vo.product.ProductPoolVO;
import jd.api.vo.product.ProductSkuImageVO;
import jd.service.service.ProductDbInitService;
import jd.service.service.ProductTransactionalService;
import jd.service.vo.ExistGoodsVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import utils.Lang;
import utils.file.FileUtils;
import utils.log.Log;
import utils.log.Logs;
import utils.web.ResponseMapUtils;

@Component
public class ProductDbInitService {
    private static final Log log = Logs.getLog((String)ProductDbInitService.class.getName());
    @Value(value="${spring.profiles.active}")
    private String activeEnv;
    @Autowired
    JdProductApi jdProductApi;
    @Autowired
    GoodsTempRepos goodsTempRepos;
    @Autowired
    GoodsRepos goodsRepos;
    @Autowired
    ProductRepos productRepos;
    @Autowired
    ProductCategoryRepos productCategoryRepos;
    @Autowired
    ProductBrandRepos productBrandRepos;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @MotanReferer
    GoodsConfigApi goodsConfigApi;
    @Autowired
    ProductPoolRepos productPoolRepos;
    @Autowired
    ProductPoolSkuRepos productPoolSkuRepos;
    @Value(value="${jd.store.code}")
    private String jdCode;
    @Value(value="${jd.store.id}")
    private String jdId;
    List<Long> productNosList;
    int totalNum;
    private static final String countSql = "SELECT count(*) FROM product_category_brand  where brand_id = ?  and category_id =? ";
    @Autowired
    ProductTransactionalService productTransactionalService;

    public String getActiveEnv() {
        return this.activeEnv;
    }

    public void setActiveEnv(String activeEnv) {
        this.activeEnv = activeEnv;
    }

    public void asyncInitProduct(Boolean isCompatible, Boolean isThread, Integer poolSize) {
        log.info((Object)"=======\u540c\u6b65\u5f00\u59cb=======");
        List productPools = this.jdProductApi.getProductPool();
        HashSet productNoSet = new HashSet();
        for (ProductPoolVO productPool : productPools) {
            String pageNum = productPool.getPage_num();
            Boolean isProdEnv = true;
            if (!Lang.isEmpty((Object)this.activeEnv)) {
                String[] envArr;
                for (String env : envArr = this.activeEnv.split(",")) {
                    if ("product".equals(env.trim()) || "prod".equals(env.trim())) continue;
                    isProdEnv = false;
                }
            }
            if ((isProdEnv = Boolean.valueOf(true)).booleanValue()) {
                List productNos = null;
                productNos = isCompatible != false ? this.jdProductApi.getProductPoolProductOld(new PageNumEntity(pageNum, Integer.valueOf(1))) : this.jdProductApi.getProductPoolProduct(new PageNumEntity(pageNum));
                productNoSet.addAll(productNos);
                continue;
            }
            String JsonContext = FileUtils.ReadFile((String)this.getPath());
            List listMap = (List)JSON.parseObject((String)JsonContext, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            for (int i = 0; i < listMap.size(); ++i) {
                String name = ((Map)listMap.get(i)).get("name") + "";
                if (!name.equals(productPool.getName())) continue;
                List productNos = this.jdProductApi.getProductPoolProduct(new PageNumEntity(pageNum));
                productNoSet.addAll(productNos);
            }
        }
        this.productNosList = new ArrayList(productNoSet);
        this.totalNum = this.productNosList.size();
        this.executorsPoolAdd(this.productNosList, this.totalNum, isThread, poolSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executorsPoolAdd(List<Long> productNosList, int totalNum, Boolean isThread, Integer poolSize) {
        if (Lang.isEmpty((Object)poolSize)) {
            poolSize = 50;
        }
        ExecutorService pool = Executors.newFixedThreadPool(poolSize);
        ArrayList skus = new ArrayList();
        try {
            for (int i = 0; i < totalNum; ++i) {
                log.info((Object)"=======\u540c\u6b65\u7b2c{}/{}\u4e2a\u5546\u54c1=======", new Object[]{i, totalNum});
                try {
                    if (isThread.booleanValue()) {
                        GoodsThread thread = new GoodsThread(this, productNosList.get(i));
                        pool.execute((Runnable)thread);
                        continue;
                    }
                    List goodsIds = this.productTransactionalService.addGoods(Long.valueOf(productNosList.get(i)));
                    productNosList.forEach(sku -> skus.add(String.valueOf(sku)));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"\u540c\u6b65\u4eac\u4e1c\u5546\u54c1\u51fa\u9519", new Object[]{e});
        }
        finally {
            if (!pool.isShutdown()) {
                pool.shutdown();
            }
        }
        this.triggerUpdateSearch(skus);
    }

    public CategorysResp getCategorys(CategorysEntity categorysEntity) {
        return this.jdProductApi.getCategorys(categorysEntity);
    }

    public Map initProductPool(Integer poolSize) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        List productPools = this.jdProductApi.getProductPool();
        for (ProductPoolVO productPool : productPools) {
            String pageNum = productPool.getPage_num();
            String pageName = productPool.getName();
            returnMap.put("poolName", pageName);
            returnMap.put("poolNum", pageNum);
            ProductPool productPoolEntityExist = this.productPoolRepos.findByPoolNumAndStoreIdAndIsDelete(pageNum, this.jdId, false);
            ProductPool productPoolEntity = null;
            productPoolEntity = Lang.isEmpty((Object)productPoolEntityExist) ? new ProductPool(pageNum, pageName, this.jdId, this.jdCode) : productPoolEntityExist;
            List productNos = this.jdProductApi.getProductPoolProductOld(new PageNumEntity(pageNum, Integer.valueOf(1)));
            returnMap.put("productNos", productNos);
            ArrayList<ProductPoolSku> productPoolSkus = new ArrayList<ProductPoolSku>();
            for (int i = 0; i < productNos.size(); ++i) {
                String sku = ((Long)productNos.get(i)).toString();
                ProductPoolSku productPoolSku = this.productPoolSkuRepos.findBySkuAndStoreIdAndIsDelete(sku, this.jdId, false);
                if (!Lang.isEmpty((Object)productPoolSku)) continue;
                productPoolSku = new ProductPoolSku(sku, this.jdId, this.jdCode);
                productPoolSkus.add(productPoolSku);
            }
            productPoolEntity.setProductPoolSkus(productPoolSkus);
            this.productPoolRepos.save((Object)productPoolEntity);
        }
        return returnMap;
    }

    public String getPath() {
        String path = this.getClass().getResource("/").getPath();
        path = path.substring(0, path.length() - 15) + "productPool.json";
        return path;
    }

    @Transactional
    public List<String> addGoods(Long productNo) {
        ProductDetailVO productDetail = this.jdProductApi.getProductDetail(new ProductDetailEntity(productNo));
        List prices = this.jdProductApi.getPrice(new SkuEntity(productNo + ""));
        if (prices == null || prices.size() == 0) {
            throw new RuntimeException("prices\uff1a\u5546\u54c1\u4ef7\u683c\u4e3a\u7a7a,\u5546\u54c1\u7f16\u53f7:" + productNo);
        }
        PriceVO priceVO = (PriceVO)prices.get(0);
        Map imageMap = this.jdProductApi.getProductSkuImage(Arrays.asList(productNo));
        if (imageMap == null || imageMap.size() == 0) {
            throw new RuntimeException("imageMap\uff1a\u5546\u54c1\u56fe\u7247\u4fe1\u606f\u4e3a\u7a7a,\u5546\u54c1\u7f16\u53f7:" + productNo);
        }
        List productSkuImageVOs = (List)imageMap.get(productNo);
        if (productSkuImageVOs == null || productSkuImageVOs.size() == 0) {
            throw new RuntimeException("productSkuImageVOs\uff1a\u5546\u54c1\u56fe\u7247\u4fe1\u606f\u4e3a\u7a7a,\u5546\u54c1\u7f16\u53f7:" + productNo);
        }
        ProductCheckResp productCheckResp = this.jdProductApi.getSkuCheck(Arrays.asList(productNo));
        Boolean isDelete = false;
        if (!Lang.isEmpty((Object)productCheckResp) && !Lang.isEmpty((Object)productCheckResp.getResult())) {
            for (ProductCheckRepVO productCheckRepVO : productCheckResp.getResult()) {
                if (!productCheckRepVO.getSkuId().equals(productNo) || productCheckRepVO.getIsCanVAT() != ProductCheckRepVO.CAN_VAT_NO_SUPPORT && productCheckRepVO.getSaleState() != ProductCheckRepVO.SALE_NO_SUPPORT) continue;
                isDelete = true;
            }
        }
        Goods goods = null;
        ArrayList<String> returnStrs = new ArrayList<String>();
        ExistGoodsVo existGoodsVo = this.isExistGoods(Long.toString(productNo), priceVO, productDetail, isDelete);
        if (!Lang.isEmpty((Object)existGoodsVo)) {
            if (!existGoodsVo.getExistGoods().booleanValue()) {
                goods = new Goods();
                this.setBaseInfo(goods, productDetail, priceVO, productSkuImageVOs, isDelete);
                goods = this.setProduct(goods, productDetail, isDelete);
                goods = (Goods)this.goodsRepos.saveAndFlush((Object)goods);
                returnStrs.add(goods.getId());
            } else if (!Lang.isEmpty((Object)existGoodsVo.getGoodses())) {
                for (Goods goods1 : existGoodsVo.getGoodses()) {
                    returnStrs.add(goods1.getId());
                }
            }
        }
        return returnStrs;
    }

    private ExistGoodsVo isExistGoods(String skuId, PriceVO priceVO, ProductDetailVO productDetail, Boolean isDelete) {
        Boolean isExistGoods = false;
        ArrayList<Goods> returnList = new ArrayList<Goods>();
        List goodsList = this.goodsRepos.findAll((Specification)new /* Unavailable Anonymous Inner Class!! */);
        if (!Lang.isEmpty((Object)goodsList) && goodsList.size() > 0) {
            isExistGoods = true;
            for (Goods goods : goodsList) {
                goods.setIsDelete(isDelete);
                BigDecimal initPrice = new BigDecimal(0);
                if (!Lang.isEmpty((Object)priceVO)) {
                    if (!Lang.isEmpty((Object)priceVO.getJdPrice())) {
                        initPrice = priceVO.getJdPrice();
                    }
                    goods.setMarketPrice(initPrice);
                    goods.setSalePrice(initPrice);
                    if (Lang.isEmpty((Object)priceVO.getPrice())) {
                        goods.setCostPrice(initPrice);
                    } else {
                        goods.setCostPrice(priceVO.getPrice());
                    }
                } else {
                    goods.setMarketPrice(initPrice);
                    goods.setSalePrice(initPrice);
                    goods.setCostPrice(initPrice);
                    goods.setDiscountRate(initPrice);
                }
                if (!Lang.isEmpty((Object)productDetail)) {
                    goods.setIntroduction(productDetail.getIntroduction());
                }
                returnList.add(goods);
                this.goodsRepos.saveAndFlush((Object)goods);
            }
        }
        ExistGoodsVo existGoodsVo = new ExistGoodsVo(isExistGoods, returnList);
        return existGoodsVo;
    }

    private void setBaseInfo(Goods goods, ProductDetailVO productDetail, PriceVO priceVO, List<ProductSkuImageVO> productSkuImageVOs, Boolean isDelete) {
        if (!Lang.isEmpty((Object)productDetail)) {
            goods.setName(productDetail.getName());
            goods.setStoreId(this.jdId);
            BigDecimal initPrice = new BigDecimal(0);
            if (!Lang.isEmpty((Object)priceVO.getJdPrice())) {
                initPrice = priceVO.getJdPrice();
            }
            goods.setMarketPrice(initPrice);
            goods.setSalePrice(initPrice);
            if (Lang.isEmpty((Object)priceVO.getPrice())) {
                goods.setCostPrice(initPrice);
            } else {
                goods.setCostPrice(priceVO.getPrice());
            }
            goods.setBrandName(productDetail.getBrandName());
            goods.setIntroduction(productDetail.getIntroduction());
            goods.setParam(productDetail.getParam());
            goods.setProductArea(productDetail.getProductArea());
            goods.setSaleUnit(productDetail.getSaleUnit());
            goods.setSku(productDetail.getSku() + "");
            goods.setCode(productDetail.getSku() + "");
            goods.setState(productDetail.getState());
            goods.setUpc(productDetail.getUpc());
            goods.setWareQD(productDetail.getWareQD());
            goods.setWeight(productDetail.getWeight());
            goods.setPushUpDate(new Date());
            if (isDelete.booleanValue()) {
                goods.setIsDelete(isDelete);
            }
            ArrayList<GoodsPicture> goodsPictures = new ArrayList<GoodsPicture>();
            if (productSkuImageVOs != null) {
                for (ProductSkuImageVO imageVO : productSkuImageVOs) {
                    GoodsPicture goodsPicture = new GoodsPicture();
                    goodsPicture.setPicturePath("http://img20.360buyimg.com/vc/" + imageVO.getPath());
                    goodsPicture.setBigPicturePath("http://img20.360buyimg.com/vc/" + imageVO.getPath());
                    if (imageVO.getIsPrimary() != null && imageVO.getIsPrimary().equals(1)) {
                        goodsPicture.setShowIndex(Integer.valueOf(0));
                    } else {
                        goodsPicture.setShowIndex(Integer.valueOf(Integer.parseInt(imageVO.getOrderSort())));
                    }
                    goodsPicture.setGoods(goods);
                    if (isDelete.booleanValue()) {
                        goodsPicture.setIsDelete(isDelete);
                    }
                    goodsPictures.add(goodsPicture);
                }
                goods.setGoodsPictures(goodsPictures);
            }
        }
    }

    private ProductBrand setBrand(String brandName) {
        ProductBrand productBrand;
        if (Lang.isEmpty((Object)brandName)) {
            brandName = "\u6ca1\u6709\u54c1\u724c\u7684\u5546\u54c1" + this.jdCode;
        }
        if (Lang.isEmpty((Object)(productBrand = this.productBrandRepos.findByNameAndAndSourceCodeAndIsDelete(brandName, this.jdCode, false)))) {
            productBrand = new ProductBrand();
            String websitesUrl = "www.jd.com";
            String BRAND_NAME = brandName;
            productBrand.setShowIndex(Integer.valueOf(1));
            productBrand.setDescription(BRAND_NAME);
            productBrand.setName(BRAND_NAME);
            productBrand.setSimpleName(BRAND_NAME);
            productBrand.setWebsitesUrl(websitesUrl);
            productBrand.setSourceCode(this.jdCode);
            this.productBrandRepos.save((Object)productBrand);
        }
        return productBrand;
    }

    @Transactional
    public Goods setProduct(Goods goods, ProductDetailVO productDetail, Boolean isDelete) {
        if (!Lang.isEmpty((Object)productDetail)) {
            Product product = new Product();
            String productName = goods.getName();
            product.setCostPrice(goods.getCostPrice());
            product.setMarketPrice(goods.getMarketPrice());
            product.setSalePrice(goods.getSalePrice());
            product.setProductName(productName);
            product.setTitle(productName);
            product.setCode(goods.getSku());
            product.setStoreId(this.jdId);
            ProductFashion productFashion = new ProductFashion();
            productFashion.setMarketPrice(goods.getMarketPrice());
            productFashion.setSalePrice(goods.getSalePrice());
            productFashion.setCostPrice(goods.getCostPrice());
            productFashion.setProductCode(goods.getSku());
            productFashion.setStockCount(Integer.valueOf(goods.getStockCount().intValue()));
            productFashion.setLackRemind(Integer.valueOf(0));
            productFashion.setOnSale(Boolean.valueOf(true));
            productFashion.setFashionPic(((GoodsPicture)goods.getGoodsPictures().get(0)).getPicturePath());
            ProductFashionPicture fashionPic = null;
            boolean hasDefault = false;
            ArrayList<ProductFashionPicture> productFashionPictures = new ArrayList<ProductFashionPicture>();
            for (GoodsPicture gp : goods.getGoodsPictures()) {
                fashionPic = new ProductFashionPicture();
                fashionPic.setProductFashion(productFashion);
                fashionPic.setAppPicturePath(gp.getAppPicturePath());
                fashionPic.setBigPicturePath(gp.getBigPicturePath());
                fashionPic.setPicturePath(gp.getPicturePath());
                fashionPic.setShowIndex(gp.getShowIndex());
                if (!(hasDefault || gp.getShowIndex() != 0 && goods.getGoodsPictures().size() != 1)) {
                    fashionPic.setDefaultFlag(Boolean.valueOf(true));
                    hasDefault = true;
                }
                productFashionPictures.add(fashionPic);
            }
            productFashion.setProductFashionPictures(productFashionPictures);
            productFashion.setFieldName("\u989c\u8272");
            productFashion.setFieldType("1");
            productFashion.setValue("\u9ed1\u8272");
            productFashion.setValueName("\u9ed1\u8272");
            if (isDelete.booleanValue()) {
                productFashion.setIsDelete(isDelete);
            }
            productFashion.setFashionTitle(productName);
            productFashion.setProduct(product);
            product.setProductFashions(Arrays.asList(productFashion));
            try {
                Integer count;
                String category = productDetail.getCategory();
                Integer code = Integer.parseInt(category.split(";")[2]);
                ProductBrand productBrand = this.setBrand(productDetail.getBrandName());
                ProductCategory productCategory = this.productCategoryRepos.findTopByCodeAndSourceCode(code, this.jdCode);
                if (Lang.isEmpty((Object)productCategory) && Lang.isEmpty((Object)(productCategory = this.productCategoryRepos.findTopByCodeAndSourceCode(code = Integer.valueOf(Integer.parseInt(category.split(";")[1])), this.jdCode))) && Lang.isEmpty((Object)(productCategory = this.productCategoryRepos.findTopByCodeAndSourceCode(code = Integer.valueOf(Integer.parseInt(category.split(";")[0])), this.jdCode)))) {
                    throw new RuntimeException("\u5546\u54c1\u5206\u7c7b\u5173\u8054\u5f02\u5e38\uff0c\u5c5e\u4e8e\u95ee\u9898\u5546\u54c1:" + productDetail.getSku());
                }
                product.setProductCategory(productCategory);
                if (!(Lang.isEmpty((Object)productBrand) || Lang.isEmpty((Object)productCategory) || !Lang.isEmpty((Object)(count = (Integer)this.jdbcTemplate.queryForObject(countSql, new Object[]{productBrand.getId(), productCategory.getId()}, Integer.class))) && count != 0)) {
                    ArrayList<ProductBrand> productBrands = new ArrayList<ProductBrand>();
                    productBrands.add(productBrand);
                    productCategory.setProductBrands(productBrands);
                    this.productCategoryRepos.save((Object)productCategory);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (isDelete.booleanValue()) {
                product.setIsDelete(isDelete);
            }
            product = (Product)this.productRepos.save((Object)product);
            goods.setProduct(product);
        }
        return goods;
    }

    public void batchDelete() {
        this.goodsRepos.deleteAll();
        this.productRepos.deleteAll();
    }

    public void triggerUpdateSearch(List<String> skus) {
        String storeCode = "jd";
    }

    private void addProductPool(ProductPool productPoolEntity, String sku) {
        ProductPoolSku productPoolSku = new ProductPoolSku(sku, this.jdId, this.jdCode);
        productPoolEntity.setProductPoolSkus(Arrays.asList(productPoolSku));
        this.productPoolRepos.save((Object)productPoolEntity);
    }

    public Map addProdBySkus(Map resMap, String skuids) {
        resMap = ResponseMapUtils.success(null);
        HashMap<String, Serializable> rsData = new HashMap<String, Serializable>();
        ArrayList<3> errorDetail = new ArrayList<3>();
        if (!Lang.isEmpty((Object)skuids)) {
            ArrayList<String> skuList = new ArrayList<String>();
            if (skuids.contains(",")) {
                String[] skuArr;
                for (String s : skuArr = skuids.split(",")) {
                    if (Lang.isEmpty((Object)s)) continue;
                    skuList.add(s.trim());
                }
            } else {
                skuList.add(skuids.trim());
            }
            int sucCount = 0;
            int errorCount = 0;
            int totalCount = skuList.size();
            Object goodsId = null;
            ArrayList<Object> goodsIds = new ArrayList<Object>();
            for (String sku : skuList) {
                try {
                    if (!Lang.isEmpty((Object)this.productTransactionalService.addGoods(Long.valueOf(Long.parseLong(sku))))) {
                        goodsIds.add(goodsId);
                    }
                    ++sucCount;
                }
                catch (Exception e) {
                    ++errorCount;
                    errorDetail.add(new /* Unavailable Anonymous Inner Class!! */);
                    e.printStackTrace();
                }
            }
            String storeCode = "jd";
            rsData.put("suc", Integer.valueOf(sucCount));
            rsData.put("error", Integer.valueOf(errorCount));
            rsData.put("total", Integer.valueOf(totalCount));
            rsData.put("errorDetail", errorDetail);
            resMap.put("data", rsData);
        } else {
            resMap = ResponseMapUtils.error((String)"skuids\u5fc5\u4f20\uff0c\u591a\u4e2asku\u7528','\u9694\u5f00", (String)"2");
        }
        return resMap;
    }

    static /* synthetic */ String access$000(ProductDbInitService x0) {
        return x0.jdId;
    }

    static /* synthetic */ void access$100(ProductDbInitService x0, ProductPool x1, String x2) {
        x0.addProductPool(x1, x2);
    }
}

