/*
 * Decompiled with CFR 0.152.
 */
package jd.service.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jd.api.request.address.AddressEntity;
import jd.api.request.aftersale.AfsApplyEntity;
import jd.api.request.aftersale.AfterSaleCustomerDto;
import jd.api.request.aftersale.AfterSaleDetailDto;
import jd.api.request.aftersale.AfterSalePickwareDto;
import jd.api.request.aftersale.AfterSaleReturnwareDto;
import jd.api.request.aftersale.AuditCancelEntity;
import jd.api.request.aftersale.OrderSkuEntity;
import jd.api.request.aftersale.ServiceDetailInfoEntity;
import jd.api.request.aftersale.ServiceListPageEntity;
import jd.api.request.order.JdOrderIdEntity;
import jd.api.request.order.OrderBalanceEntity;
import jd.api.request.order.OrderEntity;
import jd.api.request.order.OrderFreightEntity;
import jd.api.request.order.ThirdOrder;
import jd.api.request.product.CategoryEntity;
import jd.api.request.product.CategorysEntity;
import jd.api.request.product.MessageDelEntity;
import jd.api.request.product.MessageTypeEntity;
import jd.api.request.product.PageNumEntity;
import jd.api.request.product.ProductDetailEntity;
import jd.api.request.product.SkuEntity;
import jd.api.request.product.SkuIdAndNumEntity;
import jd.api.request.product.SkuIdsAndAreaEntity;
import jd.api.request.product.StockForOrderEntity;
import jd.api.response.aftersale.AfsApplyResp;
import jd.api.response.aftersale.AuditCancelResp;
import jd.api.response.aftersale.AvailableNumberCompResp;
import jd.api.response.aftersale.CustomerExpectCompResp;
import jd.api.response.aftersale.ServiceDetailInfoResp;
import jd.api.response.aftersale.ServiceListPageResp;
import jd.api.response.aftersale.WareReturnJdCompResp;
import jd.api.response.order.OccupyStockResp;
import jd.api.response.order.OrderRevResp;
import jd.api.response.order.OrderTrackResp;
import jd.api.response.order.OrderUniteSubmitResp;
import jd.api.response.product.CategoryResp;
import jd.api.response.product.CategorysResp;
import jd.api.response.product.ProductCheckResp;
import jd.api.service.address.JdAddressApi;
import jd.api.service.aftersale.JdAftersaleApi;
import jd.api.service.order.JdOrderApi;
import jd.api.service.product.JdProductApi;
import jd.api.vo.order.OrderFreightVO;
import jd.api.vo.product.MessageGetVO;
import jd.api.vo.product.PriceVO;
import jd.api.vo.product.ProductCommentSummarysVO;
import jd.api.vo.product.ProductDetailVO;
import jd.api.vo.product.ProductPoolVO;
import jd.api.vo.product.ProductSkuImageVO;
import jd.api.vo.product.ProductStateVO;
import jd.api.vo.product.SkuIdsAndAreaVO;
import jd.api.vo.product.StockNewResultVo;
import jd.api.vo.product.StockVO;
import jd.model.stock.StockState;
import jd.model.stock.StockStateDao;
import jd.service.service.CategoryDbService;
import jd.service.service.ProductDbInitService;
import jd.service.task.JdOrderConstant;
import jd.service.task.OrderPriceSnap;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import sinomall.global.common.vo.outsideapi.OrderCancelOrderResp;
import utils.Lang;
import utils.file.FileUtils;
import utils.log.Log;
import utils.log.Logs;

@RestController
@RequestMapping(value={"api"})
public class JdApiController {
    private static final Log log = Logs.getLog((String)JdApiController.class.getName());
    @Autowired
    JdProductApi jdProductApi;
    @Autowired
    CategoryDbService categoryDbService;
    @Autowired
    JdAftersaleApi jdAftersaleApi;
    @Autowired
    StockStateDao stockStateDao;
    @Value(value="${stock.inputPath:C:\\Users\\25057\\Desktop\\ct-stock.txt}")
    String skuIdsInput;
    @Autowired
    JdAddressApi jdAddressApi;
    @Autowired
    JdOrderApi jdOrderApi;
    @Autowired
    ProductDbInitService productDbInitService;

    @RequestMapping(value={"/getProductPool"})
    public List<ProductPoolVO> getProductPool() {
        List productPool = this.jdProductApi.getProductPool();
        log.info((Object)"\u624b\u52a8\u8c03\u7528{}", new Object[]{productPool});
        return productPool;
    }

    @RequestMapping(value={"/getProductPoolProduct"})
    public List<Long> getProductPoolProduct(PageNumEntity pageNumEntity) {
        log.info((Object)"\u624b\u52a8\u8c03\u7528{}", new Object[]{pageNumEntity});
        List productPoolProduct = this.jdProductApi.getProductPoolProduct(pageNumEntity);
        return productPoolProduct;
    }

    @RequestMapping(value={"/totalProduct"})
    @ResponseBody
    public Map getProductPoolProduct(@RequestParam Integer pageNo, HttpServletResponse response, @RequestParam Boolean isGetPools, Integer separateSize) {
        Integer totalPools = 0;
        Integer totalProductNum = 0;
        HashMap<String, Serializable> returnMap = new HashMap<String, Serializable>();
        log.info((Object)"\u624b\u52a8\u8c03\u7528{}", new Object[]{pageNo});
        List productPools = this.jdProductApi.getProductPool();
        if (!Lang.isEmpty((Object)productPools)) {
            ArrayList<String> productPoolsNames = new ArrayList<String>();
            ArrayList<Long> productNoTotal = new ArrayList<Long>();
            HashMap<String, Object> poolsProductNo = new HashMap<String, Object>();
            Integer poolsSize = 0;
            ArrayList writeTextList = new ArrayList();
            for (ProductPoolVO productPool : productPools) {
                log.info((Object)productPool.toString());
                productPoolsNames.add(productPool.getName());
                if (isGetPools.booleanValue()) {
                    Integer n = poolsSize;
                    poolsSize = poolsSize + 1;
                    Integer n2 = poolsSize;
                    HashMap<String, String> returnPoolsMap = new HashMap<String, String>();
                    returnPoolsMap.put("poolsName", productPool.getName());
                    returnPoolsMap.put("pageNum", productPool.getPage_num());
                    writeTextList.add(returnPoolsMap);
                    if (Lang.isEmpty((Object)separateSize)) {
                        separateSize = 50;
                    }
                    if (poolsSize % separateSize != 0) continue;
                    FileUtils.textToFile((String)("F://productPools//\u5546\u54c1\u6c60" + poolsSize + ".txt"), (String)JSON.toJSONString(writeTextList));
                    continue;
                }
                List productNos = this.jdProductApi.getProductPoolProductOld(new PageNumEntity(productPool.getPage_num(), pageNo));
                for (Long productNo : productNos) {
                    Integer n = totalProductNum;
                    Integer n3 = totalProductNum = Integer.valueOf(totalProductNum + 1);
                    log.info((Object)productNo.toString());
                    productNoTotal.add(productNo);
                }
                poolsProductNo.put(productPool.getName(), productPool.getName());
                poolsProductNo.put(productPool.getName() + "SKU", productNoTotal);
            }
            log.info((Object)("totalPools" + totalPools));
            log.info((Object)("totalProductNum" + totalProductNum));
            ArrayList newList = new ArrayList(new HashSet(productNoTotal));
            log.info((Object)("productNoTotal" + newList.size()));
            returnMap.put("totalPools", totalPools);
            returnMap.put("productPoolsNames", productPoolsNames);
            returnMap.put("totalProductNum", totalProductNum);
            returnMap.put("productNoTotal", productNoTotal);
            returnMap.put("poolsProductNo", poolsProductNo);
        }
        return returnMap;
    }

    @RequestMapping(value={"/downloadProductPools"})
    @ResponseBody
    public Map downloadProductPools(@RequestParam Integer pageNo, HttpServletResponse response, @RequestParam String fileName) {
        HSSFWorkbook wb = new HSSFWorkbook();
        String readStr = FileUtils.ReadFile((String)("F://productPools//" + fileName + ".txt"));
        List listMap = (List)JSON.parseObject((String)readStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        Integer totalPools = 0;
        for (int i = 0; i < listMap.size(); ++i) {
            String pageNum = (String)((Map)listMap.get(i)).get("pageNum");
            String name = (String)((Map)listMap.get(i)).get("poolsName");
            ArrayList writeExcelList = new ArrayList();
            List productNos = this.jdProductApi.getProductPoolProductOld(new PageNumEntity(pageNum, pageNo));
            for (Long productNo : productNos) {
                log.info((Object)productNo.toString());
                ProductDetailVO productDetailVO = this.jdProductApi.getProductDetail(new ProductDetailEntity(productNo));
                HashMap<String, String> writeExcelMap = new HashMap<String, String>();
                writeExcelMap.put("poolsName", name);
                writeExcelMap.put("pageNum", pageNum);
                writeExcelMap.put("sku", productNo.toString());
                if (!Lang.isEmpty((Object)productDetailVO)) {
                    writeExcelMap.put("name", productDetailVO.getName());
                }
                writeExcelList.add(writeExcelMap);
            }
            HSSFSheet sheet = wb.createSheet();
            wb.setSheetName(totalPools.intValue(), name.replace("/", "-") + totalPools);
            this.setContentColumnWidth(sheet);
            HSSFCellStyle cellStyle = this.setContentCellStyle(wb);
            this.createCellHead(sheet.createRow(0), cellStyle, sheet.createRow(0).createCell(0));
            this.createCellContent(writeExcelList, cellStyle, sheet);
            Integer n = totalPools;
            Integer n2 = totalPools = Integer.valueOf(totalPools + 1);
        }
        try {
            response.setHeader("Content-disposition", "attachment; filename=" + fileName + ".xls");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream out = response.getOutputStream();
            wb.write((OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Error", new Object[]{e});
        }
        return null;
    }

    @RequestMapping(value={"/getProductDetail"})
    public ProductDetailVO getProductPool(ProductDetailEntity productDetailEntity) {
        ProductDetailVO productDetailVO = this.jdProductApi.getProductDetail(productDetailEntity);
        return productDetailVO;
    }

    @RequestMapping(value={"/getProductDetailBySku"})
    @ResponseBody
    public Map getProductPool(@RequestParam String sku) {
        ProductDetailEntity productDetailEntity = new ProductDetailEntity();
        productDetailEntity.setSku(Long.valueOf(sku));
        ProductDetailVO productDetailVO = this.jdProductApi.getProductDetail(productDetailEntity);
        HashMap<String, ProductDetailVO> returnMap = new HashMap<String, ProductDetailVO>();
        returnMap.put("productDetailVO", productDetailVO);
        return returnMap;
    }

    @RequestMapping(value={"/getProductState"})
    public List<ProductStateVO> getProductState(Long[] skus) {
        List list = this.jdProductApi.getProductState(Arrays.asList(skus));
        return list;
    }

    @RequestMapping(value={"/getProductSkuImage"})
    public Map<Long, List<ProductSkuImageVO>> getProductSkuImage(Long[] skus) {
        Map map = this.jdProductApi.getProductSkuImage(Arrays.asList(skus));
        return map;
    }

    @RequestMapping(value={"/getProductCommentSummarys"})
    public List<ProductCommentSummarysVO> getProductCommentSummarys(Long[] skus) {
        List list = this.jdProductApi.getProductCommentSummarys(Arrays.asList(skus));
        return list;
    }

    @RequestMapping(value={"/getProductLimit"})
    public List<SkuIdsAndAreaVO> getProductLimit(SkuIdsAndAreaEntity skuIdsAndAreaEntity) {
        List limit = this.jdProductApi.getProductLimit(skuIdsAndAreaEntity);
        return limit;
    }

    @RequestMapping(value={"/getProductIsCod"})
    public Boolean getProductIsCod(SkuIdsAndAreaEntity skuIdsAndAreaEntity) {
        Boolean b = this.jdProductApi.getProductIsCod(skuIdsAndAreaEntity);
        return b;
    }

    @RequestMapping(value={"/getSkuCheck"})
    public ProductCheckResp getSkuCheck(Long[] skus) {
        ProductCheckResp productCheckResp = this.jdProductApi.getSkuCheck(Arrays.asList(skus));
        return productCheckResp;
    }

    @RequestMapping(value={"/getPrice"})
    public List<PriceVO> getPrice(SkuEntity skuEntity) {
        List list = this.jdProductApi.getPrice(skuEntity);
        return list;
    }

    @RequestMapping(value={"/queryOrderTrack"})
    @ResponseBody
    public Map queryOrderTrack(@RequestParam Long jdOrderId) {
        JdOrderIdEntity jdOrderIdEntity = new JdOrderIdEntity();
        jdOrderIdEntity.setJdOrderId(jdOrderId);
        OrderTrackResp orderTrackResp = this.jdOrderApi.queryOrderTrack(jdOrderIdEntity);
        HashMap<String, OrderTrackResp> returnMap = new HashMap<String, OrderTrackResp>();
        returnMap.put("orderTrackResp", orderTrackResp);
        return returnMap;
    }

    @RequestMapping(value={"/queryOrderTracks"})
    @ResponseBody
    public Map queryOrderTracks(@RequestParam Long[] jdOrderIds) {
        HashMap<Long, OrderTrackResp> returnMap = new HashMap<Long, OrderTrackResp>();
        for (int i = 0; i < jdOrderIds.length; ++i) {
            Long jdOrderId = jdOrderIds[i];
            JdOrderIdEntity jdOrderIdEntity = new JdOrderIdEntity();
            jdOrderIdEntity.setJdOrderId(jdOrderId);
            OrderTrackResp orderTrackResp = this.jdOrderApi.queryOrderTrack(jdOrderIdEntity);
            returnMap.put(jdOrderId, orderTrackResp);
        }
        return returnMap;
    }

    @RequestMapping(value={"/getPriceSkus"})
    @ResponseBody
    public Map getPrice(@RequestParam(name="skus[]", required=true) String[] skus) {
        log.info((Object)"\u624b\u52a8\u8c03\u7528{}", (Object[])skus);
        HashMap<String, List> returnMap = new HashMap<String, List>();
        for (int i = 0; i < skus.length; ++i) {
            SkuEntity skuEntity = new SkuEntity();
            skuEntity.setSku(skus[i]);
            List list = this.jdProductApi.getPrice(skuEntity);
            returnMap.put(skus[i], list);
        }
        return returnMap;
    }

    @RequestMapping(value={"getStockForOrder/{sku}/{number}/{area}"})
    @ResponseBody
    public List<StockNewResultVo> getStockForOrder(@PathVariable Long sku, @PathVariable Integer number, @PathVariable String area) {
        StockForOrderEntity stockForOrderEntity = new StockForOrderEntity();
        StockVO stockVO = new StockVO();
        stockVO.setNum(number);
        stockVO.setSkuId(sku);
        stockForOrderEntity.setArea(area);
        stockForOrderEntity.setSkuNums(Arrays.asList(stockVO));
        List list = this.jdProductApi.getStockForOrder(stockForOrderEntity);
        return list;
    }

    @RequestMapping(value={"batchGetStock"})
    @ResponseBody
    public String batchGetStock() {
        this.jdProductApi.refreshCtStock();
        return "success";
    }

    @RequestMapping(value={"initBatchGetStock"})
    @ResponseBody
    public String initBatchGetStock() throws Exception {
        File in = new File(this.skuIdsInput);
        BufferedReader reader = new BufferedReader(new FileReader(in));
        String line = "";
        ArrayList<StockState> stockStates = new ArrayList<StockState>();
        while ((line = reader.readLine()) != null) {
            String[] lines = line.split(",");
            StockState stockState = new StockState();
            stockState.setSkuId(Long.valueOf(Long.parseLong(lines[0])));
            stockState.setAreaId("1_2802_2821_0");
            stockState.setRemainNum(Integer.valueOf(Integer.parseInt(lines[1])));
            stockState.setStockStateDesc(lines[2]);
            stockState.setStockStateId(Integer.valueOf(Integer.parseInt(lines[3])));
            stockStates.add(stockState);
            if (stockStates.size() <= 1000) continue;
            this.stockStateDao.save(stockStates);
            stockStates.clear();
        }
        if (stockStates.size() > 0) {
            this.stockStateDao.save(stockStates);
        }
        reader.close();
        return "success";
    }

    @RequestMapping(value={"/getMessage"})
    public List<MessageGetVO> getMessage(MessageTypeEntity messageTypeEntity) {
        List list = this.jdProductApi.getMessage(messageTypeEntity);
        return list;
    }

    @RequestMapping(value={"/getMessageByType"})
    public List<MessageGetVO> getMessageByType(String type) {
        for (int i = 0; i < 100; ++i) {
            log.info((Object)"\u8f93\u51fainfo  ");
            log.debug((Object)"\u8f93\u51fadebug+skkkw\u55e1\u55e1\u55e1kw");
            log.error((Object)"\u8f93\u51faerror  \u55e1\u55e1\u55e1\u6211");
        }
        MessageTypeEntity messageTypeEntity = new MessageTypeEntity(type);
        List list = this.jdProductApi.getMessage(messageTypeEntity);
        return list;
    }

    @RequestMapping(value={"/delMessage"})
    public Boolean delMessage(MessageDelEntity messageDelEntity) {
        Boolean b = this.jdProductApi.delMessage(messageDelEntity);
        return b;
    }

    @RequestMapping(value={"/getCategory"})
    public CategoryResp getCategory(CategoryEntity categoryEntity) {
        CategoryResp categoryResp = this.jdProductApi.getCategory(categoryEntity);
        return categoryResp;
    }

    @RequestMapping(value={"/getCategorys"})
    public CategorysResp getCategorys(CategorysEntity categorysEntity) {
        CategorysResp categorysResp = this.jdProductApi.getCategorys(categorysEntity);
        return categorysResp;
    }

    @RequestMapping(value={"/getAddress"})
    @ResponseBody
    public Map<String, Integer> getAddress(Integer parent, Integer lv) {
        Map address = null;
        AddressEntity addressEntity = new AddressEntity();
        addressEntity.setId(parent);
        switch (lv) {
            case 1: {
                address = this.jdAddressApi.getLevelOneAddress();
                break;
            }
            case 2: {
                address = this.jdAddressApi.getLevelTwoAddress(addressEntity);
                break;
            }
            case 3: {
                address = this.jdAddressApi.getLevelThreeAddress(addressEntity);
                break;
            }
            case 4: {
                address = this.jdAddressApi.getLevelFourAddress(addressEntity);
            }
        }
        return address;
    }

    @RequestMapping(value={"/placeOrder"})
    public OrderUniteSubmitResp placeOrder(@RequestParam Long skuId, @RequestParam Double price, @RequestParam String thirdOrderNo) {
        log.info((Object)"\u624b\u52a8\u8c03\u7528{}", new Object[]{skuId});
        OrderEntity orderEntity = new OrderEntity();
        orderEntity.setThirdOrder(thirdOrderNo);
        SkuIdAndNumEntity skuIdAndNumEntity = new SkuIdAndNumEntity(skuId, Integer.valueOf(4));
        orderEntity.setSku(Arrays.asList(skuIdAndNumEntity));
        orderEntity.setName("\u6731\u5a67\u73ae");
        orderEntity.setProvince(Integer.valueOf(2));
        orderEntity.setCity(Integer.valueOf(2830));
        orderEntity.setCounty(Integer.valueOf(51803));
        orderEntity.setTown(Integer.valueOf(0));
        orderEntity.setAddress("\u6c11\u751f\u8def1399\u53f7\u592a\u5e73\u4eba\u5bff\u5927\u53a61610");
        orderEntity.setMobile("15618967956");
        orderEntity.setEmail("jd@ec.cntaiping.com");
        orderEntity.setInvoiceState(JdOrderConstant.invoiceState);
        orderEntity.setInvoiceType(JdOrderConstant.invoiceType);
        orderEntity.setSelectedInvoiceTitle(JdOrderConstant.selectedInvoiceTitle);
        orderEntity.setInvoiceName("\u592a\u5e73\u91d1\u878d\u670d\u52a1\u6709\u9650\u516c\u53f8");
        orderEntity.setInvoiceContent(JdOrderConstant.invoiceContent);
        orderEntity.setPaymentType(JdOrderConstant.paymentType);
        orderEntity.setIsUseBalance(JdOrderConstant.isUseBalance);
        orderEntity.setSubmitState(JdOrderConstant.submitState);
        orderEntity.setDoOrderPriceMode(JdOrderConstant.doOrderPriceMode);
        orderEntity.setOrderPriceSnap(JSON.toJSONString(Arrays.asList(new OrderPriceSnap(BigDecimal.valueOf(price), skuId))));
        OrderUniteSubmitResp orderUniteSubmitResp = this.jdOrderApi.placeOrder(orderEntity);
        return orderUniteSubmitResp;
    }

    @RequestMapping(value={"/confirmOrder"})
    public OccupyStockResp confirmOrder(Long jdOrderId) {
        log.info((Object)"\u624b\u52a8\u8c03\u7528jdOrderId{}", new Object[]{jdOrderId});
        JdOrderIdEntity jdOrderIdEntity = new JdOrderIdEntity();
        jdOrderIdEntity.setJdOrderId(jdOrderId);
        OccupyStockResp occupyStockResp = this.jdOrderApi.confirmOccupyStock(jdOrderIdEntity);
        return occupyStockResp;
    }

    @RequestMapping(value={"/confirmOrders"})
    public Map confirmOrders(Long[] jdOrderIds) {
        HashMap<Long, OccupyStockResp> returnMap = new HashMap<Long, OccupyStockResp>();
        log.info((Object)"\u624b\u52a8\u8c03\u7528jdOrderId{}", (Object[])jdOrderIds);
        for (int i = 0; i < jdOrderIds.length; ++i) {
            Long jdOrderId = jdOrderIds[i];
            JdOrderIdEntity jdOrderIdEntity = new JdOrderIdEntity();
            jdOrderIdEntity.setJdOrderId(jdOrderId);
            OccupyStockResp occupyStockResp = this.jdOrderApi.confirmOccupyStock(jdOrderIdEntity);
            returnMap.put(jdOrderId, occupyStockResp);
        }
        return returnMap;
    }

    @RequestMapping(value={"/cancelOrder"})
    public OrderCancelOrderResp cancelOrder(JdOrderIdEntity jdOrderIdEntity) {
        log.info((Object)"\u624b\u52a8\u8c03\u7528jdOrderIdEntity{}", new Object[]{jdOrderIdEntity});
        OrderCancelOrderResp orderCancelOrderResp = this.jdOrderApi.cancelOrder(jdOrderIdEntity);
        return orderCancelOrderResp;
    }

    @RequestMapping(value={"/batchCancelOrder"})
    public Map batchCancelOrder(@RequestParam(name="orderNos[]", required=true) Long[] orderNos) {
        log.info((Object)"\u624b\u52a8\u8c03\u7528orderNos{}", (Object[])orderNos);
        HashMap<Long, OrderCancelOrderResp> returnMap = new HashMap<Long, OrderCancelOrderResp>();
        for (int i = 0; i < orderNos.length; ++i) {
            JdOrderIdEntity jdOrderIdEntity = new JdOrderIdEntity();
            jdOrderIdEntity.setJdOrderId(orderNos[i]);
            OrderCancelOrderResp orderCancelOrderResp = this.jdOrderApi.cancelOrder(jdOrderIdEntity);
            log.info((Object)"orderCancelOrderResp{}", new Object[]{orderCancelOrderResp});
            returnMap.put(orderNos[i], orderCancelOrderResp);
        }
        return returnMap;
    }

    @RequestMapping(value={"/queryOrderBySkus"})
    public Map queryOrder(@RequestParam(name="skus[]", required=true) Long[] skus) {
        HashMap<Object, Object> returnMap = new HashMap<Object, Object>();
        ArrayList<Long> statOne = new ArrayList<Long>();
        ArrayList<Long> statZero = new ArrayList<Long>();
        for (int i = 0; i < skus.length; ++i) {
            JdOrderIdEntity jdOrderIdEntity = new JdOrderIdEntity();
            jdOrderIdEntity.setJdOrderId(skus[i]);
            Map orderMap = this.jdOrderApi.queryOrder(jdOrderIdEntity);
            if (orderMap.get("submitState").equals(0)) {
                statZero.add(skus[i]);
            } else {
                statOne.add(skus[i]);
            }
            returnMap.put(skus[i], orderMap);
        }
        returnMap.put("0", statZero);
        returnMap.put("1", statOne);
        return returnMap;
    }

    @RequestMapping(value={"/queryOrder"})
    public Map queryOrder(JdOrderIdEntity jdOrderIdEntity) {
        Map orderMap = this.jdOrderApi.queryOrder(jdOrderIdEntity);
        return orderMap;
    }

    @RequestMapping(value={"/queryOrderByThirdOrder"})
    public OrderRevResp queryOrderByThirdOrder(ThirdOrder thirdOrder) {
        OrderRevResp orderRevResp = this.jdOrderApi.queryOrderByThirdOrder(thirdOrder);
        return orderRevResp;
    }

    @RequestMapping(value={"/queryFreight"})
    public OrderFreightVO queryOrderByThirdOrder() {
        OrderFreightEntity orderFreightEntity = new OrderFreightEntity();
        SkuIdAndNumEntity skuIdAndNumEntity = new SkuIdAndNumEntity(Long.valueOf(100143L), Integer.valueOf(1));
        orderFreightEntity.setProvince(Integer.valueOf(2));
        orderFreightEntity.setCity(Integer.valueOf(2830));
        orderFreightEntity.setCounty(Integer.valueOf(51803));
        orderFreightEntity.setTown(Integer.valueOf(0));
        orderFreightEntity.setPaymentType(Integer.valueOf(4));
        orderFreightEntity.setSku(Arrays.asList(skuIdAndNumEntity));
        OrderFreightVO orderFreightVO = this.jdOrderApi.queryFreight(orderFreightEntity).getResult();
        return orderFreightVO;
    }

    @RequestMapping(value={"/getBalance"})
    public Map getBalance(Integer payType) {
        OrderBalanceEntity orderBalanceEntity = new OrderBalanceEntity(payType);
        Map returnMap = this.jdOrderApi.getBalance(orderBalanceEntity);
        return returnMap;
    }

    @RequestMapping(value={"/resetProdCategory"})
    @Transactional
    public Map resetProdCategory(String skus) {
        String[] skuidsArray = skus.split(",");
        return this.categoryDbService.resetProdCategory(Arrays.asList(skuidsArray));
    }

    @RequestMapping(value={"/resetAllProdCategory"})
    public Map resetAllProdCategory() {
        return this.categoryDbService.restAllProdCateGory();
    }

    @RequestMapping(value={"/getAvailableNumber"})
    public AvailableNumberCompResp getAvailableNumber(OrderSkuEntity orderSkuEntity) {
        return this.jdAftersaleApi.getAvailableNumber(orderSkuEntity);
    }

    @RequestMapping(value={"/getCustomerExpect"})
    public CustomerExpectCompResp getCustomerExpect(OrderSkuEntity orderSkuEntity) {
        return this.jdAftersaleApi.getCustomerExpect(orderSkuEntity);
    }

    @RequestMapping(value={"/getWareReturnJd"})
    public WareReturnJdCompResp getWareReturnJd(OrderSkuEntity orderSkuEntity) {
        return this.jdAftersaleApi.getWareReturnJd(orderSkuEntity);
    }

    @RequestMapping(value={"/createServiceTicket"})
    public AfsApplyResp createServiceTicket(Long jdOrderId, Long skuId, Integer skuNum) {
        AfsApplyEntity afsApplyEntity = new AfsApplyEntity();
        afsApplyEntity.setJdOrderId(jdOrderId);
        afsApplyEntity.setCustomerExpect(Integer.valueOf(10));
        afsApplyEntity.setQuestionDesc("\u6d4b\u8bd5\u9000\u8d27\u529f\u80fd");
        afsApplyEntity.setIsNeedDetectionReport(Boolean.valueOf(false));
        AfterSaleCustomerDto asCustomerDto = new AfterSaleCustomerDto();
        asCustomerDto.setCustomerContactName("\u6731\u5a67\u73ae");
        asCustomerDto.setCustomerMobilePhone("15618967956");
        asCustomerDto.setCustomerTel("15618967956");
        asCustomerDto.setCustomerEmail("250577914@qq.com");
        asCustomerDto.setCustomerPostcode("200120");
        afsApplyEntity.setAsCustomerDto(asCustomerDto);
        AfterSalePickwareDto afterSalePickwareDto = new AfterSalePickwareDto();
        afterSalePickwareDto.setPickwareType(Integer.valueOf(40));
        afterSalePickwareDto.setPickwareProvince(Integer.valueOf(2));
        afterSalePickwareDto.setPickwareCity(Integer.valueOf(2830));
        afterSalePickwareDto.setPickwareCounty(Integer.valueOf(51803));
        afterSalePickwareDto.setPickwareVillage(Integer.valueOf(0));
        afterSalePickwareDto.setPickwareAddress("\u6c11\u751f\u8def1399\u53f7\u592a\u5e73\u4eba\u5bff\u5927\u53a61603");
        afsApplyEntity.setAsPickwareDto(afterSalePickwareDto);
        AfterSaleReturnwareDto afterSaleReturnwareDto = new AfterSaleReturnwareDto();
        afterSaleReturnwareDto.setReturnwareType(Integer.valueOf(10));
        afterSaleReturnwareDto.setReturnwareProvince(Integer.valueOf(2));
        afterSaleReturnwareDto.setReturnwareCity(Integer.valueOf(2830));
        afterSaleReturnwareDto.setReturnwareCounty(Integer.valueOf(51803));
        afterSaleReturnwareDto.setReturnwareVillage(Integer.valueOf(0));
        afterSaleReturnwareDto.setReturnwareAddress("\u6c11\u751f\u8def1399\u53f7\u592a\u5e73\u4eba\u5bff\u5927\u53a61603");
        afsApplyEntity.setAsReturnwareDto(afterSaleReturnwareDto);
        AfterSaleDetailDto afterSaleDetailDto = new AfterSaleDetailDto();
        afterSaleDetailDto.setSkuId(skuId);
        afterSaleDetailDto.setSkuNum(skuNum);
        afsApplyEntity.setAsDetailDto(afterSaleDetailDto);
        return this.jdAftersaleApi.createServiceTicket(afsApplyEntity);
    }

    @RequestMapping(value={"/getServiceListPage"})
    public ServiceListPageResp getServiceListPage(Long jdOrderId, Integer pageIndex, Integer pageSize) {
        ServiceListPageEntity serviceListPageEntity = new ServiceListPageEntity();
        serviceListPageEntity.setJdOrderId(jdOrderId);
        serviceListPageEntity.setPageIndex(pageIndex);
        serviceListPageEntity.setPageSize(pageSize);
        return this.jdAftersaleApi.getServiceListPage(serviceListPageEntity);
    }

    @RequestMapping(value={"/getServiceDetailInfo"})
    public ServiceDetailInfoResp getServiceDetailInfo(Long afsServiceId) {
        ServiceDetailInfoEntity serviceDetailInfoEntity = new ServiceDetailInfoEntity();
        serviceDetailInfoEntity.setAfsServiceId(afsServiceId);
        ArrayList<Integer> steps = new ArrayList<Integer>();
        steps.add(1);
        steps.add(2);
        steps.add(3);
        steps.add(4);
        steps.add(5);
        serviceDetailInfoEntity.setAppendInfoSteps(steps);
        return this.jdAftersaleApi.getServiceDetailInfo(serviceDetailInfoEntity);
    }

    @RequestMapping(value={"/cancelAudit"})
    public AuditCancelResp cancelAudit(Integer ... serviceIds) {
        AuditCancelEntity auditCancelEntity = new AuditCancelEntity();
        auditCancelEntity.setApproveNotes("\u53d6\u6d88\u670d\u52a1\u5355");
        ArrayList<Integer> serviceIdList = new ArrayList<Integer>();
        for (Integer serviceId : serviceIds) {
            serviceIdList.add(serviceId);
        }
        auditCancelEntity.setServiceIdList(serviceIdList);
        return this.jdAftersaleApi.cancelAudit(auditCancelEntity);
    }

    private void setContentColumnWidth(HSSFSheet sheet) {
        sheet.setColumnWidth(0, 5000);
        sheet.setColumnWidth(1, 5000);
        sheet.setColumnWidth(2, 5000);
        sheet.setColumnWidth(3, 50000);
    }

    private HSSFCellStyle setContentCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle cellStyle = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontName("\u9ed1\u4f53");
        font.setFontHeightInPoints((short)10);
        cellStyle.setFont(font);
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBorderLeft((short)1);
        cellStyle.setBorderRight((short)1);
        cellStyle.setBorderTop((short)1);
        cellStyle.setAlignment((short)2);
        return cellStyle;
    }

    private String setContentCellValue(String value) {
        if (Lang.isEmpty((Object)value)) {
            return "";
        }
        return value;
    }

    private void createCellHead(HSSFRow row, HSSFCellStyle cellStyle, HSSFCell cell) {
        cell.setCellStyle(cellStyle);
        cell.setCellValue("\u5546\u54c1\u6c60\u540d\u79f0");
        cell = row.createCell(1);
        cell.setCellValue("\u5546\u54c1\u6c60\u7f16\u53f7");
        cell = row.createCell(2);
        cell.setCellValue("sku");
        cell = row.createCell(3);
        cell.setCellValue("\u5546\u54c1\u540d\u79f0");
        cell = row.createCell(4);
    }

    private void createCellContent(List<Map> writeExcelList, HSSFCellStyle cellStyle, HSSFSheet sheet) {
        for (int i = 0; i < writeExcelList.size(); ++i) {
            int rowCount = i + 1;
            HSSFRow row = sheet.createRow(rowCount);
            Map returnMap = writeExcelList.get(i);
            HSSFCell theCell = row.createCell(0);
            theCell.setCellStyle(cellStyle);
            theCell.setCellValue(this.setContentCellValue((String)returnMap.get("poolsName")));
            theCell = row.createCell(1);
            theCell.setCellValue(this.setContentCellValue((String)returnMap.get("pageNum")));
            theCell = row.createCell(2);
            theCell.setCellValue(this.setContentCellValue((String)returnMap.get("sku")));
            theCell = row.createCell(3);
            theCell.setCellValue(this.setContentCellValue((String)returnMap.get("name")));
        }
    }

    @RequestMapping(value={"jd/initGoodsPriceAndState"})
    public Object initGoodsPriceAndState() {
        return null;
    }
}

