/*
 * Decompiled with CFR 0.152.
 */
package jd.service.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jd.api.request.product.CategorysEntity;
import jd.api.request.product.PageNumEntity;
import jd.api.response.product.CategorysResp;
import jd.api.service.product.JdProductApi;
import jd.service.service.CategoryDbService;
import jd.service.service.ProductDbInitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.Lang;
import utils.log.Log;
import utils.log.Logs;

@Controller
@RequestMapping(value={"prod"})
public class JdProductController {
    private static final Log log = Logs.getLog((String)JdProductController.class.getName());
    @Autowired
    ProductDbInitService productDbInitService;
    @Autowired
    CategoryDbService categoryDbService;
    @Autowired
    JdProductApi jdProductApi;
    List<Long> productNos;
    List<Long> productNosList;
    int totalNum;

    @RequestMapping(value={"asyncInitProduct"})
    @ResponseBody
    public String asyncInitProduct(@RequestParam Boolean isCompatible, @RequestParam(name="isThread", required=true) Boolean isThread, @RequestParam(name="poolSize") Integer poolSize) {
        this.productDbInitService.asyncInitProduct(isCompatible, isThread, poolSize);
        return "asyncInitProduct";
    }

    @RequestMapping(value={"/synchronizData"})
    @ResponseBody
    public Map synchronizData(@RequestParam(name="skus[]", required=true) String[] skus, @RequestParam(name="isThread", required=true) Boolean isThread, @RequestParam(name="poolSize") Integer poolSize) {
        HashMap<String, List> returnMap = new HashMap<String, List>();
        HashSet<Long> productNoSet = new HashSet<Long>();
        ArrayList goodsIds = new ArrayList();
        for (String sku : skus) {
            productNoSet.add(Long.parseLong(sku));
        }
        this.productNosList = new ArrayList(productNoSet);
        this.totalNum = this.productNosList.size();
        this.productDbInitService.executorsPoolAdd(this.productNosList, this.totalNum, isThread, poolSize);
        returnMap.put("skus", this.productNosList);
        return returnMap;
    }

    @RequestMapping(value={"/asyncInitProdByProductPool"})
    @ResponseBody
    public Map asyncInitProdByPool(@RequestParam(name="poolsNums[]", required=true) String[] poolsNums, @RequestParam(name="isCompatible", required=true) Boolean isCompatible, @RequestParam(name="isThread", required=true) Boolean isThread, @RequestParam(name="poolSize") Integer poolSize) {
        HashSet productNoSet = new HashSet();
        HashMap<String, List> returnMap = new HashMap<String, List>();
        for (String poolsNum : poolsNums) {
            this.productNos = isCompatible != false ? this.jdProductApi.getProductPoolProductOld(new PageNumEntity(poolsNum, Integer.valueOf(1))) : this.jdProductApi.getProductPoolProduct(new PageNumEntity(poolsNum));
            productNoSet.addAll(this.productNos);
        }
        this.productNosList = new ArrayList(productNoSet);
        this.totalNum = this.productNosList.size();
        this.productDbInitService.executorsPoolAdd(this.productNosList, this.totalNum, isThread, poolSize);
        returnMap.put("skus", this.productNosList);
        return returnMap;
    }

    @RequestMapping(value={"getCategorys/{pageNo}/{pageSize}/{catClass}"})
    @ResponseBody
    public CategorysResp queryCategorysByCatclass(@PathVariable Integer pageNo, @PathVariable Integer pageSize, @PathVariable Integer catClass) {
        return this.productDbInitService.getCategorys(new CategorysEntity(pageNo, pageSize, null, catClass));
    }

    @RequestMapping(value={"getCategorysByParent/{pageNo}/{pageSize}/{parentId}"})
    @ResponseBody
    public CategorysResp queryCategorysByParent(@PathVariable Integer pageNo, @PathVariable Integer pageSize, @PathVariable Integer parentId) {
        return this.productDbInitService.getCategorys(new CategorysEntity(pageNo, pageSize, parentId, null));
    }

    @RequestMapping(value={"batchDelete"})
    @ResponseBody
    public String batchDelete() {
        this.productDbInitService.batchDelete();
        return "batchDelete";
    }

    @RequestMapping(value={"initCategory"})
    @ResponseBody
    public String initCategory() {
        this.categoryDbService.initCategory();
        return "initCategory";
    }

    @RequestMapping(value={"categoryMatch"})
    @ResponseBody
    public String categoryMatch() {
        this.categoryDbService.matchCategory();
        return "categoryMatch";
    }

    @RequestMapping(value={"deleteCategoryMatch"})
    @ResponseBody
    public String deleteCategoryMatch() {
        this.categoryDbService.deleteCategoryMatch();
        return "deleteCategoryMatch";
    }

    @RequestMapping(value={"initProductPool"})
    @ResponseBody
    public Map initProductPool(Integer poolSize) {
        if (Lang.isEmpty((Object)poolSize)) {
            poolSize = 5;
        }
        Map returnMap = this.productDbInitService.initProductPool(poolSize);
        return returnMap;
    }
}

