/*
 * Decompiled with CFR 0.152.
 */
package jdek.service.jdekapi.JdekApiImpl;

import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import java.util.ArrayList;
import java.util.HashMap;
import jd.service.service.JdSystemLogService;
import jdek.api.request.JdekDelMessageEntity;
import jdek.api.request.JdekGetBalanceEntity;
import jdek.api.request.JdekGetMessageEntity;
import jdek.api.request.JdekOrderEntity;
import jdek.api.request.JdekRepayEntity;
import jdek.api.request.JdekSerchByThirdOrderEntity;
import jdek.api.request.JdekSerchOrderEntity;
import jdek.api.request.JdekSmsReissueEntity;
import jdek.api.response.JdekDelMessageResp;
import jdek.api.response.JdekGetMessageResp;
import jdek.api.response.JdekOrderResp;
import jdek.api.response.JdekRepayResp;
import jdek.api.response.JdekSerchByThirdOrderResp;
import jdek.api.response.JdekSerchOrderResp;
import jdek.api.service.JdekApi;
import jdek.api.vo.JdekBalanceVo;
import jdek.api.vo.JdekInfoVo;
import jdek.api.vo.JdekOrderVo;
import jdek.api.vo.JdekSerchByThirdOrderVo;
import jdek.api.vo.JdekSmsReissueVo;
import jdek.service.jdekapi.token.TokenServiceJdek;
import jdek.service.retrofit.api.JdekRestApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import retrofit2.Call;
import retrofit2.Retrofit;
import utils.Lang;

@MotanService
public class JdekApiImpl
implements JdekApi {
    private Retrofit retrofit;
    private TokenServiceJdek tokenServiceJdek;
    private JdekRestApi jdekRestApi;
    @Autowired
    JdSystemLogService jdSystemLogService;
    public static final Logger logger = LoggerFactory.getLogger(JdekApiImpl.class);

    public JdekApiImpl(Retrofit retrofitJdek, TokenServiceJdek tokenServiceJdek) {
        this.retrofit = retrofitJdek;
        this.tokenServiceJdek = tokenServiceJdek;
        this.jdekRestApi = (JdekRestApi)this.retrofit.create(JdekRestApi.class);
    }

    public JdekDelMessageResp delMessage(JdekDelMessageEntity delMessageEntity) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("token", this.tokenServiceJdek.accessToken());
            map.put("id", delMessageEntity.getId());
            Call call = this.jdekRestApi.delMessage(Lang.filterNullMap(map, (Boolean)false));
            JdekDelMessageResp result = (JdekDelMessageResp)call.execute().body();
            this.jdSystemLogService.asyncSysLog(call.request().url().toString(), (Object)JSONObject.toJSONString(map), (Object)JSONObject.toJSONString((Object)result), null, null);
            return result;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public JdekBalanceVo getBalance(JdekGetBalanceEntity jdekGetBalanceEntity) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("token", this.tokenServiceJdek.accessToken());
            map.put("type", jdekGetBalanceEntity.getType());
            Call call = this.jdekRestApi.getBalance(Lang.filterNullMap(map, (Boolean)false));
            JdekBalanceVo result = (JdekBalanceVo)call.execute().body();
            this.jdSystemLogService.asyncSysLog(call.request().url().toString(), (Object)JSONObject.toJSONString(map), (Object)JSONObject.toJSONString((Object)result), null, null);
            return result;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public JdekGetMessageResp getMessage(JdekGetMessageEntity jdekGetMessageEntity) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("token", this.tokenServiceJdek.accessToken());
            map.put("del", jdekGetMessageEntity.getDel());
            map.put("type", jdekGetMessageEntity.getType());
            Call call = this.jdekRestApi.getMessage(Lang.filterNullMap(map, (Boolean)false));
            JdekGetMessageResp result = (JdekGetMessageResp)call.execute().body();
            this.jdSystemLogService.asyncSysLog(call.request().url().toString(), (Object)JSONObject.toJSONString(map), (Object)JSONObject.toJSONString((Object)result), null, null);
            return result;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public JdekOrderVo placeOrder(JdekOrderEntity jdekOrderEntity) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("token", this.tokenServiceJdek.accessToken());
            map.put("thirdOrder", jdekOrderEntity.getThirdOrder());
            map.put("sku", JSONObject.toJSONString((Object)jdekOrderEntity.getSku()));
            map.put("mobile", "00000000000");
            map.put("paymentType", jdekOrderEntity.getPaymentType());
            map.put("ifSendMsg", jdekOrderEntity.getIfSendMsg());
            Call call = this.jdekRestApi.placeOrder(Lang.filterNullMap(map, (Boolean)false));
            JdekOrderResp temp = (JdekOrderResp)call.execute().body();
            if ("0".equals(temp.getResultCode())) {
                JdekOrderVo result = temp.getResult();
                this.jdSystemLogService.asyncSysLog(call.request().url().toString(), (Object)JSONObject.toJSONString(map), (Object)JSONObject.toJSONString((Object)result), null, null);
                return result;
            }
            return null;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public JdekRepayResp Repay(JdekRepayEntity jdekRepayEntity) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("token", this.tokenServiceJdek.accessToken());
            map.put("jdOrderId", jdekRepayEntity.getJdOrderId());
            Call call = this.jdekRestApi.repay(Lang.filterNullMap(map, (Boolean)false));
            JdekRepayResp result = (JdekRepayResp)call.execute().body();
            this.jdSystemLogService.asyncSysLog(call.request().url().toString(), (Object)JSONObject.toJSONString(map), (Object)JSONObject.toJSONString((Object)result), null, null);
            return result;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public JdekSerchByThirdOrderVo selectByThirdOrder(JdekSerchByThirdOrderEntity jdekSerchByThirdOrderEntity) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("token", this.tokenServiceJdek.accessToken());
            map.put("thirdOrder", jdekSerchByThirdOrderEntity.getThirdOrder());
            Call call = this.jdekRestApi.selectByThirdOrder(Lang.filterNullMap(map, (Boolean)false));
            JdekSerchByThirdOrderResp temp = (JdekSerchByThirdOrderResp)call.execute().body();
            if ("0".equals(temp.getResultCode())) {
                JdekSerchByThirdOrderVo result = ((JdekSerchByThirdOrderResp)call.execute().body()).getResult();
                this.jdSystemLogService.asyncSysLog(call.request().url().toString(), (Object)JSONObject.toJSONString(map), (Object)JSONObject.toJSONString((Object)result), null, null);
                return result;
            }
            return null;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public ArrayList<JdekInfoVo> getJdekOrderInfo(JdekSerchOrderEntity jdekSerchOrderEntity) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("token", this.tokenServiceJdek.accessToken());
            map.put("jdOrderId", jdekSerchOrderEntity.getJdOrderId());
            Call call = this.jdekRestApi.getJdekOrderInfo(Lang.filterNullMap(map, (Boolean)false));
            JdekSerchOrderResp temp = (JdekSerchOrderResp)call.execute().body();
            if ("0".equals(temp.getResultCode())) {
                ArrayList result = temp.getResult();
                this.jdSystemLogService.asyncSysLog(call.request().url().toString(), (Object)JSONObject.toJSONString(map), (Object)JSONObject.toJSONString((Object)result), null, null);
                return result;
            }
            return null;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public JdekSmsReissueVo sendMessageAgin(JdekSmsReissueEntity jdekSmsReissueEntity) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("token", this.tokenServiceJdek.accessToken());
            map.put("jdOrderId", jdekSmsReissueEntity.getJdOrderId());
            map.put("mobile", jdekSmsReissueEntity.getMobile());
            Call call = this.jdekRestApi.sendMessageAgin(Lang.filterNullMap(map, (Boolean)false));
            JdekSmsReissueVo result = (JdekSmsReissueVo)call.execute().body();
            this.jdSystemLogService.asyncSysLog(call.request().url().toString(), (Object)JSONObject.toJSONString(map), (Object)JSONObject.toJSONString((Object)result), null, null);
            return result;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

