/*
 * Decompiled with CFR 0.152.
 */
package jdek.service.jdekapi.token;

import com.alibaba.fastjson.JSON;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import jd.service.service.JdSystemLogService;
import jdek.service.jdekapi.token.TokenResponseJdek;
import jdek.service.jdekapi.token.TokenVO;
import jdek.service.jdekapi.token.UserEntity;
import jdek.service.retrofit.api.AbstractJdApi;
import jdek.service.retrofit.api.JDAuthApi;
import jdek.service.retrofit.config.RetrofitConfigVoJdek;
import jdek.service.retrofit.converter.BeanToMapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;
import utils.Lang;
import utils.security.MD5Utils;

@Service
public class TokenServiceJdek
extends AbstractJdApi {
    private static final Logger logger = LoggerFactory.getLogger(TokenServiceJdek.class);
    private Retrofit retrofitjdek;
    public final String accessTokenStr = "szjdapi:jdekTokenData";
    private JDAuthApi JDAuthApi;
    private volatile TokenVO tokenVO = null;
    @Autowired
    RetrofitConfigVoJdek retrofitConfigVoJdek;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    JdSystemLogService jdSystemLogService;

    public void setTokenVO(TokenVO tokenVO) {
        this.tokenVO = tokenVO;
    }

    @PostConstruct
    private void inited() {
        logger.info("JD access token :{}", (Object)this.getToken(false));
    }

    public TokenServiceJdek(@Value(value="${retrofitJdek.tokenUrl}") String tokenUrl) {
        this.retrofitjdek = new Retrofit.Builder().baseUrl(tokenUrl).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build();
        this.JDAuthApi = (JDAuthApi)this.retrofitjdek.create(JDAuthApi.class);
    }

    public String accessToken() {
        TokenVO tokenVO = this.getToken(false);
        if (tokenVO == null || "null".equals(tokenVO)) {
            tokenVO = this.getTokenVO(this.retrofitConfigVoJdek.getUserEntity());
            if (tokenVO != null) {
                BoundValueOperations accessTokenOp = this.redisTemplate.boundValueOps((Object)"szjdapi:jdekTokenData");
                accessTokenOp.set((Object)JSON.toJSONString((Object)tokenVO));
                this.tokenVO = tokenVO;
            } else {
                logger.error("\u83b7\u53d6token\u5f02\u5e38");
            }
            return tokenVO.getAccess_token();
        }
        return tokenVO.getAccess_token();
    }

    public TokenVO getToken(boolean force) {
        BoundValueOperations accessTokenOp = this.redisTemplate.boundValueOps((Object)"szjdapi:jdekTokenData");
        if (!force) {
            if (this.tokenVO != null) {
                return this.tokenVO;
            }
            String tokenData = (String)accessTokenOp.get();
            if (tokenData == null || "".equals(tokenData.trim()) || "null".equals(tokenData)) {
                TokenVO tokenVO = this.getTokenVO(this.retrofitConfigVoJdek.getUserEntity());
                if (tokenVO != null) {
                    accessTokenOp.set((Object)JSON.toJSONString((Object)tokenVO));
                }
                this.tokenVO = tokenVO;
            } else {
                try {
                    this.tokenVO = (TokenVO)JSON.parseObject((String)tokenData, TokenVO.class);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        } else {
            TokenVO tokenVO = this.getTokenVO(this.retrofitConfigVoJdek.getUserEntity());
            if (tokenVO != null) {
                accessTokenOp.set((Object)JSON.toJSONString((Object)tokenVO));
                this.tokenVO = tokenVO;
            }
        }
        return this.tokenVO;
    }

    private TokenVO getTokenVO(UserEntity user) {
        try {
            user.setTimestamp(((DateFormat)this.sdf.get()).format(new Date()));
            user.setSign(this.createSign(user));
            Map map = BeanToMapUtil.convertBean((Object)user);
            Call response = this.JDAuthApi.accessToken(Lang.filterNullMap((Map)map, (Boolean)false));
            TokenVO token = null;
            if (response != null) {
                TokenResponseJdek body = (TokenResponseJdek)response.execute().body();
                logger.info("getTokenVO {}", (Object)JSON.toJSONString((Object)body.getResult()));
                token = body.getResult();
            }
            return token;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public TokenVO refreshToken() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("refresh_token", this.tokenVO.getRefresh_token());
        map.put("client_id", this.retrofitConfigVoJdek.getUserEntity().getClient_id());
        map.put("client_secret", this.retrofitConfigVoJdek.getUserEntity().getClient_secret());
        Call call = this.JDAuthApi.refreshToken(map);
        try {
            TokenVO result;
            this.tokenVO = result = (TokenVO)call.execute().body();
            BoundValueOperations accessTokenOp = this.redisTemplate.boundValueOps((Object)"szjdapi:jdekTokenData");
            accessTokenOp.set((Object)JSON.toJSONString((Object)this.tokenVO));
            logger.info("refreshToken {}", (Object)JSON.toJSONString((Object)result));
            logger.info("\u5b9a\u65f6\u5237\u65b0 tokenVO {}", (Object)JSON.toJSONString((Object)this.tokenVO));
            return this.tokenVO;
        }
        catch (Exception e) {
            this.jdSystemLogService.asyncSysLog(null, null, null, null, e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String createSign(UserEntity user) {
        String username = user.getUsername();
        String password = user.getPassword();
        String timestamp = user.getTimestamp();
        String clientSecret = user.getClient_secret();
        String clientId = user.getClient_id();
        String sign = clientSecret + timestamp + clientId + username + password + "access_token" + clientSecret;
        return MD5Utils.MD5Encode((String)sign, (String)"utf-8").toUpperCase();
    }
}

