/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.row.ValueMetaInterface;

public class GuptaDatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    @Override
    public int[] getAccessTypeList() {
        return new int[]{0, 1, 4};
    }

    @Override
    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 2155;
        }
        return -1;
    }

    @Override
    public boolean supportsAutoInc() {
        return false;
    }

    @Override
    public String getDriverClass() {
        if (this.getAccessType() == 1) {
            return "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        return "jdbc.gupta.sqlbase.SqlbaseDriver";
    }

    @Override
    public String getURL(String hostname, String port, String databaseName) {
        if (this.getAccessType() == 1) {
            return "jdbc:odbc:" + databaseName;
        }
        return "jdbc:sqlbase://" + hostname + ":" + port + "/" + databaseName;
    }

    @Override
    public boolean isFetchSizeSupported() {
        return false;
    }

    @Override
    public boolean supportsBitmapIndex() {
        return false;
    }

    @Override
    public boolean supportsCatalogs() {
        return false;
    }

    @Override
    public boolean supportsTimeStampToDateConversion() {
        return false;
    }

    @Override
    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        String retval = "";
        retval = retval + "ALTER TABLE " + tablename + " DROP " + v.getName() + Const.CR + ";" + Const.CR;
        retval = retval + "ALTER TABLE " + tablename + " ADD " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
        return retval;
    }

    @Override
    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval = retval + "DATETIME NULL";
                break;
            }
            case 4: {
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    retval = retval + "INTEGER NOT NULL";
                    break;
                }
                if (length < 0 && precision < 0 || precision > 0 || length > 9) {
                    retval = retval + "DOUBLE PRECISION";
                    break;
                }
                retval = retval + "INTEGER";
                break;
            }
            case 2: {
                if (length > 254 || length < 0) {
                    retval = retval + "LONG VARCHAR";
                    break;
                }
                retval = retval + "VARCHAR(" + length + ")";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (add_cr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"SQLBaseJDBC.jar"};
    }

    @Override
    public boolean isSystemTable(String tableName) {
        return tableName.startsWith("SYS");
    }

    @Override
    public boolean supportsPreparedStatementMetadataRetrieval() {
        return false;
    }
}

