/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LogMessageInterface;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.util.StringUtil;

public class LogMessage
implements LogMessageInterface {
    private String logChannelId;
    private String message;
    private String subject;
    private Object[] arguments;
    private LogLevel level;
    private String copy;

    public LogMessage(String subject, LogLevel level) {
        this.subject = subject;
        this.level = level;
        this.message = null;
        this.logChannelId = null;
    }

    public LogMessage(String message, String logChannelId, LogLevel level) {
        this.message = message;
        this.logChannelId = logChannelId;
        this.level = level;
        this.lookupSubject();
    }

    public LogMessage(String message, String logChannelId, Object[] arguments, LogLevel level) {
        this.message = message;
        this.logChannelId = logChannelId;
        this.arguments = arguments;
        this.level = level;
        this.lookupSubject();
    }

    private void lookupSubject() {
        boolean detailedLogTurnOn;
        LoggingObjectInterface loggingObject = LoggingRegistry.getInstance().getLoggingObject(this.logChannelId);
        boolean bl = detailedLogTurnOn = "Y".equals(EnvUtil.getSystemProperty("KETTLE_LOG_MARK_MAPPINGS"));
        if (loggingObject != null) {
            this.subject = !detailedLogTurnOn ? loggingObject.getObjectName() : this.getDetailedSubject(loggingObject);
            this.copy = loggingObject.getObjectCopy();
        }
    }

    private String getDetailedSubject(LoggingObjectInterface loggingObject) {
        List<String> subjects = this.getSubjectTree(loggingObject);
        return subjects.size() > 1 ? this.formatDetailedSubject(subjects) : subjects.get(0);
    }

    private List<String> getSubjectTree(LoggingObjectInterface loggingObject) {
        ArrayList<String> subjects = new ArrayList<String>();
        while (loggingObject != null) {
            subjects.add(loggingObject.getObjectName());
            loggingObject = loggingObject.getParent();
        }
        return subjects;
    }

    private String formatDetailedSubject(List<String> subjects) {
        StringBuilder string = new StringBuilder();
        int currentStep = 0;
        int rootStep = subjects.size() - 1;
        for (int i = rootStep - 1; i > currentStep; --i) {
            string.append("[").append(subjects.get(i)).append("]").append(".");
        }
        string.append(subjects.get(currentStep));
        return string.toString();
    }

    @Deprecated
    public String toString() {
        if (StringUtils.isBlank((String)this.message)) {
            return this.subject;
        }
        if (StringUtils.isBlank((String)this.subject)) {
            return this.getMessage();
        }
        return String.format("%s - %s", this.subject, this.getMessage());
    }

    @Override
    public LogLevel getLevel() {
        return this.level;
    }

    @Deprecated
    public void setLevel(LogLevel level) {
        this.level = level;
    }

    @Override
    public String getMessage() {
        String formatted = this.message;
        if (this.arguments != null) {
            ArrayList<String> tokens = new ArrayList<String>();
            StringUtil.getUsedVariables(formatted, "{", "}", tokens, true);
            for (String token : tokens) {
                try {
                    MessageFormat.format("{" + token + "}", this.arguments);
                }
                catch (IllegalArgumentException iar) {
                    formatted = formatted.replaceAll("\\{" + token + "\\}", "\\'{'" + token + "\\'}'");
                }
            }
            formatted = MessageFormat.format(formatted, this.arguments);
        }
        return formatted;
    }

    @Deprecated
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Deprecated
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public String getLogChannelId() {
        return this.logChannelId;
    }

    @Deprecated
    public void setLogChannelId(String logChannelId) {
        this.logChannelId = logChannelId;
    }

    @Override
    public Object[] getArguments() {
        return this.arguments;
    }

    @Deprecated
    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    public boolean isError() {
        return this.level.isError();
    }

    @Override
    public String getCopy() {
        return this.copy;
    }

    public void setCopy(String copy) {
        this.copy = copy;
    }
}

