/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.List;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Larders;
import mondrian.olap.Level;
import mondrian.olap.MatchType;
import mondrian.olap.OlapElement;
import mondrian.olap.OlapElementBase;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;

public abstract class HierarchyBase
extends OlapElementBase
implements Hierarchy {
    protected final Dimension dimension;
    protected final String name;
    protected final String uniqueName;
    protected final boolean hasAll;

    protected HierarchyBase(Dimension dimension, String subName, String uniqueName, boolean visible, boolean hasAll) {
        this.dimension = dimension;
        this.hasAll = hasAll;
        this.visible = visible;
        assert (subName != null);
        this.name = subName;
        this.uniqueName = uniqueName;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getUniqueNameSsas() {
        return Util.makeFqName(this.dimension, this.name);
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        return MondrianResource.instance().MdxHierarchyName.str(this.getUniqueName());
    }

    public abstract boolean isRagged();

    public String getDescription() {
        return Larders.getDescription(this.getLarder());
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    @Deprecated
    public Level[] getLevels() {
        List levelList = this.getLevelList();
        return levelList.toArray(new Level[levelList.size()]);
    }

    public Hierarchy getHierarchy() {
        return this;
    }

    public final boolean hasAll() {
        return this.hasAll;
    }

    public boolean equals(OlapElement mdxElement) {
        return this == mdxElement;
    }

    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment s, MatchType matchType) {
        OlapElement oe;
        if (s instanceof Id.NameSegment) {
            Id.NameSegment nameSegment = (Id.NameSegment)s;
            oe = Util.lookupHierarchyLevel(this, nameSegment.getName());
            if (oe == null) {
                oe = Util.lookupHierarchyRootMember(schemaReader, this, nameSegment, matchType);
            }
        } else {
            Id.KeySegment keySegment = (Id.KeySegment)s;
            List levelList = this.getLevelList();
            oe = ((Level)Util.last(levelList)).lookupChild(schemaReader, keySegment, matchType);
        }
        if (this.getLogger().isDebugEnabled()) {
            StringBuilder buf = new StringBuilder(64);
            buf.append("HierarchyBase.lookupChild: ");
            buf.append("name=");
            buf.append(this.getName());
            buf.append(", childname=");
            buf.append(s);
            if (oe == null) {
                buf.append(" returning null");
            } else {
                buf.append(" returning elementname=").append(oe.getName());
            }
            this.getLogger().debug((Object)buf.toString());
        }
        return oe;
    }
}

